/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.preferences;

import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.preference.ColorFieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.team.svn.ui.SVNUIMessages;
import org.eclipse.team.svn.ui.preferences.AbstractSVNTeamPreferencesPage;
import org.eclipse.team.svn.ui.preferences.SVNTeamPreferences;
import org.eclipse.team.svn.ui.verifier.CompositeVerifier;
import org.eclipse.team.svn.ui.verifier.IntegerFieldVerifier;
import org.eclipse.team.svn.ui.verifier.NonEmptyFieldVerifier;
import org.eclipse.ui.PlatformUI;

public class SVNTeamConsolePreferencesPage
extends AbstractSVNTeamPreferencesPage {
    protected ColorFieldEditor cmdEditor;
    protected ColorFieldEditor okEditor;
    protected ColorFieldEditor wrnEditor;
    protected ColorFieldEditor errEditor;
    protected boolean enabled;
    protected boolean hyperlinksEnabled;
    protected int autoshow;
    protected boolean wrapEnabled;
    protected boolean limitEnabled;
    protected int wrapWidth;
    protected int limitValue;
    protected Button enabledButton;
    protected Button hyperlinksEnabledButton;
    protected Button showNeverButton;
    protected Button showAlwaysButton;
    protected Button showErrorButton;
    protected Button showWarningErrorButton;
    protected Button wrapEnabledButton;
    protected Button limitEnabledButton;
    protected Text wrapWidthText;
    protected Text limitValueText;

    protected void saveValues(IPreferenceStore store) {
        this.cmdEditor.store();
        this.okEditor.store();
        this.wrnEditor.store();
        this.errEditor.store();
        SVNTeamPreferences.setConsoleInt(store, "autoshow", this.autoshow);
        SVNTeamPreferences.setConsoleBoolean(store, "enabled", this.enabled);
        SVNTeamPreferences.setConsoleBoolean(store, "hyperlinksEnabled", this.hyperlinksEnabled);
        SVNTeamPreferences.setConsoleBoolean(store, "wrapEnabled", this.wrapEnabled);
        SVNTeamPreferences.setConsoleInt(store, "wrapWidth", this.wrapWidth);
        SVNTeamPreferences.setConsoleBoolean(store, "limitEnabled", this.limitEnabled);
        SVNTeamPreferences.setConsoleInt(store, "limitRange", this.limitValue);
    }

    protected void loadDefaultValues(IPreferenceStore store) {
        this.autoshow = 0;
        this.enabled = true;
        this.hyperlinksEnabled = true;
        this.wrapEnabled = false;
        this.wrapWidth = 80;
        this.limitEnabled = true;
        this.limitValue = 500000;
        this.cmdEditor.loadDefault();
        this.okEditor.loadDefault();
        this.wrnEditor.loadDefault();
        this.errEditor.loadDefault();
    }

    protected void loadValues(IPreferenceStore store) {
        this.autoshow = SVNTeamPreferences.getConsoleInt(store, "autoshow");
        this.enabled = SVNTeamPreferences.getConsoleBoolean(store, "enabled");
        this.hyperlinksEnabled = SVNTeamPreferences.getConsoleBoolean(store, "hyperlinksEnabled");
        this.wrapEnabled = SVNTeamPreferences.getConsoleBoolean(store, "wrapEnabled");
        this.wrapWidth = SVNTeamPreferences.getConsoleInt(store, "wrapWidth");
        this.limitEnabled = SVNTeamPreferences.getConsoleBoolean(store, "limitEnabled");
        this.limitValue = SVNTeamPreferences.getConsoleInt(store, "limitRange");
        this.cmdEditor.load();
        this.okEditor.load();
        this.wrnEditor.load();
        this.errEditor.load();
    }

    protected void initializeControls() {
        this.showNeverButton.setSelection(false);
        this.showAlwaysButton.setSelection(false);
        this.showErrorButton.setSelection(false);
        if (this.autoshow == 0) {
            this.showNeverButton.setSelection(true);
        } else if (this.autoshow == 1) {
            this.showAlwaysButton.setSelection(true);
        } else if (this.autoshow == 2) {
            this.showErrorButton.setSelection(true);
        } else {
            this.showWarningErrorButton.setSelection(true);
        }
        this.enabledButton.setSelection(this.enabled);
        this.hyperlinksEnabledButton.setSelection(this.hyperlinksEnabled);
        this.wrapEnabledButton.setSelection(this.wrapEnabled);
        this.wrapWidthText.setEnabled(this.wrapEnabled);
        this.wrapWidthText.setText(String.valueOf(this.wrapWidth));
        this.limitEnabledButton.setSelection(this.limitEnabled);
        this.limitValueText.setEnabled(this.limitEnabled);
        this.limitValueText.setText(String.valueOf(this.limitValue));
    }

    protected Control createContentsImpl(Composite parent) {
        Composite composite = new Composite(parent, 4);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        data.grabExcessVerticalSpace = false;
        composite.setLayoutData((Object)data);
        this.enabledButton = new Button(composite, 32);
        data = new GridData();
        data.horizontalSpan = 2;
        this.enabledButton.setLayoutData((Object)data);
        this.enabledButton.setText(SVNUIMessages.ConsolePreferencePage_textIsEnabled);
        this.enabledButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                SVNTeamConsolePreferencesPage.this.enabled = SVNTeamConsolePreferencesPage.this.enabledButton.getSelection();
            }
        });
        this.hyperlinksEnabledButton = new Button(composite, 32);
        data = new GridData();
        data.horizontalSpan = 2;
        this.hyperlinksEnabledButton.setLayoutData((Object)data);
        this.hyperlinksEnabledButton.setText(SVNUIMessages.ConsolePreferencePage_hyperlinksIsEnabled);
        this.hyperlinksEnabledButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                SVNTeamConsolePreferencesPage.this.hyperlinksEnabled = SVNTeamConsolePreferencesPage.this.hyperlinksEnabledButton.getSelection();
            }
        });
        Group showType = new Group(composite, 4);
        showType.setText(SVNUIMessages.ConsolePreferencePage_textShowOnGroup);
        layout = new GridLayout();
        layout.numColumns = 4;
        layout.horizontalSpacing = 10;
        showType.setLayout((Layout)layout);
        data = new GridData(768);
        data.horizontalSpan = 2;
        data.grabExcessVerticalSpace = false;
        showType.setLayoutData((Object)data);
        this.showNeverButton = new Button((Composite)showType, 16);
        data = new GridData();
        this.showNeverButton.setLayoutData((Object)data);
        this.showNeverButton.setText(SVNUIMessages.ConsolePreferencePage_textShowNever);
        this.showNeverButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (SVNTeamConsolePreferencesPage.this.showNeverButton.getSelection()) {
                    SVNTeamConsolePreferencesPage.this.autoshow = 0;
                }
            }
        });
        this.showAlwaysButton = new Button((Composite)showType, 16);
        data = new GridData();
        this.showAlwaysButton.setLayoutData((Object)data);
        this.showAlwaysButton.setText(SVNUIMessages.ConsolePreferencePage_textShowAlways);
        this.showAlwaysButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (SVNTeamConsolePreferencesPage.this.showAlwaysButton.getSelection()) {
                    SVNTeamConsolePreferencesPage.this.autoshow = 1;
                }
            }
        });
        this.showErrorButton = new Button((Composite)showType, 16);
        data = new GridData();
        this.showErrorButton.setLayoutData((Object)data);
        this.showErrorButton.setText(SVNUIMessages.ConsolePreferencePage_textShowError);
        this.showErrorButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (SVNTeamConsolePreferencesPage.this.showErrorButton.getSelection()) {
                    SVNTeamConsolePreferencesPage.this.autoshow = 2;
                }
            }
        });
        this.showWarningErrorButton = new Button((Composite)showType, 16);
        data = new GridData();
        this.showWarningErrorButton.setLayoutData((Object)data);
        this.showWarningErrorButton.setText(SVNUIMessages.ConsolePreferencePage_textShowWarningError);
        this.showWarningErrorButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (SVNTeamConsolePreferencesPage.this.showWarningErrorButton.getSelection()) {
                    SVNTeamConsolePreferencesPage.this.autoshow = 3;
                }
            }
        });
        Label separator = new Label(composite, 258);
        data = new GridData(768);
        data.horizontalSpan = 2;
        separator.setLayoutData((Object)data);
        separator.setVisible(false);
        this.wrapEnabledButton = new Button(composite, 32);
        data = new GridData();
        data.horizontalSpan = 2;
        this.wrapEnabledButton.setLayoutData((Object)data);
        this.wrapEnabledButton.setText(SVNUIMessages.ConsolePreferencePage_textWrapEnabled);
        this.wrapEnabledButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                SVNTeamConsolePreferencesPage.this.wrapEnabled = SVNTeamConsolePreferencesPage.this.wrapEnabledButton.getSelection();
                SVNTeamConsolePreferencesPage.this.wrapWidthText.setEnabled(SVNTeamConsolePreferencesPage.this.wrapEnabled);
            }
        });
        Label label = new Label(composite, 0);
        data = new GridData();
        label.setLayoutData((Object)data);
        String labelText = SVNUIMessages.ConsolePreferencePage_textWrapWidth;
        label.setText(labelText);
        this.wrapWidthText = new Text(composite, 2052);
        data = new GridData(768);
        data.grabExcessHorizontalSpace = true;
        this.wrapWidthText.setLayoutData((Object)data);
        CompositeVerifier verifier = new CompositeVerifier();
        verifier.add(new NonEmptyFieldVerifier(labelText));
        verifier.add(new IntegerFieldVerifier(labelText, true));
        this.attachTo((Control)this.wrapWidthText, verifier);
        this.wrapWidthText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                try {
                    SVNTeamConsolePreferencesPage.this.wrapWidth = Integer.parseInt(SVNTeamConsolePreferencesPage.this.wrapWidthText.getText());
                }
                catch (Exception exception) {}
            }
        });
        this.limitEnabledButton = new Button(composite, 32);
        data = new GridData();
        data.horizontalSpan = 2;
        this.limitEnabledButton.setLayoutData((Object)data);
        this.limitEnabledButton.setText(SVNUIMessages.ConsolePreferencePage_textLimitEnabled);
        this.limitEnabledButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SVNTeamConsolePreferencesPage.this.limitEnabled = SVNTeamConsolePreferencesPage.this.limitEnabledButton.getSelection();
                SVNTeamConsolePreferencesPage.this.limitValueText.setEnabled(SVNTeamConsolePreferencesPage.this.limitEnabled);
            }
        });
        label = new Label(composite, 0);
        data = new GridData();
        label.setLayoutData((Object)data);
        labelText = SVNUIMessages.ConsolePreferencePage_textLimitValue;
        label.setText(labelText);
        this.limitValueText = new Text(composite, 2052);
        data = new GridData(768);
        data.grabExcessHorizontalSpace = true;
        this.limitValueText.setLayoutData((Object)data);
        verifier = new CompositeVerifier();
        verifier.add(new NonEmptyFieldVerifier(labelText));
        verifier.add(new IntegerFieldVerifier(labelText, true));
        this.attachTo((Control)this.limitValueText, verifier);
        this.limitValueText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                try {
                    SVNTeamConsolePreferencesPage.this.limitValue = Integer.parseInt(SVNTeamConsolePreferencesPage.this.limitValueText.getText());
                }
                catch (Exception exception) {}
            }
        });
        separator = new Label(composite, 258);
        data = new GridData(768);
        data.horizontalSpan = 2;
        separator.setLayoutData((Object)data);
        separator.setVisible(false);
        label = new Label(composite, 0);
        data = new GridData();
        data.horizontalSpan = 2;
        label.setLayoutData((Object)data);
        label.setText(SVNUIMessages.ConsolePreferencePage_textColorsGroup);
        this.cmdEditor = new ColorFieldEditor(SVNTeamPreferences.fullConsoleName("command"), SVNUIMessages.ConsolePreferencePage_textCmdMessage, composite);
        this.cmdEditor.setPage((DialogPage)this);
        this.cmdEditor.setPreferenceStore(this.getPreferenceStore());
        this.okEditor = new ColorFieldEditor(SVNTeamPreferences.fullConsoleName("ok"), SVNUIMessages.ConsolePreferencePage_textOkMessage, composite);
        this.okEditor.setPage((DialogPage)this);
        this.okEditor.setPreferenceStore(this.getPreferenceStore());
        this.wrnEditor = new ColorFieldEditor(SVNTeamPreferences.fullConsoleName("warning"), SVNUIMessages.ConsolePreferencePage_textWrnMessage, composite);
        this.wrnEditor.setPage((DialogPage)this);
        this.wrnEditor.setPreferenceStore(this.getPreferenceStore());
        this.errEditor = new ColorFieldEditor(SVNTeamPreferences.fullConsoleName("error"), SVNUIMessages.ConsolePreferencePage_textErrMessage, composite);
        this.errEditor.setPage((DialogPage)this);
        this.errEditor.setPreferenceStore(this.getPreferenceStore());
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.team.svn.help.consolePreferencesContext");
        return composite;
    }
}

