/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.panel.view;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.team.svn.core.connector.ISVNConnector;
import org.eclipse.team.svn.core.connector.SVNEntryRevisionReference;
import org.eclipse.team.svn.core.connector.SVNRevision;
import org.eclipse.team.svn.core.operation.AbstractActionOperation;
import org.eclipse.team.svn.core.operation.IActionOperation;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.core.utility.SVNUtility;
import org.eclipse.team.svn.ui.SVNUIMessages;
import org.eclipse.team.svn.ui.composite.RevisionComposite;
import org.eclipse.team.svn.ui.panel.AbstractDialogPanel;
import org.eclipse.team.svn.ui.utility.UIMonitorUtility;

public class HistoryRangePanel
extends AbstractDialogPanel {
    protected IRepositoryResource resource;
    protected IRepositoryResource initStartResource;
    protected IRepositoryResource initStopResource;
    protected RevisionComposite startComposite;
    protected RevisionComposite stopComposite;
    protected boolean reversed;

    public HistoryRangePanel(IRepositoryResource resource, SVNRevision initStartRevision, SVNRevision initStopRevision) {
        this.dialogTitle = SVNUIMessages.HistoryRangePanel_Title;
        this.dialogDescription = SVNUIMessages.HistoryRangePanel_Description;
        this.defaultMessage = SVNUIMessages.HistoryRangePanel_Message;
        this.resource = resource;
        this.initStartResource = SVNUtility.copyOf((IRepositoryResource)resource);
        this.initStartResource.setSelectedRevision(initStartRevision);
        this.initStopResource = SVNUtility.copyOf((IRepositoryResource)resource);
        this.initStopResource.setSelectedRevision(initStopRevision);
    }

    protected Point getPrefferedSizeImpl() {
        return new Point(715, -1);
    }

    public String getHelpId() {
        return "org.eclipse.team.svn.help.historyRangeDialogContext";
    }

    public SVNRevision getStartRevision() {
        return (this.reversed ? this.stopComposite : this.startComposite).getSelectedRevision();
    }

    public SVNRevision getStopRevision() {
        return (this.reversed ? this.startComposite : this.stopComposite).getSelectedRevision();
    }

    protected void createControlsImpl(Composite parent) {
        GridLayout layout = null;
        GridData data = null;
        Composite cmp = new Composite(parent, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        cmp.setLayout((Layout)layout);
        data = new GridData(1808);
        cmp.setLayoutData((Object)data);
        String defaultRevision = SVNUIMessages.HistoryRangePanel_Default;
        this.startComposite = new RevisionComposite(cmp, this, true, new String[]{SVNUIMessages.HistoryRangePanel_StartRevision, defaultRevision}, null, false);
        this.startComposite.setBaseResource(this.resource);
        this.startComposite.setSelectedResource(this.initStartResource);
        data = new GridData(768);
        this.startComposite.setLayoutData(data);
        this.stopComposite = new RevisionComposite(cmp, this, true, new String[]{SVNUIMessages.HistoryRangePanel_StopRevision, defaultRevision}, null, false);
        this.stopComposite.setBaseResource(this.resource);
        this.stopComposite.setSelectedResource(this.initStopResource);
        data = new GridData(768);
        this.stopComposite.setLayoutData(data);
    }

    protected void cancelChangesImpl() {
    }

    protected void saveChangesImpl() {
        if (this.getStartRevision() == null || this.getStopRevision() == null) {
            return;
        }
        this.initStartResource.setSelectedRevision(this.getStartRevision());
        this.initStopResource.setSelectedRevision(this.getStopRevision());
        UIMonitorUtility.doTaskNowDefault((IActionOperation)new AbstractActionOperation("Operation_CheckRevisions"){

            protected void runImpl(IProgressMonitor monitor) throws Exception {
                ISVNConnector proxy = HistoryRangePanel.this.initStartResource.getRepositoryLocation().acquireSVNProxy();
                try {
                    HistoryRangePanel.this.reversed = SVNUtility.compareRevisions((SVNRevision)HistoryRangePanel.this.initStartResource.getSelectedRevision(), (SVNRevision)HistoryRangePanel.this.initStopResource.getSelectedRevision(), (SVNEntryRevisionReference)SVNUtility.getEntryRevisionReference((IRepositoryResource)HistoryRangePanel.this.initStartResource), (SVNEntryRevisionReference)SVNUtility.getEntryRevisionReference((IRepositoryResource)HistoryRangePanel.this.initStopResource), (ISVNConnector)proxy) == -1;
                }
                finally {
                    HistoryRangePanel.this.initStartResource.getRepositoryLocation().releaseSVNProxy(proxy);
                }
            }
        }, false);
    }
}

