/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.panel.remote;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.ui.SVNUIMessages;
import org.eclipse.team.svn.ui.composite.BranchTagSelectionComposite;
import org.eclipse.team.svn.ui.composite.DiffFormatComposite;
import org.eclipse.team.svn.ui.panel.AbstractDialogPanel;

public class CompareBranchTagPanel
extends AbstractDialogPanel {
    protected IRepositoryResource selectedResource;
    protected int type;
    protected IRepositoryResource[] branchTagResources;
    protected long currentRevision;
    protected String historyKey;
    protected BranchTagSelectionComposite selectionComposite;
    protected DiffFormatComposite diffFormatComposite;

    public CompareBranchTagPanel(IRepositoryResource baseResource, int type, IRepositoryResource[] branchTagResources) {
        this.selectedResource = baseResource;
        this.type = type;
        this.branchTagResources = branchTagResources;
        if (type == 0) {
            this.dialogTitle = SVNUIMessages.Compare_Branch_Title;
            this.dialogDescription = SVNUIMessages.Compare_Branch_Description;
            this.defaultMessage = SVNUIMessages.Compare_Branch_Message;
            this.historyKey = "branchCompare";
        } else {
            this.dialogTitle = SVNUIMessages.Compare_Tag_Title;
            this.dialogDescription = SVNUIMessages.Compare_Tag_Description;
            this.defaultMessage = SVNUIMessages.Compare_Tag_Message;
            this.historyKey = "tagCompare";
        }
    }

    protected void createControlsImpl(Composite parent) {
        GridData data = null;
        this.selectionComposite = new BranchTagSelectionComposite(parent, 0, this.selectedResource, this.historyKey, this, this.type, this.branchTagResources);
        data = new GridData(768);
        this.selectionComposite.setLayoutData(data);
        this.selectionComposite.setCurrentRevision(this.currentRevision);
        this.diffFormatComposite = new DiffFormatComposite(parent, this);
    }

    public String getDiffFile() {
        return this.diffFormatComposite.getDiffFile();
    }

    public IRepositoryResource getSelectedResoure() {
        return this.selectionComposite.getSelectedResource();
    }

    protected void saveChangesImpl() {
        this.selectionComposite.saveChanges();
    }

    protected void cancelChangesImpl() {
    }
}

