/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.panel.local;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.team.svn.core.IStateFilter;
import org.eclipse.team.svn.core.resource.events.IResourceStatesListener;
import org.eclipse.team.svn.core.resource.events.ResourceStatesChangedEvent;
import org.eclipse.team.svn.core.svnstorage.SVNRemoteStorage;
import org.eclipse.team.svn.core.utility.FileUtility;
import org.eclipse.team.svn.ui.SVNUIMessages;
import org.eclipse.team.svn.ui.composite.ResourceSelectionComposite;
import org.eclipse.team.svn.ui.panel.local.AbstractResourceSelectionPanel;
import org.eclipse.team.svn.ui.panel.participant.BasePaneParticipant;
import org.eclipse.team.svn.ui.synchronize.AbstractSynchronizeActionGroup;
import org.eclipse.team.svn.ui.utility.UIMonitorUtility;
import org.eclipse.team.svn.ui.verifier.AbstractVerifier;
import org.eclipse.team.ui.synchronize.ISynchronizeScope;
import org.eclipse.team.ui.synchronize.ResourceScope;

public class OverrideResourcesPanel
extends AbstractResourceSelectionPanel {
    public static final int MSG_COMMIT = 0;
    public static final int MSG_UPDATE = 1;
    protected IResource[] affectedResource;
    protected IResourceStatesListener resourceStatesListener;
    protected static final String[] MESSAGES = new String[]{"OverrideResourcesPanel_Description_Commit", "OverrideResourcesPanel_Description_Update"};

    public OverrideResourcesPanel(IResource[] resources, IResource[] userSelectedResources, int msgId) {
        this(resources, userSelectedResources, msgId, new IResource[0]);
    }

    public OverrideResourcesPanel(IResource[] resources, IResource[] userSelectedResources, int msgId, IResource[] affectedResources) {
        super(resources, userSelectedResources, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL});
        this.dialogTitle = SVNUIMessages.OverrideResourcesPanel_Title;
        this.dialogDescription = SVNUIMessages.getString(MESSAGES[msgId]);
        boolean isParticipantPane = this.paneParticipantHelper.isParticipantPane();
        this.defaultMessage = isParticipantPane ? SVNUIMessages.OverrideResourcesPanel_Pane_Message : SVNUIMessages.OverrideResourcesPanel_Message;
        this.affectedResource = affectedResources;
    }

    protected String getDialogID() {
        return String.valueOf(super.getDialogID()) + (this.affectedResource.length > 0 ? "Affected" : "");
    }

    public void createControlsImpl(Composite parent) {
        super.createControlsImpl(parent);
        if (this.affectedResource.length == 0) {
            return;
        }
        Label separator = new Label(parent, 258);
        separator.setLayoutData((Object)new GridData(768));
        Label description = new Label(parent, 16448);
        description.setText(SVNUIMessages.OverrideResourcesPanel_Affected);
        GridData data = new GridData();
        data.horizontalSpan = 2;
        data.horizontalAlignment = 4;
        data.widthHint = 300;
        description.setLayoutData((Object)data);
        data = new GridData(1808);
        data.heightHint = 100;
        ResourceSelectionComposite affectedResourcesComposite = new ResourceSelectionComposite(parent, 0, this.affectedResource, false, false);
        affectedResourcesComposite.setLayoutData(data);
        this.attachTo((Control)affectedResourcesComposite, new AbstractVerifier(){

            protected String getErrorMessage(Control input) {
                return null;
            }

            protected String getWarningMessage(Control input) {
                return SVNUIMessages.OverrideResourcesPanel_Affected_Warning;
            }
        });
    }

    protected void updateResources(ResourceStatesChangedEvent event) {
        HashSet allResources = new HashSet(Arrays.asList(this.resources));
        HashSet toDeleteSet = new HashSet();
        toDeleteSet.addAll(Arrays.asList(FileUtility.getResourcesRecursive((IResource[])event.resources, (IStateFilter)IStateFilter.SF_NOTMODIFIED, (int)0)));
        toDeleteSet.addAll(Arrays.asList(FileUtility.getResourcesRecursive((IResource[])event.resources, (IStateFilter)IStateFilter.SF_NOTEXISTS, (int)0)));
        toDeleteSet.addAll(Arrays.asList(FileUtility.getResourcesRecursive((IResource[])event.resources, (IStateFilter)IStateFilter.SF_IGNORED, (int)0)));
        allResources.removeAll(toDeleteSet);
        final IResource[] newResources = allResources.toArray(new IResource[allResources.size()]);
        if (!this.paneParticipantHelper.isParticipantPane()) {
            UIMonitorUtility.getDisplay().syncExec(new Runnable(){

                public void run() {
                    if (!OverrideResourcesPanel.this.selectionComposite.isDisposed()) {
                        OverrideResourcesPanel.this.selectionComposite.setResources(newResources);
                        OverrideResourcesPanel.this.selectionComposite.fireSelectionChanged();
                    }
                }
            });
        }
        this.resources = newResources;
    }

    public void postInit() {
        super.postInit();
        this.validateContent();
        this.resourceStatesListener = new IResourceStatesListener(){

            public void resourcesStateChanged(ResourceStatesChangedEvent event) {
                OverrideResourcesPanel.this.updateResources(event);
            }
        };
        SVNRemoteStorage.instance().addResourceStatesListener(ResourceStatesChangedEvent.class, this.resourceStatesListener);
    }

    public void dispose() {
        super.dispose();
        SVNRemoteStorage.instance().removeResourceStatesListener(ResourceStatesChangedEvent.class, this.resourceStatesListener);
    }

    public String getHelpId() {
        return "org.eclipse.team.svn.help.overrideDialogContext";
    }

    protected BasePaneParticipant createPaneParticipant() {
        return new BasePaneParticipant((ISynchronizeScope)new ResourceScope(this.resources), this){

            @Override
            protected Collection<AbstractSynchronizeActionGroup> getActionGroups() {
                ArrayList<AbstractSynchronizeActionGroup> actionGroups = new ArrayList<AbstractSynchronizeActionGroup>();
                actionGroups.add(new BasePaneParticipant.BasePaneActionGroup(this.validationManager));
                return actionGroups;
            }
        };
    }
}

