/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.operation;

import java.util.Iterator;
import java.util.LinkedList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.team.svn.core.SVNMessages;
import org.eclipse.team.svn.core.connector.SVNConnectorAuthenticationException;
import org.eclipse.team.svn.core.connector.SVNConnectorCancelException;
import org.eclipse.team.svn.core.connector.SVNConnectorException;
import org.eclipse.team.svn.core.operation.ActivityCancelledException;
import org.eclipse.team.svn.core.operation.HiddenException;
import org.eclipse.team.svn.core.operation.IActionOperation;
import org.eclipse.team.svn.core.operation.LoggedOperation;
import org.eclipse.team.svn.core.operation.UnreportableException;
import org.eclipse.team.svn.ui.SVNTeamUIPlugin;
import org.eclipse.team.svn.ui.SVNUIMessages;
import org.eclipse.team.svn.ui.debugmail.ReportPartsFactory;
import org.eclipse.team.svn.ui.dialog.DefaultDialog;
import org.eclipse.team.svn.ui.extension.factory.IReporter;
import org.eclipse.team.svn.ui.panel.reporting.ErrorCancelPanel;
import org.eclipse.team.svn.ui.preferences.SVNTeamPreferences;
import org.eclipse.team.svn.ui.utility.DefaultOperationWrapperFactory;
import org.eclipse.team.svn.ui.utility.UIMonitorUtility;

public class UILoggedOperation
extends LoggedOperation {
    protected static LinkedList<Object[]> errorQueue = new LinkedList();

    public UILoggedOperation(IActionOperation op) {
        super(op);
    }

    public static void reportError(String where, Throwable t) {
        String errMessage = SVNMessages.format((String)SVNMessages.Operation_Error_LogHeader, (Object[])new String[]{where});
        MultiStatus status = new MultiStatus("org.eclipse.team.svn.core.svnnature", 0, errMessage, null);
        Status st = new Status(4, "org.eclipse.team.svn.core.svnnature", 0, String.valueOf(status.getMessage()) + ": " + t.getMessage(), t);
        status.merge((IStatus)st);
        UILoggedOperation.logError((IStatus)st);
        UILoggedOperation.showError("org.eclipse.team.svn.core.svnnature", where, (IStatus)st);
    }

    protected void handleError(IStatus errorStatus) {
        super.handleError(errorStatus);
        if (errorStatus.matches(4)) {
            UILoggedOperation.showError("org.eclipse.team.svn.core.svnnature", this.getOperationName(), errorStatus);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void showError(String pluginID, String operationName, IStatus errorStatus) {
        OperationErrorInfo errorInfo = UILoggedOperation.formatMessage(errorStatus, false);
        if (errorInfo == null) {
            return;
        }
        LinkedList<Object[]> linkedList = errorQueue;
        synchronized (linkedList) {
            errorQueue.add(new Object[]{pluginID, operationName, errorStatus});
            if (errorQueue.size() == 1) {
                Job job = new Job(""){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    protected IStatus run(IProgressMonitor monitor) {
                        boolean showCheckBox = SVNTeamPreferences.getMailReporterBoolean(SVNTeamUIPlugin.instance().getPreferenceStore(), "enabled");
                        while (!monitor.isCanceled()) {
                            IStatus errorStatus;
                            String operationName;
                            String pluginID;
                            LinkedList<Object[]> linkedList = errorQueue;
                            synchronized (linkedList) {
                                if (errorQueue.size() == 0) {
                                    break;
                                }
                                Object[] entry = errorQueue.get(0);
                                pluginID = (String)entry[0];
                                operationName = (String)entry[1];
                                errorStatus = (IStatus)entry[2];
                                Iterator it = errorQueue.iterator();
                                it.next();
                                while (it.hasNext()) {
                                    MultiStatus ms;
                                    entry = (Object[])it.next();
                                    if (!pluginID.equals(entry[0]) || !operationName.equals(entry[1])) continue;
                                    if (!(errorStatus instanceof MultiStatus)) {
                                        ms = new MultiStatus(errorStatus.getPlugin(), errorStatus.getCode(), errorStatus.getMessage(), errorStatus.getException());
                                        errorStatus = ms;
                                    } else {
                                        ms = (MultiStatus)errorStatus;
                                    }
                                    ms.addAll((IStatus)entry[2]);
                                    it.remove();
                                }
                            }
                            boolean doNotShowAgain = UILoggedOperation.showErrorImpl(pluginID, operationName, errorStatus, true, showCheckBox ? SVNUIMessages.UILoggedOperation_DontAskSend : null, null);
                            if (showCheckBox && doNotShowAgain) {
                                showCheckBox = !doNotShowAgain;
                                SVNTeamPreferences.setMailReporterBoolean(SVNTeamUIPlugin.instance().getPreferenceStore(), "enabled", false);
                            }
                            LinkedList<Object[]> linkedList2 = errorQueue;
                            synchronized (linkedList2) {
                                errorQueue.remove(0);
                            }
                        }
                        return Status.OK_STATUS;
                    }
                };
                job.setSystem(true);
                job.schedule();
            }
        }
    }

    protected static boolean showErrorImpl(final String pluginID, final String operationName, final IStatus errorStatus, boolean isReportingAllowed, final String optionName, final String originalReport) {
        final OperationErrorInfo errorInfo = UILoggedOperation.formatMessage(errorStatus, false);
        if (errorInfo == null) {
            return !isReportingAllowed;
        }
        final ErrorCancelPanel[] panel = new ErrorCancelPanel[1];
        final int[] retCode = new int[1];
        final boolean isPlugInError = ReportPartsFactory.checkStatus(errorStatus, new ErrorReasonVisitor());
        final boolean sendReport = isPlugInError & isReportingAllowed & SVNTeamPreferences.getMailReporterBoolean(SVNTeamUIPlugin.instance().getPreferenceStore(), "enabled");
        UIMonitorUtility.getDisplay().syncExec(new Runnable(){

            public void run() {
                panel[0] = originalReport == null ? new ErrorCancelPanel(operationName, errorInfo.numberOfErrors, errorInfo.simpleMessage, errorInfo.advancedMessage, sendReport, isPlugInError, optionName, errorStatus, pluginID) : new ErrorCancelPanel(operationName, errorInfo.numberOfErrors, errorInfo.simpleMessage, errorInfo.advancedMessage, sendReport, isPlugInError, optionName, errorStatus, pluginID, originalReport);
                DefaultDialog dialog = new DefaultDialog(UIMonitorUtility.getShell(), panel[0]);
                retCode[0] = dialog.open();
            }
        });
        if (retCode[0] == 0 && sendReport) {
            UILoggedOperation.sendReport(panel[0].getReporter());
        }
        return panel[0].doNotShowAgain();
    }

    public static void sendReport(final IReporter reporter) {
        boolean doNotShowAgain;
        UIMonitorUtility.getDisplay().syncExec(new Runnable(){

            public void run() {
                UIMonitorUtility.doTaskNow(UIMonitorUtility.getShell(), reporter, true, new DefaultOperationWrapperFactory(){

                    protected IActionOperation wrappedOperation(IActionOperation operation) {
                        return new LoggedOperation(operation);
                    }
                });
            }
        });
        if (reporter.getExecutionState() != 0 && SVNTeamPreferences.getMailReporterBoolean(SVNTeamUIPlugin.instance().getPreferenceStore(), "errorsEnabled") && (doNotShowAgain = UILoggedOperation.showErrorImpl("org.eclipse.team.svn.core.svnnature", SVNUIMessages.UILoggedOperation_SendReport_Error_Title, reporter.getStatus(), false, SVNUIMessages.UILoggedOperation_SendReport_Error_DontShow, reporter.buildReport()))) {
            SVNTeamPreferences.setMailReporterBoolean(SVNTeamUIPlugin.instance().getPreferenceStore(), "errorsEnabled", false);
        }
    }

    public static OperationErrorInfo formatMessage(IStatus status, boolean allowsCancelled) {
        if (!status.isMultiStatus()) {
            Throwable ex = status.getException();
            if (!allowsCancelled && (ex instanceof SVNConnectorCancelException || ex instanceof ActivityCancelledException || ex instanceof OperationCanceledException) || ex instanceof HiddenException) {
                return null;
            }
            String simpleMsg = UILoggedOperation.getSimpleMessage(status);
            if (ex instanceof SVNConnectorCancelException || ex instanceof ActivityCancelledException || ex instanceof OperationCanceledException || ex instanceof SVNConnectorAuthenticationException) {
                return new OperationErrorInfo(simpleMsg, simpleMsg, ex, 1);
            }
            String advancedMsg = UILoggedOperation.getSingleStatusMessage(status);
            return new OperationErrorInfo(simpleMsg, advancedMsg, ex, 1);
        }
        IStatus[] children = status.getChildren();
        String advanceMess = "";
        String simpleMess = "";
        int i = 0;
        while (i < children.length) {
            Throwable exception = children[i].getException();
            if (!(!allowsCancelled && (exception instanceof SVNConnectorCancelException || exception instanceof ActivityCancelledException || exception instanceof OperationCanceledException) || exception instanceof HiddenException)) {
                String simpleMsg = UILoggedOperation.getSimpleMessage(children[i]);
                String advancedMsg = UILoggedOperation.getSingleStatusMessage(children[i]);
                advanceMess = String.valueOf(advanceMess) + (advanceMess.length() == 0 ? advancedMsg : "\n\n" + advancedMsg);
                simpleMess = String.valueOf(simpleMess) + (simpleMess.length() == 0 ? simpleMsg : "\n" + simpleMsg);
                if (exception instanceof SVNConnectorCancelException || exception instanceof ActivityCancelledException || exception instanceof OperationCanceledException || exception instanceof SVNConnectorAuthenticationException) {
                    return new OperationErrorInfo(simpleMess, advanceMess, exception, i + 1);
                }
            }
            ++i;
        }
        return advanceMess.length() == 0 && simpleMess.length() == 0 ? null : new OperationErrorInfo(simpleMess, advanceMess, null, children.length);
    }

    protected static String getSimpleMessage(IStatus status) {
        if (status.getException() instanceof SVNConnectorCancelException || status.getException() instanceof ActivityCancelledException || status.getException() instanceof OperationCanceledException) {
            return SVNUIMessages.UILoggedOperation_Cancelled;
        }
        if (status.getException() instanceof SVNConnectorAuthenticationException) {
            return SVNUIMessages.UILoggedOperation_Authentication;
        }
        return status.getMessage();
    }

    protected static String getSingleStatusMessage(IStatus status) {
        if (status.getException() == null) {
            if (status.getMessage() != null) {
                return status.getMessage();
            }
            return SVNUIMessages.UILoggedOperation_Unknown;
        }
        if (status.getException() instanceof SVNConnectorCancelException || status.getException() instanceof ActivityCancelledException) {
            return SVNUIMessages.UILoggedOperation_Cancelled;
        }
        if (status.getException().getMessage() == null) {
            return status.getException().getClass().getName();
        }
        return status.getException().getMessage();
    }

    protected static class ErrorReasonVisitor
    implements ReportPartsFactory.IStatusVisitor {
        protected ErrorReasonVisitor() {
        }

        public boolean visit(IStatus status) {
            Throwable t = status.getException();
            return t != null && !(t instanceof OperationCanceledException) && !(t instanceof SVNConnectorException) && !(t instanceof UnreportableException);
        }
    }

    public static class OperationErrorInfo {
        public String simpleMessage;
        public String advancedMessage;
        public Throwable exception;
        public int numberOfErrors;

        public OperationErrorInfo(String simpleMessage, String advancedMessage, Throwable exception, int numberOfErrors) {
            this.simpleMessage = simpleMessage;
            this.advancedMessage = advancedMessage;
            this.exception = exception;
            this.numberOfErrors = numberOfErrors;
        }
    }
}

