/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.svnstorage;

import java.io.Serializable;
import org.eclipse.team.svn.core.connector.ISVNConnector;
import org.eclipse.team.svn.core.connector.SVNConnectorCancelException;
import org.eclipse.team.svn.core.connector.SVNConnectorException;
import org.eclipse.team.svn.core.connector.SVNRevision;
import org.eclipse.team.svn.core.resource.IRepositoryContainer;
import org.eclipse.team.svn.core.resource.IRepositoryFile;
import org.eclipse.team.svn.core.resource.IRepositoryLocation;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.core.resource.IRepositoryRoot;
import org.eclipse.team.svn.core.svnstorage.SVNRepositoryBase;
import org.eclipse.team.svn.core.utility.SVNUtility;

public abstract class SVNRepositoryResource
extends SVNRepositoryBase
implements IRepositoryResource,
Serializable {
    private static final long serialVersionUID = 8854704746872311777L;
    private transient SVNRevision selectedRevision;
    private transient SVNRevision pegRevision;
    protected transient SVNRevision.Number lastRevision;
    protected transient IRepositoryLocation location;
    protected transient IRepositoryRoot root;
    protected transient IRepositoryResource.Information info;

    protected SVNRepositoryResource() {
    }

    public SVNRepositoryResource(IRepositoryLocation location, String url, SVNRevision selectedRevision) {
        super(url);
        this.location = location;
        this.selectedRevision = selectedRevision;
    }

    public void setInfo(IRepositoryResource.Information info) {
        this.info = info;
    }

    public IRepositoryResource.Information getInfo() {
        return this.info;
    }

    public SVNRevision getPegRevision() {
        return this.pegRevision == null ? SVNRevision.HEAD : this.pegRevision;
    }

    public void setPegRevision(SVNRevision pegRevision) {
        this.pegRevision = pegRevision;
    }

    public SVNRevision getSelectedRevision() {
        if (this.selectedRevision == null) {
            this.selectedRevision = SVNRevision.HEAD;
        }
        return this.selectedRevision;
    }

    public void setSelectedRevision(SVNRevision revision) {
        this.selectedRevision = revision;
    }

    public boolean isInfoCached() {
        return this.lastRevision != null;
    }

    public synchronized void refresh() {
        this.lastRevision = null;
    }

    public void setRevision(long revisionNumber) {
        this.lastRevision = SVNRevision.fromNumber(revisionNumber);
    }

    public synchronized long getRevision() throws SVNConnectorException {
        if (this.lastRevision == null) {
            this.lastRevision = SVNRevision.INVALID_REVISION;
            ISVNConnector proxy = this.getRepositoryLocation().acquireSVNProxy();
            try {
                this.getRevisionImpl(proxy);
            }
            finally {
                this.getRepositoryLocation().releaseSVNProxy(proxy);
            }
        }
        return this.lastRevision.getNumber();
    }

    public boolean exists() throws SVNConnectorException {
        try {
            return this.getRevision() != -1L;
        }
        catch (SVNConnectorException ex) {
            if (ex instanceof SVNConnectorCancelException) {
                throw ex;
            }
            return false;
        }
    }

    public IRepositoryResource getParent() {
        String parentUrl = SVNUtility.normalizeURL(this.getUrl());
        int idx = parentUrl.lastIndexOf(47);
        if (idx == -1) {
            throw new IllegalArgumentException(parentUrl);
        }
        return this.asRepositoryContainer(parentUrl.substring(0, idx), true);
    }

    public IRepositoryResource getRoot() {
        if (this.root == null) {
            IRepositoryResource parent = this;
            while (!(parent instanceof IRepositoryRoot)) {
                parent = parent.getParent();
            }
            this.root = (IRepositoryRoot)parent;
        }
        return this.root;
    }

    public IRepositoryLocation getRepositoryLocation() {
        return this.location;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof IRepositoryResource)) {
            return false;
        }
        IRepositoryResource other = (IRepositoryResource)obj;
        return super.equals(obj) && this.getSelectedRevision().equals(other.getSelectedRevision()) && this.getPegRevision().equals(other.getPegRevision());
    }

    public IRepositoryContainer asRepositoryContainer(String url, boolean allowsNull) {
        IRepositoryContainer retVal = this.getRepositoryLocation().asRepositoryContainer(url.indexOf(47) != -1 ? url : String.valueOf(this.getUrl()) + "/" + url, allowsNull);
        if (retVal == null) {
            return null;
        }
        retVal.setPegRevision(this.getPegRevision());
        retVal.setSelectedRevision(this.getSelectedRevision());
        return retVal;
    }

    public IRepositoryFile asRepositoryFile(String url, boolean allowsNull) {
        IRepositoryFile retVal = this.getRepositoryLocation().asRepositoryFile(url.indexOf(47) != -1 ? url : String.valueOf(this.getUrl()) + "/" + url, allowsNull);
        if (retVal == null) {
            return null;
        }
        retVal.setPegRevision(this.getPegRevision());
        retVal.setSelectedRevision(this.getSelectedRevision());
        return retVal;
    }

    protected abstract void getRevisionImpl(ISVNConnector var1) throws SVNConnectorException;
}

