/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.operation.remote.management;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.svn.core.connector.SVNRevision;
import org.eclipse.team.svn.core.operation.IUnprotectedOperation;
import org.eclipse.team.svn.core.operation.remote.AbstractRepositoryOperation;
import org.eclipse.team.svn.core.resource.IRepositoryLocation;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.core.resource.IRepositoryResourceProvider;
import org.eclipse.team.svn.core.utility.SVNUtility;

public class AddRevisionLinkOperation
extends AbstractRepositoryOperation {
    protected SVNRevision revision;

    public AddRevisionLinkOperation(IRepositoryResource resource, long revision) {
        this(resource, (SVNRevision)SVNRevision.fromNumber(revision));
    }

    public AddRevisionLinkOperation(IRepositoryResource resource, SVNRevision revision) {
        super("Operation.AddRevisionLink", new IRepositoryResource[]{resource});
        this.revision = revision;
    }

    public AddRevisionLinkOperation(IRepositoryResourceProvider provider, long revision) {
        this(provider, (SVNRevision)SVNRevision.fromNumber(revision));
    }

    public AddRevisionLinkOperation(IRepositoryResourceProvider provider, SVNRevision revision) {
        super("Operation.AddRevisionLink", provider);
        this.revision = revision;
    }

    protected void runImpl(IProgressMonitor monitor) throws Exception {
        IRepositoryResource[] resources = this.operableData();
        int i = 0;
        while (i < resources.length && !monitor.isCanceled()) {
            final IRepositoryResource source = resources[i];
            this.protectStep(new IUnprotectedOperation(){

                public void run(IProgressMonitor monitor) throws Exception {
                    SVNRevision pegRevision;
                    SVNRevision selectedRevision;
                    IRepositoryLocation location = source.getRepositoryLocation();
                    IRepositoryResource target = SVNUtility.copyOf(source);
                    SVNRevision sVNRevision = selectedRevision = AddRevisionLinkOperation.this.revision == null ? source.getSelectedRevision() : AddRevisionLinkOperation.this.revision;
                    if (selectedRevision.equals(SVNRevision.HEAD)) {
                        selectedRevision = SVNRevision.fromNumber(source.getRevision());
                    }
                    if ((pegRevision = source.getPegRevision()).equals(SVNRevision.HEAD)) {
                        pegRevision = SVNRevision.fromNumber(location.getRepositoryRoot().getRevision());
                    }
                    target.setSelectedRevision(selectedRevision);
                    target.setPegRevision(pegRevision);
                    location.addRevisionLink(target);
                }
            }, monitor, resources.length);
            ++i;
        }
    }
}

