/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.operation.remote;

import java.text.MessageFormat;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.svn.core.SVNTeamPlugin;
import org.eclipse.team.svn.core.connector.ISVNConnector;
import org.eclipse.team.svn.core.connector.ISVNNotificationCallback;
import org.eclipse.team.svn.core.connector.SVNNotification;
import org.eclipse.team.svn.core.operation.IRevisionProvider;
import org.eclipse.team.svn.core.operation.SVNProgressMonitor;
import org.eclipse.team.svn.core.operation.remote.AbstractRepositoryOperation;
import org.eclipse.team.svn.core.resource.IRepositoryLocation;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.core.utility.FileUtility;
import org.eclipse.team.svn.core.utility.SVNUtility;

public class ImportOperation
extends AbstractRepositoryOperation
implements IRevisionProvider {
    protected String path;
    protected String message;
    protected int depth;
    protected IRevisionProvider.RevisionPair[] revisionPair;

    public ImportOperation(IRepositoryResource resource, String path, String message, int depth) {
        super("Operation.Import", new IRepositoryResource[]{resource});
        this.path = path;
        this.message = message;
        this.depth = depth;
    }

    public IRevisionProvider.RevisionPair[] getRevisions() {
        return this.revisionPair;
    }

    protected void runImpl(IProgressMonitor monitor) throws Exception {
        final IRepositoryResource resource = this.operableData()[0];
        final IRepositoryLocation location = resource.getRepositoryLocation();
        this.revisionPair = new IRevisionProvider.RevisionPair[1];
        ISVNConnector proxy = location.acquireSVNProxy();
        ISVNNotificationCallback notify = new ISVNNotificationCallback(){

            public void notify(SVNNotification info) {
                if (info.revision != -1L) {
                    String[] path = new String[]{resource.getUrl()};
                    ImportOperation.this.revisionPair[0] = new IRevisionProvider.RevisionPair(info.revision, path, location);
                    String message = SVNTeamPlugin.instance().getResource("Console.CommittedRevision", new String[]{String.valueOf(info.revision)});
                    ImportOperation.this.writeToConsole(1, message);
                }
            }
        };
        try {
            SVNUtility.addSVNNotifyListener(proxy, notify);
            this.writeToConsole(0, "svn import \"" + FileUtility.normalizePath(this.path) + "\" \"" + SVNUtility.getDepthArg(this.depth) + " -m \"" + this.message + "\"" + FileUtility.getUsernameParam(location.getUsername()) + "\n");
            proxy.doImport(this.path, SVNUtility.encodeURL(resource.getUrl()), this.message, this.depth, 4352L, null, new SVNProgressMonitor(this, monitor, null));
        }
        finally {
            SVNUtility.removeSVNNotifyListener(proxy, notify);
            location.releaseSVNProxy(proxy);
        }
    }

    protected String getShortErrorMessage(Throwable t) {
        return MessageFormat.format(super.getShortErrorMessage(t), this.operableData()[0].getUrl());
    }
}

