/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.operation.remote;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.svn.core.connector.ISVNConnector;
import org.eclipse.team.svn.core.connector.SVNEntryRevisionReference;
import org.eclipse.team.svn.core.connector.SVNProperty;
import org.eclipse.team.svn.core.connector.SVNRevision;
import org.eclipse.team.svn.core.operation.AbstractActionOperation;
import org.eclipse.team.svn.core.operation.SVNProgressMonitor;
import org.eclipse.team.svn.core.operation.local.property.IRevisionPropertiesProvider;
import org.eclipse.team.svn.core.resource.IRepositoryLocation;

public class GetRevisionPropertiesOperation
extends AbstractActionOperation
implements IRevisionPropertiesProvider {
    protected IRepositoryLocation location;
    protected SVNRevision revision;
    protected SVNProperty[] revProperties;

    public GetRevisionPropertiesOperation(IRepositoryLocation location, SVNRevision revision) {
        super("Operation.GetRevisionProperties");
        this.revision = revision;
        this.location = location;
    }

    public SVNProperty[] getRevisionProperties() {
        if (this.revProperties == null) {
            return new SVNProperty[0];
        }
        return this.revProperties;
    }

    protected void runImpl(IProgressMonitor monitor) throws Exception {
        SVNEntryRevisionReference reference = new SVNEntryRevisionReference(this.location.getUrl(), this.revision, this.revision);
        ISVNConnector proxy = this.location.acquireSVNProxy();
        try {
            this.revProperties = proxy.getRevisionProperties(reference, new SVNProgressMonitor(this, monitor, null));
        }
        finally {
            this.location.releaseSVNProxy(proxy);
        }
    }
}

