/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.operation.local.refactor;

import java.text.MessageFormat;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.team.svn.core.connector.ISVNConnector;
import org.eclipse.team.svn.core.operation.AbstractActionOperation;
import org.eclipse.team.svn.core.operation.SVNProgressMonitor;
import org.eclipse.team.svn.core.resource.IRepositoryLocation;
import org.eclipse.team.svn.core.svnstorage.SVNRemoteStorage;
import org.eclipse.team.svn.core.utility.FileUtility;

public class MoveResourceOperation
extends AbstractActionOperation {
    protected IResource source;
    protected IResource destination;

    public MoveResourceOperation(IResource source, IResource destination) {
        super("Operation.MoveLocal");
        this.source = source;
        this.destination = destination;
    }

    public ISchedulingRule getSchedulingRule() {
        return MultiRule.combine((ISchedulingRule)(this.source instanceof IProject ? this.source : this.source.getParent()), (ISchedulingRule)(this.destination instanceof IProject ? this.destination : this.destination.getParent()));
    }

    public boolean isAllowed() {
        SVNRemoteStorage storage = SVNRemoteStorage.instance();
        IRepositoryLocation locationSource = storage.getRepositoryLocation(this.source);
        IRepositoryLocation locationDestination = storage.getRepositoryLocation(this.destination);
        return locationSource.equals(locationDestination);
    }

    protected void runImpl(IProgressMonitor monitor) throws Exception {
        SVNRemoteStorage storage = SVNRemoteStorage.instance();
        IRepositoryLocation location = storage.getRepositoryLocation(this.source);
        ISVNConnector proxy = location.acquireSVNProxy();
        String srcPath = FileUtility.getWorkingCopyPath(this.source);
        String dstPath = FileUtility.getWorkingCopyPath(this.destination);
        try {
            proxy.move(new String[]{srcPath}, dstPath, 4L, new SVNProgressMonitor(this, monitor, null));
        }
        finally {
            location.releaseSVNProxy(proxy);
        }
    }

    protected String getShortErrorMessage(Throwable t) {
        return MessageFormat.format(super.getShortErrorMessage(t), this.source.getName(), this.destination.getParent().getFullPath().toString());
    }
}

