/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.operation.file;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.svn.core.connector.ISVNConnector;
import org.eclipse.team.svn.core.connector.ISVNEntryStatusCallback;
import org.eclipse.team.svn.core.connector.SVNChangeStatus;
import org.eclipse.team.svn.core.operation.IUnprotectedOperation;
import org.eclipse.team.svn.core.operation.SVNProgressMonitor;
import org.eclipse.team.svn.core.operation.file.AbstractFileOperation;
import org.eclipse.team.svn.core.operation.file.IFileProvider;
import org.eclipse.team.svn.core.operation.file.SVNFileStorage;
import org.eclipse.team.svn.core.resource.IRepositoryLocation;
import org.eclipse.team.svn.core.resource.IRepositoryResource;

public abstract class AbstractStatusOperation
extends AbstractFileOperation {
    protected SVNChangeStatus[] statuses;
    protected boolean recursive;

    public AbstractStatusOperation(String operationName, File[] files, boolean recursive) {
        super(operationName, files);
        this.recursive = recursive;
    }

    public AbstractStatusOperation(String operationName, IFileProvider provider, boolean recursive) {
        super(operationName, provider);
        this.recursive = recursive;
    }

    public SVNChangeStatus[] getStatuses() {
        return this.statuses;
    }

    protected void runImpl(IProgressMonitor monitor) throws Exception {
        File[] files = this.operableData();
        final ArrayList result = new ArrayList();
        ISVNEntryStatusCallback cb = new ISVNEntryStatusCallback(){

            public void next(SVNChangeStatus status) {
                result.add(status);
            }
        };
        int i = 0;
        while (i < files.length && !monitor.isCanceled()) {
            IRepositoryResource remote = SVNFileStorage.instance().asRepositoryResource(files[i], false);
            IRepositoryLocation location = remote.getRepositoryLocation();
            ISVNConnector proxy = location.acquireSVNProxy();
            this.reportStatuses(proxy, cb, files[i], monitor, files.length);
            location.releaseSVNProxy(proxy);
            ++i;
        }
        this.statuses = result.toArray(new SVNChangeStatus[result.size()]);
    }

    protected void reportStatuses(final ISVNConnector proxy, final ISVNEntryStatusCallback cb, final File current, IProgressMonitor monitor, int tasks) {
        this.protectStep(new IUnprotectedOperation(){

            public void run(IProgressMonitor monitor) throws Exception {
                proxy.status(current.getAbsolutePath(), ISVNConnector.Depth.infinityOrImmediates(AbstractStatusOperation.this.recursive), AbstractStatusOperation.this.isRemote() ? 64L : 0L, null, cb, new SVNProgressMonitor(AbstractStatusOperation.this, monitor, null, false));
            }
        }, monitor, tasks);
    }

    protected abstract boolean isRemote();
}

