/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.wizard.shareproject;

import org.eclipse.core.resources.IProject;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.team.svn.core.operation.local.management.ShareProjectOperation;
import org.eclipse.team.svn.core.resource.IRepositoryLocation;
import org.eclipse.team.svn.ui.SVNTeamUIPlugin;
import org.eclipse.team.svn.ui.verifier.AbsolutePathVerifier;
import org.eclipse.team.svn.ui.verifier.AbstractVerifierProxy;
import org.eclipse.team.svn.ui.verifier.CompositeVerifier;
import org.eclipse.team.svn.ui.verifier.NonEmptyFieldVerifier;
import org.eclipse.team.svn.ui.verifier.ResourceNameVerifier;
import org.eclipse.team.svn.ui.wizard.AbstractVerifiedWizardPage;
import org.eclipse.ui.PlatformUI;

public class SelectProjectNamePage
extends AbstractVerifiedWizardPage {
    protected int layoutType = 0;
    protected String rootProjectName;
    protected String projectName;
    protected String selectedName;
    protected boolean managementFoldersEnabled;
    protected Text projectNameField;
    protected Text rootProjectNameField;
    protected Label targetUrlField;
    protected Button managementFoldersEnabledButton;
    protected IRepositoryLocation location;
    protected boolean multiProject;
    protected Button defaultLayoutButton;
    protected Button singleLayoutButton;
    protected Group nameGroup;
    protected Group layoutGroup;
    protected Point savedPosition;

    public SelectProjectNamePage() {
        super(SelectProjectNamePage.class.getName(), "", SVNTeamUIPlugin.instance().getImageDescriptor("icons/wizards/newconnect.gif"));
    }

    public void setProjectsAndLocation(IProject[] projects, IRepositoryLocation location) {
        this.multiProject = projects.length > 1;
        this.location = location;
        if (this.multiProject) {
            this.projectName = "";
            this.selectedName = "";
            this.setTitle(SVNTeamUIPlugin.instance().getResource("SelectProjectNamePage.Title.Multi"));
            this.setDescription(SVNTeamUIPlugin.instance().getResource("SelectProjectNamePage.Description.Multi"));
            this.savedPosition = this.layoutGroup.getLocation();
            this.layoutGroup.setLocation(this.nameGroup.getLocation());
            this.nameGroup.setVisible(false);
            this.defaultLayoutButton.setSelection(true);
        } else {
            this.selectedName = this.projectName = projects[0].getName();
            if (this.savedPosition != null) {
                this.nameGroup.setVisible(true);
                this.layoutGroup.setLocation(this.savedPosition);
                this.savedPosition = null;
            }
            this.setTitle(SVNTeamUIPlugin.instance().getResource("SelectProjectNamePage.Title.Single"));
            this.setDescription(SVNTeamUIPlugin.instance().getResource("SelectProjectNamePage.Description.Single"));
        }
        this.singleLayoutButton.setEnabled(!this.multiProject);
        this.projectNameField.setText(this.projectName);
        this.rootProjectNameField.setText(this.projectName);
        this.showTargetUrl();
    }

    public boolean isManagementFoldersEnabled() {
        return this.layoutType == 0 ? true : this.managementFoldersEnabled;
    }

    public int getLayoutType() {
        return this.layoutType;
    }

    public ShareProjectOperation.IFolderNameMapper getSelectedNames() {
        return this.multiProject ? null : new ShareProjectOperation.IFolderNameMapper(){

            public String getRepositoryFolderName(IProject project) {
                return SelectProjectNamePage.this.selectedName;
            }
        };
    }

    public String getRootProjectName() {
        return this.rootProjectName;
    }

    protected Composite createControlImpl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        composite.setLayoutData((Object)data);
        this.nameGroup = new Group(composite, 0);
        layout = new GridLayout();
        this.nameGroup.setLayout((Layout)layout);
        data = new GridData(768);
        this.nameGroup.setLayoutData((Object)data);
        this.nameGroup.setText(SVNTeamUIPlugin.instance().getResource("SelectProjectNamePage.NameOnRepository"));
        Button useProjectNameButton = new Button((Composite)this.nameGroup, 16);
        useProjectNameButton.setLayoutData((Object)this.makeGridData());
        useProjectNameButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectProjectNamePage.this.validateContent();
                Button button = (Button)e.widget;
                if (button.getSelection()) {
                    SelectProjectNamePage.this.selectedName = SelectProjectNamePage.this.projectName;
                    SelectProjectNamePage.this.setPageComplete(true);
                }
                SelectProjectNamePage.this.showTargetUrl();
            }
        });
        useProjectNameButton.setText(SVNTeamUIPlugin.instance().getResource("SelectProjectNamePage.UseProjectName"));
        useProjectNameButton.setSelection(true);
        Button useEmptyNameButton = new Button((Composite)this.nameGroup, 16);
        useEmptyNameButton.setLayoutData((Object)this.makeGridData());
        useEmptyNameButton.setText(SVNTeamUIPlugin.instance().getResource("SelectProjectNamePage.UseEmptyName"));
        useEmptyNameButton.setSelection(false);
        final Button useRedefinedNameButton = new Button((Composite)this.nameGroup, 16);
        useRedefinedNameButton.setLayoutData((Object)this.makeGridData());
        useRedefinedNameButton.setText(SVNTeamUIPlugin.instance().getResource("SelectProjectNamePage.UseSpecifiedName"));
        useRedefinedNameButton.setSelection(false);
        useRedefinedNameButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectProjectNamePage.this.validateContent();
                Button button = (Button)e.widget;
                if (button.getSelection()) {
                    SelectProjectNamePage.this.selectedName = SelectProjectNamePage.this.projectNameField.getText();
                    SelectProjectNamePage.this.projectNameField.setEditable(true);
                } else {
                    SelectProjectNamePage.this.projectNameField.setEditable(false);
                }
                SelectProjectNamePage.this.showTargetUrl();
            }
        });
        this.projectNameField = new Text((Composite)this.nameGroup, 2052);
        this.projectNameField.setLayoutData((Object)this.makeGridData());
        this.projectNameField.setEditable(false);
        this.projectNameField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SelectProjectNamePage.this.selectedName = SelectProjectNamePage.this.projectNameField.getText();
                SelectProjectNamePage.this.showTargetUrl();
            }
        });
        CompositeVerifier verifier = new CompositeVerifier();
        String name = SVNTeamUIPlugin.instance().getResource("SelectProjectNamePage.ProjectName");
        verifier.add(new NonEmptyFieldVerifier(name));
        verifier.add(new ResourceNameVerifier(name, true));
        verifier.add(new AbsolutePathVerifier(name));
        this.attachTo((Control)this.projectNameField, new AbstractVerifierProxy(verifier){

            protected boolean isVerificationEnabled(Control input) {
                return useRedefinedNameButton.getSelection();
            }
        });
        this.layoutGroup = new Group(composite, 0);
        layout = new GridLayout();
        this.layoutGroup.setLayout((Layout)layout);
        data = new GridData(768);
        this.layoutGroup.setLayoutData((Object)data);
        this.layoutGroup.setText(SVNTeamUIPlugin.instance().getResource("SelectProjectNamePage.ProjectLayout"));
        this.defaultLayoutButton = new Button((Composite)this.layoutGroup, 16);
        data = this.makeGridData();
        this.defaultLayoutButton.setLayoutData((Object)data);
        this.defaultLayoutButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button button = (Button)e.widget;
                if (button.getSelection()) {
                    SelectProjectNamePage.this.layoutType = 0;
                    SelectProjectNamePage.this.managementFoldersEnabledButton.setEnabled(false);
                }
                SelectProjectNamePage.this.validateContent();
                SelectProjectNamePage.this.showTargetUrl();
            }
        });
        this.defaultLayoutButton.setText(SVNTeamUIPlugin.instance().getResource("SelectProjectNamePage.RepositoryLocationLayout"));
        this.defaultLayoutButton.setSelection(true);
        this.singleLayoutButton = new Button((Composite)this.layoutGroup, 16);
        data = this.makeGridData();
        this.singleLayoutButton.setLayoutData((Object)data);
        this.singleLayoutButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button button = (Button)e.widget;
                if (button.getSelection()) {
                    SelectProjectNamePage.this.layoutType = 1;
                    SelectProjectNamePage.this.managementFoldersEnabledButton.setEnabled(true);
                }
                SelectProjectNamePage.this.validateContent();
                SelectProjectNamePage.this.showTargetUrl();
            }
        });
        this.singleLayoutButton.setText(SVNTeamUIPlugin.instance().getResource("SelectProjectNamePage.SingleProjectLayout"));
        final Button multipleLayoutButton = new Button((Composite)this.layoutGroup, 16);
        data = this.makeGridData();
        multipleLayoutButton.setLayoutData((Object)data);
        multipleLayoutButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button button = (Button)e.widget;
                if (button.getSelection()) {
                    SelectProjectNamePage.this.layoutType = 2;
                    SelectProjectNamePage.this.rootProjectName = SelectProjectNamePage.this.rootProjectNameField.getText();
                    SelectProjectNamePage.this.managementFoldersEnabledButton.setEnabled(true);
                }
                SelectProjectNamePage.this.rootProjectNameField.setEditable(button.getSelection());
                SelectProjectNamePage.this.validateContent();
                SelectProjectNamePage.this.showTargetUrl();
            }
        });
        multipleLayoutButton.setText(SVNTeamUIPlugin.instance().getResource("SelectProjectNamePage.MultiProjectLayout"));
        this.rootProjectNameField = new Text((Composite)this.layoutGroup, 2052);
        this.rootProjectNameField.setLayoutData((Object)this.makeGridData());
        this.rootProjectNameField.setEditable(false);
        this.rootProjectNameField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SelectProjectNamePage.this.rootProjectName = SelectProjectNamePage.this.rootProjectNameField.getText();
                SelectProjectNamePage.this.showTargetUrl();
            }
        });
        verifier = new CompositeVerifier();
        name = SVNTeamUIPlugin.instance().getResource("SelectProjectNamePage.RootName");
        verifier.add(new NonEmptyFieldVerifier(name));
        verifier.add(new ResourceNameVerifier(name, true));
        verifier.add(new AbsolutePathVerifier(name));
        this.attachTo((Control)this.rootProjectNameField, new AbstractVerifierProxy(verifier){

            protected boolean isVerificationEnabled(Control input) {
                return multipleLayoutButton.getSelection();
            }
        });
        new Label((Composite)this.layoutGroup, 258).setLayoutData((Object)this.makeGridData());
        this.managementFoldersEnabledButton = new Button((Composite)this.layoutGroup, 32);
        this.managementFoldersEnabledButton.setLayoutData((Object)new GridData());
        this.managementFoldersEnabledButton.setEnabled(false);
        this.managementFoldersEnabledButton.setSelection(true);
        this.managementFoldersEnabled = true;
        this.managementFoldersEnabledButton.setText(SVNTeamUIPlugin.instance().getResource("SelectProjectNamePage.UseRecommended"));
        this.managementFoldersEnabledButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectProjectNamePage.this.managementFoldersEnabled = ((Button)e.widget).getSelection();
                SelectProjectNamePage.this.showTargetUrl();
            }
        });
        this.initializeDialogUnits((Control)parent);
        Label label = new Label((Composite)this.layoutGroup, 64);
        data = this.makeGridData();
        data.heightHint = this.convertHeightInCharsToPixels(2);
        label.setLayoutData((Object)data);
        label.setText(SVNTeamUIPlugin.instance().getResource("SelectProjectNamePage.Hint"));
        Composite urlComposite = new Composite((Composite)this.layoutGroup, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 2;
        urlComposite.setLayout((Layout)layout);
        data = new GridData(768);
        urlComposite.setLayoutData((Object)data);
        label = new Label(urlComposite, 0);
        label.setLayoutData((Object)new GridData());
        label.setImage(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_FOLDER").createImage());
        this.targetUrlField = new Label(urlComposite, 4);
        this.targetUrlField.setLayoutData((Object)this.makeGridData());
        this.projectNameField.setEditable(true);
        this.targetUrlField.setBackground(this.projectNameField.getBackground());
        label.setBackground(this.projectNameField.getBackground());
        urlComposite.setBackground(this.projectNameField.getBackground());
        this.projectNameField.setEditable(false);
        useEmptyNameButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectProjectNamePage.this.validateContent();
                SelectProjectNamePage.this.selectedName = "";
                Button button = (Button)e.widget;
                if (button.getSelection()) {
                    multipleLayoutButton.setEnabled(false);
                    if (multipleLayoutButton.getSelection()) {
                        multipleLayoutButton.setSelection(false);
                        SelectProjectNamePage.this.rootProjectNameField.setEditable(false);
                        SelectProjectNamePage.this.managementFoldersEnabledButton.setEnabled(false);
                        SelectProjectNamePage.this.defaultLayoutButton.setSelection(true);
                    }
                } else {
                    multipleLayoutButton.setEnabled(true);
                }
                SelectProjectNamePage.this.showTargetUrl();
            }
        });
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.team.svn.help.projectNameContext");
        return composite;
    }

    protected void showTargetUrl() {
        String targetUrl = ShareProjectOperation.getTargetUrl((IRepositoryLocation)this.location, (int)this.layoutType, (String)this.selectedName, (String)this.rootProjectName, (boolean)this.isManagementFoldersEnabled());
        this.showTargetUrlImpl(targetUrl);
    }

    protected void showTargetUrlImpl(String targetUrl) {
        if (this.targetUrlField != null) {
            this.targetUrlField.setText(targetUrl);
        }
    }

    protected GridData makeGridData() {
        GridData data = new GridData(772);
        data.widthHint = 200;
        data.horizontalSpan = 1;
        return data;
    }
}

