/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.wizard.checkoutas;

import java.util.ArrayList;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.team.svn.core.resource.IRepositoryFile;
import org.eclipse.team.svn.core.resource.IRepositoryLocation;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.ui.SVNTeamUIPlugin;
import org.eclipse.team.svn.ui.composite.RepositoryTreeComposite;
import org.eclipse.team.svn.ui.repository.model.IRepositoryContentFilter;
import org.eclipse.team.svn.ui.repository.model.RepositoryLocation;
import org.eclipse.team.svn.ui.repository.model.RepositoryResource;
import org.eclipse.team.svn.ui.wizard.AbstractVerifiedWizardPage;
import org.eclipse.ui.PlatformUI;

public class SelectCheckoutResourcePage
extends AbstractVerifiedWizardPage {
    protected RepositoryTreeComposite selectionComposite;
    protected IRepositoryResource[] selectedResources;

    public SelectCheckoutResourcePage() {
        super(SelectCheckoutResourcePage.class.getName(), SVNTeamUIPlugin.instance().getResource("SelectCheckoutResourcePage.Title"), SVNTeamUIPlugin.instance().getImageDescriptor("icons/wizards/newconnect.gif"));
        this.setDescription(SVNTeamUIPlugin.instance().getResource("SelectCheckoutResourcePage.Description"));
    }

    public void setRepositoryLocation(IRepositoryLocation location) {
        this.selectionComposite.setModelRoot(new RepositoryLocation(location));
        this.setPageComplete(false);
    }

    public IRepositoryResource[] getSelectedResources() {
        return this.selectedResources;
    }

    protected Composite createControlImpl(Composite parent) {
        GridData data = null;
        GridLayout layout = null;
        Composite composite = new Composite(parent, 0);
        layout = new GridLayout();
        layout.marginWidth = 4;
        composite.setLayout((Layout)layout);
        data = new GridData(1808);
        composite.setLayoutData((Object)data);
        this.selectionComposite = new RepositoryTreeComposite(composite, 2048, true);
        data = new GridData(1808);
        this.selectionComposite.setLayoutData(data);
        this.selectionComposite.setFilter(new IRepositoryContentFilter(){

            public boolean accept(Object obj) {
                return !(obj instanceof IRepositoryFile);
            }
        });
        this.selectionComposite.getRepositoryTreeViewer().setAutoExpandLevel(1);
        this.selectionComposite.getRepositoryTreeViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)SelectCheckoutResourcePage.this.selectionComposite.getRepositoryTreeViewer().getSelection();
                ArrayList<IRepositoryResource> resources = new ArrayList<IRepositoryResource>();
                for (Object item : selection) {
                    if (!(item instanceof RepositoryResource)) continue;
                    resources.add(((RepositoryResource)item).getRepositoryResource());
                }
                SelectCheckoutResourcePage.this.selectedResources = resources.toArray(new IRepositoryResource[resources.size()]);
                SelectCheckoutResourcePage.this.setPageComplete(resources.size() > 0);
            }
        });
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.team.svn.help.selectCheckResourcesContext");
        return composite;
    }
}

