/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.utility;

import java.util.AbstractCollection;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.svn.core.IStateFilter;
import org.eclipse.team.svn.core.resource.ILocalResource;
import org.eclipse.team.svn.core.svnstorage.SVNRemoteStorage;
import org.eclipse.team.svn.core.utility.FileUtility;
import org.eclipse.team.svn.ui.SVNTeamUIPlugin;
import org.eclipse.team.svn.ui.dialog.DefaultDialog;
import org.eclipse.team.svn.ui.panel.local.ResourceListPanel;

public class UnacceptableOperationNotificator {
    public static IResource[] shrinkResourcesWithNotOnRespositoryParents(Shell shell, IResource[] resources) {
        Object parents;
        HashSet<IResource> resultResources = new HashSet<IResource>();
        HashMap<IResource, Object> unsupportedResources = new HashMap<IResource, Object>();
        if (resources == null) {
            return null;
        }
        int i = 0;
        while (i < resources.length) {
            parents = FileUtility.getOperableParents((IResource[])new IResource[]{resources[i]}, (IStateFilter)IStateFilter.SF_NOTONREPOSITORY, (boolean)true);
            ILocalResource local = SVNRemoteStorage.instance().asLocalResourceAccessible(resources[i]);
            if (((IResource[])parents).length > 0 && IStateFilter.SF_ONREPOSITORY.accept(local)) {
                unsupportedResources.put(resources[i], parents);
            } else {
                resultResources.add(resources[i]);
            }
            ++i;
        }
        if (!resultResources.isEmpty() && !unsupportedResources.isEmpty()) {
            Iterator iter = unsupportedResources.keySet().iterator();
            while (iter.hasNext()) {
                IResource res = (IResource)iter.next();
                List<IResource> listOfParents = Arrays.asList((IResource[])unsupportedResources.get(res));
                if (!resultResources.containsAll(listOfParents)) continue;
                iter.remove();
            }
        }
        boolean[] isCanceled = new boolean[1];
        if (!unsupportedResources.isEmpty()) {
            parents = new HashSet();
            for (IResource res : unsupportedResources.keySet()) {
                ((AbstractCollection)parents).addAll((Collection)Arrays.asList((IResource[])unsupportedResources.get(res)));
            }
            shell.getDisplay().syncExec(new Runnable((HashSet)parents, unsupportedResources, shell, isCanceled){
                private final /* synthetic */ HashSet val$parents;
                private final /* synthetic */ Map val$unsupportedResources;
                private final /* synthetic */ Shell val$shell;
                private final /* synthetic */ boolean[] val$isCanceled;
                {
                    this.val$parents = hashSet;
                    this.val$unsupportedResources = map;
                    this.val$shell = shell;
                    this.val$isCanceled = blArray;
                }

                public void run() {
                    String defaultMessage;
                    String description;
                    boolean oneResource;
                    boolean oneParent = this.val$parents.size() == 1;
                    boolean bl = oneResource = this.val$unsupportedResources.size() == 1;
                    if (oneParent && oneResource) {
                        description = SVNTeamUIPlugin.instance().getResource("UnacceptableOperation.Description.1");
                        defaultMessage = SVNTeamUIPlugin.instance().getResource("UnacceptableOperation.Message.1");
                    } else if (!oneParent && oneResource) {
                        description = SVNTeamUIPlugin.instance().getResource("UnacceptableOperation.Description.2");
                        defaultMessage = SVNTeamUIPlugin.instance().getResource("UnacceptableOperation.Message.2");
                    } else if (oneParent && !oneResource) {
                        description = SVNTeamUIPlugin.instance().getResource("UnacceptableOperation.Description.3");
                        defaultMessage = SVNTeamUIPlugin.instance().getResource("UnacceptableOperation.Message.3");
                    } else {
                        description = SVNTeamUIPlugin.instance().getResource("UnacceptableOperation.Description.4");
                        defaultMessage = SVNTeamUIPlugin.instance().getResource("UnacceptableOperation.Message.4");
                    }
                    ResourceListPanel panel = new ResourceListPanel(this.val$unsupportedResources.keySet().toArray(new IResource[this.val$unsupportedResources.keySet().size()]), SVNTeamUIPlugin.instance().getResource("UnacceptableOperation.Title"), description, defaultMessage, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL});
                    DefaultDialog dialog = new DefaultDialog(this.val$shell, panel);
                    if (dialog.open() != 0) {
                        this.val$isCanceled[0] = true;
                    }
                }
            });
            if (isCanceled[0]) {
                return null;
            }
            resultResources.addAll((Collection<IResource>)parents);
        }
        return resultResources.toArray(new IResource[resultResources.size()]);
    }
}

