/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.synchronize.update;

import java.util.Collection;
import org.eclipse.core.resources.IResource;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.internal.ui.TeamUIMessages;
import org.eclipse.team.svn.ui.SVNTeamUIPlugin;
import org.eclipse.team.svn.ui.extension.ExtensionsManager;
import org.eclipse.team.svn.ui.synchronize.AbstractSVNParticipant;
import org.eclipse.team.svn.ui.synchronize.AbstractSVNSubscriber;
import org.eclipse.team.svn.ui.synchronize.AbstractSynchronizeActionGroup;
import org.eclipse.team.svn.ui.synchronize.update.UpdateSubscriber;
import org.eclipse.team.ui.synchronize.ISynchronizeScope;
import org.eclipse.team.ui.synchronize.ResourceScope;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpdateParticipant
extends AbstractSVNParticipant {
    public static final String PARTICIPANT_ID = "org.eclipse.team.svn.ui.synchronize.update.SynchronizeParticipant";

    public UpdateParticipant() {
    }

    public UpdateParticipant(ISynchronizeScope scope) {
        super(scope);
    }

    @Override
    public AbstractSVNSubscriber getMatchingSubscriber() {
        return UpdateSubscriber.instance();
    }

    public String getName() {
        String name = SVNTeamUIPlugin.instance().getResource("SynchronizeParticipant");
        ISynchronizeScope scope = this.getScope();
        String scopeName = scope.getName();
        if (scope instanceof ResourceScope) {
            StringBuffer buffer = new StringBuffer();
            IResource[] resources = scope.getRoots();
            int i = 0;
            while (i < resources.length) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append(resources[i].getFullPath().toString().substring(1));
                ++i;
            }
            scopeName = buffer.toString();
        }
        return NLS.bind((String)TeamUIMessages.SubscriberParticipant_namePattern, (Object[])new String[]{name, scopeName});
    }

    @Override
    protected String getParticipantId() {
        return PARTICIPANT_ID;
    }

    @Override
    protected Collection<AbstractSynchronizeActionGroup> getActionGroups() {
        return ExtensionsManager.getInstance().getCurrentSynchronizeActionContributor().getUpdateContributions();
    }

    @Override
    protected int getSupportedModes() {
        return 15;
    }

    @Override
    protected int getDefaultMode() {
        return 4;
    }
}

