/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.synchronize.action;

import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.CompareUI;
import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.team.internal.ui.synchronize.SyncInfoModelElement;
import org.eclipse.team.svn.core.IStateFilter;
import org.eclipse.team.svn.core.connector.SVNEntryRevisionReference;
import org.eclipse.team.svn.core.connector.SVNRevision;
import org.eclipse.team.svn.core.operation.IActionOperation;
import org.eclipse.team.svn.core.resource.ILocalResource;
import org.eclipse.team.svn.core.resource.IResourceChange;
import org.eclipse.team.svn.ui.compare.ThreeWayPropertyCompareInput;
import org.eclipse.team.svn.ui.synchronize.AbstractSVNSyncInfo;
import org.eclipse.team.svn.ui.synchronize.action.AbstractSynchronizeModelAction;
import org.eclipse.team.svn.ui.synchronize.variant.ResourceVariant;
import org.eclipse.team.ui.synchronize.ISynchronizeModelElement;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;

public class MergePropertiesAction
extends AbstractSynchronizeModelAction {
    public MergePropertiesAction(String text, ISynchronizePageConfiguration configuration) {
        super(text, configuration);
    }

    protected boolean needsToSaveDirtyEditors() {
        return false;
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        ISynchronizeModelElement element;
        super.updateSelection(selection);
        if (selection.size() == 1 && selection.getFirstElement() instanceof SyncInfoModelElement && (element = (ISynchronizeModelElement)selection.getFirstElement()) instanceof SyncInfoModelElement) {
            AbstractSVNSyncInfo syncInfo = (AbstractSVNSyncInfo)((SyncInfoModelElement)selection.getFirstElement()).getSyncInfo();
            ILocalResource incoming = ((ResourceVariant)syncInfo.getRemote()).getResource();
            if (!(incoming instanceof IResourceChange)) {
                return false;
            }
            boolean retVal = IStateFilter.SF_EXCLUDE_DELETED.accept(incoming);
            if (incoming instanceof IResourceChange) {
                retVal &= "Deleted" != incoming.getStatus();
            }
            return retVal && ((incoming.getChangeMask() & 2) != 0 || (syncInfo.getLocalResource().getChangeMask() & 2) != 0);
        }
        return false;
    }

    protected IActionOperation getOperation(ISynchronizePageConfiguration configuration, IDiffElement[] elements) {
        IResource resource = this.getSelectedResource();
        AbstractSVNSyncInfo syncInfo = (AbstractSVNSyncInfo)((SyncInfoModelElement)elements[0]).getSyncInfo();
        IResourceChange right = (IResourceChange)((ResourceVariant)syncInfo.getRemote()).getResource();
        IResourceChange ancestor = (IResourceChange)((ResourceVariant)syncInfo.getBase()).getResource();
        SVNEntryRevisionReference baseReference = new SVNEntryRevisionReference(ancestor.getOriginator().getUrl(), ancestor.getPegRevision(), (SVNRevision)SVNRevision.fromNumber((long)ancestor.getRevision()));
        SVNEntryRevisionReference remoteReference = new SVNEntryRevisionReference(right.getOriginator().getUrl(), right.getPegRevision(), (SVNRevision)SVNRevision.fromNumber((long)right.getRevision()));
        ThreeWayPropertyCompareInput input = new ThreeWayPropertyCompareInput(new CompareConfiguration(), resource, remoteReference, baseReference, right.getOriginator().getRepositoryLocation(), -1L);
        CompareUI.openCompareEditor((CompareEditorInput)input);
        return null;
    }
}

