/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.synchronize.action;

import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.CompareUI;
import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.team.internal.ui.synchronize.SyncInfoModelElement;
import org.eclipse.team.svn.core.IStateFilter;
import org.eclipse.team.svn.core.connector.SVNEntryRevisionReference;
import org.eclipse.team.svn.core.connector.SVNRevision;
import org.eclipse.team.svn.core.operation.IActionOperation;
import org.eclipse.team.svn.core.resource.ILocalResource;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.core.resource.IResourceChange;
import org.eclipse.team.svn.core.svnstorage.SVNRemoteStorage;
import org.eclipse.team.svn.core.utility.FileUtility;
import org.eclipse.team.svn.ui.compare.ThreeWayPropertyCompareInput;
import org.eclipse.team.svn.ui.synchronize.AbstractSVNSyncInfo;
import org.eclipse.team.svn.ui.synchronize.action.AbstractSynchronizeModelAction;
import org.eclipse.team.svn.ui.synchronize.variant.RemoteResourceVariant;
import org.eclipse.team.svn.ui.synchronize.variant.ResourceVariant;
import org.eclipse.team.ui.synchronize.ISynchronizeModelElement;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;

public class ComparePropertiesAction
extends AbstractSynchronizeModelAction {
    public ComparePropertiesAction(String text, ISynchronizePageConfiguration configuration) {
        super(text, configuration);
    }

    protected boolean needsToSaveDirtyEditors() {
        return false;
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        ISynchronizeModelElement element;
        super.updateSelection(selection);
        if (selection.size() == 1 && selection.getFirstElement() instanceof SyncInfoModelElement && (element = (ISynchronizeModelElement)selection.getFirstElement()) instanceof SyncInfoModelElement) {
            AbstractSVNSyncInfo syncInfo = (AbstractSVNSyncInfo)((SyncInfoModelElement)selection.getFirstElement()).getSyncInfo();
            ILocalResource incoming = ((ResourceVariant)syncInfo.getRemote()).getResource();
            boolean retVal = IStateFilter.SF_EXCLUDE_DELETED.accept(incoming);
            if (incoming instanceof IResourceChange) {
                retVal &= "Deleted" != incoming.getStatus();
            }
            return retVal && ((incoming.getChangeMask() & 2) != 0 || (syncInfo.getLocalResource().getChangeMask() & 2) != 0 || incoming.getResource() instanceof IContainer);
        }
        return false;
    }

    protected IActionOperation getOperation(ISynchronizePageConfiguration configuration, IDiffElement[] elements) {
        SVNEntryRevisionReference baseReference;
        IResource resource = this.getSelectedResource();
        ILocalResource baseResource = SVNRemoteStorage.instance().asLocalResource(resource);
        IRepositoryResource remote = SVNRemoteStorage.instance().asRepositoryResource(resource);
        SVNEntryRevisionReference remoteReference = baseReference = new SVNEntryRevisionReference(FileUtility.getWorkingCopyPath((IResource)resource), null, SVNRevision.BASE);
        ILocalResource change = ((RemoteResourceVariant)this.getSelectedSVNSyncInfo().getRemote()).getResource();
        if (change instanceof IResourceChange) {
            remote = ((IResourceChange)change).getOriginator();
            remoteReference = new SVNEntryRevisionReference(remote.getUrl(), remote.getPegRevision(), (SVNRevision)SVNRevision.fromNumber((long)((IResourceChange)change).getRevision()));
        }
        ThreeWayPropertyCompareInput input = new ThreeWayPropertyCompareInput(new CompareConfiguration(), resource, remoteReference, baseReference, remote.getRepositoryLocation(), baseResource.getRevision());
        CompareUI.openCompareEditor((CompareEditorInput)input);
        return null;
    }
}

