/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.preferences;

import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import org.eclipse.compare.internal.TabFolderLayout;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.team.svn.core.extension.CoreExtensionsManager;
import org.eclipse.team.svn.core.extension.factory.ISVNConnectorFactory;
import org.eclipse.team.svn.core.svnstorage.SVNRemoteStorage;
import org.eclipse.team.svn.ui.SVNTeamUIPlugin;
import org.eclipse.team.svn.ui.preferences.AbstractSVNTeamPreferencesPage;
import org.eclipse.team.svn.ui.preferences.SVNTeamPreferences;
import org.eclipse.team.svn.ui.verifier.AbstractVerifierProxy;
import org.eclipse.team.svn.ui.verifier.CompositeVerifier;
import org.eclipse.team.svn.ui.verifier.DateFormatVerifier;
import org.eclipse.team.svn.ui.verifier.IntegerFieldVerifier;
import org.eclipse.team.svn.ui.verifier.NonEmptyFieldVerifier;
import org.eclipse.team.svn.ui.verifier.ResourceNameVerifier;
import org.eclipse.ui.PlatformUI;

public class SVNTeamPreferencesPage
extends AbstractSVNTeamPreferencesPage {
    protected String head;
    protected String branches;
    protected String tags;
    protected boolean showExternals;
    protected boolean fastReport;
    protected boolean pagingEnable;
    protected boolean connectToCompareWith;
    protected int pageSize;
    protected int dateFormat;
    protected String dateFormatCustom;
    protected boolean mailReporterEnabled;
    protected boolean mailReporterErrorsEnabled;
    protected boolean commitSelectNewResources;
    protected boolean useSubversionExternalsBehaviour;
    protected String svnConnector;
    protected ISVNConnectorFactory[] factories;
    protected boolean useJavaHLMerge;
    protected boolean includeMergedRevisions;
    protected boolean checkoutUsingDotProjectName;
    protected boolean checkoutRespectProjectStructure;
    protected boolean branchTagConsiderStructure;
    protected boolean forceExternalsFreeze;
    protected boolean computeKeywordsValues;
    protected boolean enableAutoShare;
    protected boolean caseInsensitiveSorting;
    protected Text headField;
    protected Text branchesField;
    protected Text tagsField;
    protected Button showExternalsButton;
    protected Combo svnConnectorField;
    protected Button useInteractiveMergeButton;
    protected Button includeMergedRevisionsButton;
    protected Button fastReportButton;
    protected Button enablePagingButton;
    protected Button connectToCompareWithButton;
    protected Text pageSizeField;
    protected Combo dateFormatField;
    protected Text dateFormatCustomField;
    protected Button mailReporterEnabledButton;
    protected Button mailReporterErrorsEnabledButton;
    protected Button btnResourceSelectionNew;
    protected Button btnResourceSelectionExternal;
    protected Button checkoutUsingDotProjectNameButton;
    protected Button checkoutRespectProjectStructureButton;
    protected Button branchTagConsiderStructureButton;
    protected Button branchTagManualUrlEditButton;
    protected Button computeKeywordsValuesButton;
    protected Button enableAutoShareButton;
    protected Button caseInsensitiveSortingButton;
    protected Button forceExternalsFreezeButton;

    protected void saveValues(IPreferenceStore store) {
        SVNTeamPreferences.setRepositoryString(store, "head", this.head);
        SVNTeamPreferences.setRepositoryString(store, "branches", this.branches);
        SVNTeamPreferences.setRepositoryString(store, "tags", this.tags);
        SVNTeamPreferences.setRepositoryBoolean(store, "tagConsideringProjectStructure", this.branchTagConsiderStructure);
        SVNTeamPreferences.setRepositoryBoolean(store, "forceExternalsFreeze", this.forceExternalsFreeze);
        SVNTeamPreferences.setRepositoryBoolean(store, "showExternals", this.showExternals);
        SVNTeamPreferences.setSynchronizeBoolean(store, "fastReport", this.fastReport);
        SVNTeamPreferences.setHistoryInt(store, "pageSize", this.pageSize);
        SVNTeamPreferences.setHistoryBoolean(store, "pagingEnable", this.pagingEnable);
        SVNTeamPreferences.setHistoryBoolean(store, "connectToCompareWith", this.connectToCompareWith);
        SVNTeamPreferences.setDateFormatInt(store, "dateFormat", this.dateFormat);
        SVNTeamPreferences.setDateFormatString(store, "dateFormatCustom", this.dateFormatCustom);
        SVNTeamPreferences.setMailReporterBoolean(store, "enabled", this.mailReporterEnabled);
        SVNTeamPreferences.setMailReporterBoolean(store, "errorsEnabled", this.mailReporterErrorsEnabled);
        SVNTeamPreferences.setBehaviourBoolean(store, "resourceSelection.selectNew", this.commitSelectNewResources);
        SVNTeamPreferences.setBehaviourBoolean(store, "resourceSelection.treatExternalAsLocal", this.useSubversionExternalsBehaviour);
        SVNTeamPreferences.setBehaviourBoolean(store, "share.enableAuto", this.enableAutoShare);
        SVNTeamPreferences.setBehaviourBoolean(store, "keywords.computeValues", this.computeKeywordsValues);
        SVNTeamPreferences.setBehaviourBoolean(store, "sorting.case.insensitive", this.caseInsensitiveSorting);
        String oldId = CoreExtensionsManager.instance().getSVNConnectorFactory().getId();
        if (!oldId.equals(this.svnConnector)) {
            SVNTeamPreferences.setCoreString(store, "svnconnector", this.svnConnector);
            SVNRemoteStorage.instance().dispose();
        }
        SVNTeamPreferences.setMergeBoolean(store, "useJavaHL", this.useJavaHLMerge);
        SVNTeamPreferences.setMergeBoolean(store, "includeMerged", this.includeMergedRevisions);
        SVNTeamPreferences.setCheckoutBoolean(store, "useDotProject", this.checkoutUsingDotProjectName);
        SVNTeamPreferences.setCheckoutBoolean(store, "respectProjectStructure", this.checkoutRespectProjectStructure);
    }

    protected void loadDefaultValues(IPreferenceStore store) {
        this.head = "trunk";
        this.branches = "branches";
        this.tags = "tags";
        this.showExternals = true;
        this.fastReport = true;
        this.pagingEnable = true;
        this.pageSize = 25;
        this.connectToCompareWith = true;
        this.dateFormat = 0;
        this.dateFormatCustom = "";
        this.mailReporterEnabled = true;
        this.mailReporterErrorsEnabled = true;
        this.commitSelectNewResources = true;
        this.useSubversionExternalsBehaviour = true;
        this.useJavaHLMerge = false;
        this.includeMergedRevisions = false;
        this.checkoutUsingDotProjectName = true;
        this.checkoutRespectProjectStructure = false;
        this.branchTagConsiderStructure = true;
        this.forceExternalsFreeze = true;
        this.computeKeywordsValues = true;
        this.enableAutoShare = true;
        this.caseInsensitiveSorting = true;
        this.svnConnector = "org.eclipse.team.svn.connector.svnkit";
    }

    protected void loadValues(IPreferenceStore store) {
        this.head = SVNTeamPreferences.getRepositoryString(store, "head");
        this.branches = SVNTeamPreferences.getRepositoryString(store, "branches");
        this.tags = SVNTeamPreferences.getRepositoryString(store, "tags");
        this.showExternals = SVNTeamPreferences.getRepositoryBoolean(store, "showExternals");
        this.fastReport = SVNTeamPreferences.getSynchronizeBoolean(store, "fastReport");
        this.connectToCompareWith = SVNTeamPreferences.getHistoryBoolean(store, "connectToCompareWith");
        this.pagingEnable = SVNTeamPreferences.getHistoryBoolean(store, "pagingEnable");
        this.pageSize = SVNTeamPreferences.getHistoryInt(store, "pageSize");
        this.dateFormat = SVNTeamPreferences.getDateFormatInt(store, "dateFormat");
        this.dateFormatCustom = SVNTeamPreferences.getDateFormatString(store, "dateFormatCustom");
        this.mailReporterEnabled = SVNTeamPreferences.getMailReporterBoolean(store, "enabled");
        this.mailReporterErrorsEnabled = SVNTeamPreferences.getMailReporterBoolean(store, "errorsEnabled");
        this.commitSelectNewResources = SVNTeamPreferences.getBehaviourBoolean(store, "resourceSelection.selectNew");
        this.useSubversionExternalsBehaviour = SVNTeamPreferences.getBehaviourBoolean(store, "resourceSelection.treatExternalAsLocal");
        this.enableAutoShare = SVNTeamPreferences.getBehaviourBoolean(store, "share.enableAuto");
        this.computeKeywordsValues = SVNTeamPreferences.getBehaviourBoolean(store, "keywords.computeValues");
        this.caseInsensitiveSorting = SVNTeamPreferences.getBehaviourBoolean(store, "sorting.case.insensitive");
        this.useJavaHLMerge = SVNTeamPreferences.getMergeBoolean(store, "useJavaHL");
        this.includeMergedRevisions = SVNTeamPreferences.getMergeBoolean(store, "includeMerged");
        this.checkoutUsingDotProjectName = SVNTeamPreferences.getCheckoutBoolean(store, "useDotProject");
        this.checkoutRespectProjectStructure = SVNTeamPreferences.getCheckoutBoolean(store, "respectProjectStructure");
        this.branchTagConsiderStructure = SVNTeamPreferences.getRepositoryBoolean(store, "tagConsideringProjectStructure");
        this.forceExternalsFreeze = SVNTeamPreferences.getRepositoryBoolean(store, "forceExternalsFreeze");
        this.svnConnector = CoreExtensionsManager.instance().getSVNConnectorFactory().getId();
    }

    protected void initializeControls() {
        this.headField.setText(this.head);
        this.branchesField.setText(this.branches);
        this.tagsField.setText(this.tags);
        this.showExternalsButton.setSelection(this.showExternals);
        this.fastReportButton.setSelection(this.fastReport);
        this.pageSizeField.setText(String.valueOf(this.pageSize));
        this.enablePagingButton.setSelection(this.pagingEnable);
        this.pageSizeField.setEnabled(this.pagingEnable);
        this.connectToCompareWithButton.setSelection(this.connectToCompareWith);
        this.dateFormatField.select(this.dateFormat);
        this.dateFormatCustomField.setText(this.dateFormatCustom);
        this.mailReporterEnabledButton.setSelection(this.mailReporterEnabled);
        this.mailReporterErrorsEnabledButton.setSelection(this.mailReporterErrorsEnabled);
        this.btnResourceSelectionNew.setSelection(this.commitSelectNewResources);
        this.btnResourceSelectionExternal.setSelection(this.useSubversionExternalsBehaviour);
        List<ISVNConnectorFactory> factoriesList = Arrays.asList(this.factories);
        this.svnConnectorField.select(factoriesList.indexOf(CoreExtensionsManager.instance().getSVNConnectorFactory(this.svnConnector)));
        this.initializeClientSettings();
        this.checkoutUsingDotProjectNameButton.setSelection(this.checkoutUsingDotProjectName);
        this.checkoutRespectProjectStructureButton.setSelection(this.checkoutRespectProjectStructure);
        this.branchTagConsiderStructureButton.setSelection(this.branchTagConsiderStructure);
        this.forceExternalsFreezeButton.setSelection(this.forceExternalsFreeze);
        this.branchTagManualUrlEditButton.setSelection(!this.branchTagConsiderStructure);
        this.computeKeywordsValuesButton.setSelection(this.computeKeywordsValues);
        this.enableAutoShareButton.setSelection(this.enableAutoShare);
        this.caseInsensitiveSortingButton.setSelection(this.caseInsensitiveSorting);
    }

    protected void initializeClientSettings() {
        boolean isSVN15CompatibleConnector = CoreExtensionsManager.instance().getSVNConnectorFactory(this.svnConnector).getSVNAPIVersion() >= 5;
        this.useInteractiveMergeButton.setSelection(!this.useJavaHLMerge);
        this.includeMergedRevisionsButton.setSelection(this.includeMergedRevisions);
        this.includeMergedRevisionsButton.setEnabled(isSVN15CompatibleConnector);
    }

    protected Control createContentsImpl(Composite parent) {
        TabFolder tabFolder = new TabFolder(parent, 0);
        tabFolder.setLayout((Layout)new TabFolderLayout());
        tabFolder.setLayoutData((Object)new GridData(1808));
        TabItem tabItem = new TabItem(tabFolder, 0);
        tabItem.setText(SVNTeamUIPlugin.instance().getResource("MainPreferencePage.generalTabName"));
        tabItem.setControl(this.createGeneralPage((Composite)tabFolder));
        tabItem = new TabItem(tabFolder, 0);
        tabItem.setText(SVNTeamUIPlugin.instance().getResource("MainPreferencePage.svnConnectorTabName"));
        tabItem.setControl(this.createSVNConnectorsPage((Composite)tabFolder));
        tabItem = new TabItem(tabFolder, 0);
        tabItem.setText(SVNTeamUIPlugin.instance().getResource("MainPreferencePage.repositoryTabName"));
        tabItem.setControl(this.createRepositorySettingsPage((Composite)tabFolder));
        tabItem = new TabItem(tabFolder, 0);
        tabItem.setText(SVNTeamUIPlugin.instance().getResource("MainPreferencePage.viewSettingsTabName"));
        tabItem.setControl(this.createViewSettingsPage((Composite)tabFolder));
        tabItem = new TabItem(tabFolder, 0);
        tabItem.setText(SVNTeamUIPlugin.instance().getResource("MainPreferencePage.mailReporterGroupName"));
        tabItem.setControl(this.createErrorReportingSettingsPage((Composite)tabFolder));
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.team.svn.help.SVNPreferencesContext");
        return tabFolder;
    }

    protected Control createSVNConnectorsPage(Composite parent) {
        GridLayout layout = null;
        GridData data = null;
        Composite composite = new Composite(parent, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        data = new GridData(1808);
        composite.setLayoutData((Object)data);
        Label label = new Label(composite, 64);
        data = new GridData(768);
        data.widthHint = 450;
        data.horizontalSpan = 2;
        label.setLayoutData((Object)data);
        label.setText(SVNTeamUIPlugin.instance().getResource("MainPreferencePage.svnConnectorPrompt"));
        label = new Label(composite, 0);
        data = new GridData();
        label.setLayoutData((Object)data);
        label.setText(SVNTeamUIPlugin.instance().getResource("MainPreferencePage.svnConnector"));
        this.svnConnectorField = new Combo(composite, 8);
        data = new GridData(768);
        data.widthHint = 100;
        this.svnConnectorField.setLayoutData((Object)data);
        Collection fullSet = CoreExtensionsManager.instance().getAccessibleClients();
        this.factories = fullSet.toArray(new ISVNConnectorFactory[fullSet.size()]);
        Arrays.sort(this.factories, new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                return ((ISVNConnectorFactory)o1).getName().compareTo(((ISVNConnectorFactory)o2).getName());
            }
        });
        String[] items = new String[fullSet.size()];
        int i = 0;
        while (i < items.length) {
            items[i] = String.valueOf(this.factories[i].getName()) + " (" + this.factories[i].getClientVersion().replace('\n', ' ') + ")";
            ++i;
        }
        this.svnConnectorField.setItems(items);
        this.svnConnectorField.setVisibleItemCount(items.length);
        this.svnConnectorField.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SVNTeamPreferencesPage.this.svnConnector = SVNTeamPreferencesPage.this.factories[SVNTeamPreferencesPage.this.svnConnectorField.getSelectionIndex()].getId();
                SVNTeamPreferencesPage.this.initializeClientSettings();
            }
        });
        Group group = new Group(composite, 0);
        group.setLayout((Layout)new GridLayout());
        data = new GridData(768);
        data.horizontalSpan = 2;
        group.setLayoutData((Object)data);
        group.setText(SVNTeamUIPlugin.instance().getResource("MainPreferencePage.mergeGroupName"));
        label = new Label((Composite)group, 64);
        data = new GridData(768);
        data.widthHint = 450;
        label.setLayoutData((Object)data);
        label.setText(SVNTeamUIPlugin.instance().getResource("MainPreferencePage.mergePrompt"));
        this.useInteractiveMergeButton = new Button((Composite)group, 32);
        data = new GridData();
        this.useInteractiveMergeButton.setLayoutData((Object)data);
        this.useInteractiveMergeButton.setText(SVNTeamUIPlugin.instance().getResource("MainPreferencePage.mergeUseInteractiveMerge"));
        this.useInteractiveMergeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SVNTeamPreferencesPage.this.useJavaHLMerge = !SVNTeamPreferencesPage.this.useInteractiveMergeButton.getSelection();
            }
        });
        label = new Label((Composite)group, 258);
        label.setVisible(false);
        label = new Label((Composite)group, 64);
        data = new GridData(768);
        data.widthHint = 450;
        label.setLayoutData((Object)data);
        label.setText(SVNTeamUIPlugin.instance().getResource("MainPreferencePage.includeMergedRevisionsLabel"));
        this.includeMergedRevisionsButton = new Button((Composite)group, 32);
        data = new GridData();
        this.includeMergedRevisionsButton.setLayoutData((Object)data);
        this.includeMergedRevisionsButton.setText(SVNTeamUIPlugin.instance().getResource("MainPreferencePage.includeMergedRevisions"));
        this.includeMergedRevisionsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SVNTeamPreferencesPage.this.includeMergedRevisions = SVNTeamPreferencesPage.this.includeMergedRevisionsButton.getSelection();
            }
        });
        return composite;
    }

    protected Control createGeneralPage(Composite parent) {
        GridLayout layout = null;
        GridData data = null;
        Composite composite = new Composite(parent, 0);
        layout = new GridLayout();
        composite.setLayout((Layout)layout);
        data = new GridData(1808);
        composite.setLayoutData((Object)data);
        Group group = new Group(composite, 0);
        group.setLayout((Layout)new GridLayout());
        group.setLayoutData((Object)new GridData(768));
        group.setText(SVNTeamUIPlugin.instance().getResource("MainPreferencePage.resourceSelectionGroupName"));
        Label label = new Label((Composite)group, 64);
        data = new GridData(768);
        data.widthHint = 450;
        label.setLayoutData((Object)data);
        label.setText(SVNTeamUIPlugin.instance().getResource("MainPreferencePage.resourceSelectionPrompt"));
        this.btnResourceSelectionNew = new Button((Composite)group, 32);
        data = new GridData();
        this.btnResourceSelectionNew.setLayoutData((Object)data);
        this.btnResourceSelectionNew.setText(SVNTeamUIPlugin.instance().getResource("MainPreferencePage.resourceSelectionNew"));
        this.btnResourceSelectionNew.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SVNTeamPreferencesPage.this.commitSelectNewResources = SVNTeamPreferencesPage.this.btnResourceSelectionNew.getSelection();
            }
        });
        this.btnResourceSelectionExternal = new Button((Composite)group, 32);
        data = new GridData();
        this.btnResourceSelectionExternal.setLayoutData((Object)data);
        this.btnResourceSelectionExternal.setText(SVNTeamUIPlugin.instance().getResource("MainPreferencePage.resourceSelectionExternal"));
        this.btnResourceSelectionExternal.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SVNTeamPreferencesPage.this.useSubversionExternalsBehaviour = SVNTeamPreferencesPage.this.btnResourceSelectionExternal.getSelection();
            }
        });
        group = new Group(composite, 0);
        group.setLayout((Layout)new GridLayout());
        group.setLayoutData((Object)new GridData(768));
        group.setText(SVNTeamUIPlugin.instance().getResource("MainPreferencePage.shareGroupName"));
        label = new Label((Composite)group, 64);
        data = new GridData(768);
        data.widthHint = 450;
        label.setLayoutData((Object)data);
        label.setText(SVNTeamUIPlugin.instance().getResource("MainPreferencePage.sharePrompt"));
        this.enableAutoShareButton = new Button((Composite)group, 32);
        data = new GridData();
        this.enableAutoShareButton.setLayoutData((Object)data);
        this.enableAutoShareButton.setText(SVNTeamUIPlugin.instance().getResource("MainPreferencePage.shareEnableAuto"));
        this.enableAutoShareButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SVNTeamPreferencesPage.this.enableAutoShare = SVNTeamPreferencesPage.this.enableAutoShareButton.getSelection();
            }
        });
        group = new Group(composite, 0);
        group.setLayout((Layout)new GridLayout());
        group.setLayoutData((Object)new GridData(768));
        group.setText(SVNTeamUIPlugin.instance().getResource("MainPreferencePage.keywordsGroupName"));
        label = new Label((Composite)group, 64);
        data = new GridData(768);
        data.widthHint = 450;
        label.setLayoutData((Object)data);
        label.setText(SVNTeamUIPlugin.instance().getResource("MainPreferencePage.keywordsPrompt"));
        this.computeKeywordsValuesButton = new Button((Composite)group, 32);
        data = new GridData();
        this.computeKeywordsValuesButton.setLayoutData((Object)data);
        this.computeKeywordsValuesButton.setText(SVNTeamUIPlugin.instance().getResource("MainPreferencePage.keywordsComputeRecursively"));
        this.computeKeywordsValuesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SVNTeamPreferencesPage.this.computeKeywordsValues = SVNTeamPreferencesPage.this.computeKeywordsValuesButton.getSelection();
            }
        });
        group = new Group(composite, 0);
        group.setLayout((Layout)new GridLayout());
        group.setLayoutData((Object)new GridData(768));
        group.setText(SVNTeamUIPlugin.instance().getResource("MainPreferencePage.tableSortingGroupName"));
        label = new Label((Composite)group, 64);
        data = new GridData(768);
        data.widthHint = 450;
        label.setLayoutData((Object)data);
        label.setText(SVNTeamUIPlugin.instance().getResource("MainPreferencePage.tableSortingPrompt"));
        this.caseInsensitiveSortingButton = new Button((Composite)group, 32);
        data = new GridData();
        this.caseInsensitiveSortingButton.setLayoutData((Object)data);
        this.caseInsensitiveSortingButton.setText(SVNTeamUIPlugin.instance().getResource("MainPreferencePage.tableSortingCaseInsensitive"));
        this.caseInsensitiveSortingButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SVNTeamPreferencesPage.this.caseInsensitiveSorting = SVNTeamPreferencesPage.this.caseInsensitiveSortingButton.getSelection();
            }
        });
        return composite;
    }

    protected Control createViewSettingsPage(Composite parent) {
        GridLayout layout = null;
        GridData data = null;
        Composite composite = new Composite(parent, 0);
        layout = new GridLayout();
        composite.setLayout((Layout)layout);
        data = new GridData(1808);
        composite.setLayoutData((Object)data);
        Group synchViewGroup = new Group(composite, 0);
        layout = new GridLayout();
        synchViewGroup.setLayout((Layout)layout);
        data = new GridData(768);
        synchViewGroup.setLayoutData((Object)data);
        Group historyViewGroup = new Group(composite, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        historyViewGroup.setLayout((Layout)layout);
        data = new GridData(768);
        historyViewGroup.setLayoutData((Object)data);
        Group dateFormatGroup = new Group(composite, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        dateFormatGroup.setLayout((Layout)layout);
        data = new GridData(768);
        dateFormatGroup.setLayoutData((Object)data);
        synchViewGroup.setText(SVNTeamUIPlugin.instance().getResource("MainPreferencePage.synchronizeGroupName"));
        Label label = new Label((Composite)synchViewGroup, 0);
        label.setLayoutData((Object)new GridData());
        label.setText(SVNTeamUIPlugin.instance().getResource("MainPreferencePage.synchronizePrompt"));
        this.fastReportButton = new Button((Composite)synchViewGroup, 32);
        data = new GridData();
        this.fastReportButton.setLayoutData((Object)data);
        this.fastReportButton.setText(SVNTeamUIPlugin.instance().getResource("MainPreferencePage.synchronizeFastReportName"));
        this.fastReportButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SVNTeamPreferencesPage.this.fastReport = SVNTeamPreferencesPage.this.fastReportButton.getSelection();
            }
        });
        historyViewGroup.setText(SVNTeamUIPlugin.instance().getResource("MainPreferencePage.historyGroupName"));
        label = new Label((Composite)historyViewGroup, 64);
        data = new GridData(768);
        data.horizontalSpan = 2;
        label.setLayoutData((Object)data);
        label.setText(SVNTeamUIPlugin.instance().getResource("MainPreferencePage.historyPrompt"));
        this.enablePagingButton = new Button((Composite)historyViewGroup, 32);
        data = new GridData();
        this.enablePagingButton.setLayoutData((Object)data);
        String labelText = SVNTeamUIPlugin.instance().getResource("MainPreferencePage.historyEnablePaging");
        this.enablePagingButton.setText(labelText);
        this.enablePagingButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (SVNTeamPreferencesPage.this.enablePagingButton.getSelection()) {
                    SVNTeamPreferencesPage.this.pageSizeField.setEnabled(true);
                    int tmpPageSize = Integer.parseInt(SVNTeamPreferencesPage.this.pageSizeField.getText());
                    SVNTeamPreferencesPage.this.pageSize = tmpPageSize == 0 ? 25 : tmpPageSize;
                    SVNTeamPreferencesPage.this.pageSizeField.setText(String.valueOf(SVNTeamPreferencesPage.this.pageSize));
                    SVNTeamPreferencesPage.this.pagingEnable = true;
                } else {
                    SVNTeamPreferencesPage.this.pagingEnable = false;
                    SVNTeamPreferencesPage.this.pageSizeField.setEnabled(false);
                }
            }
        });
        this.pageSizeField = new Text((Composite)historyViewGroup, 2052);
        data = new GridData(768);
        data.grabExcessHorizontalSpace = true;
        this.pageSizeField.setLayoutData((Object)data);
        CompositeVerifier verifier = new CompositeVerifier();
        verifier.add(new NonEmptyFieldVerifier(labelText));
        verifier.add(new IntegerFieldVerifier(labelText, true));
        this.attachTo((Control)this.pageSizeField, verifier);
        this.pageSizeField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                try {
                    SVNTeamPreferencesPage.this.pageSize = Integer.parseInt(SVNTeamPreferencesPage.this.pageSizeField.getText());
                }
                catch (Exception exception) {}
            }
        });
        this.connectToCompareWithButton = new Button((Composite)historyViewGroup, 32);
        data = new GridData();
        data.horizontalSpan = 2;
        this.connectToCompareWithButton.setLayoutData((Object)data);
        labelText = SVNTeamUIPlugin.instance().getResource("MainPreferencePage.historyConnectToCompareWith");
        this.connectToCompareWithButton.setText(labelText);
        this.connectToCompareWithButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SVNTeamPreferencesPage.this.connectToCompareWith = ((Button)e.widget).getSelection();
            }
        });
        dateFormatGroup.setText(SVNTeamUIPlugin.instance().getResource("MainPreferencePage.dateFormatGroupName"));
        label = new Label((Composite)dateFormatGroup, 64);
        data = new GridData(768);
        data.horizontalSpan = 2;
        label.setLayoutData((Object)data);
        labelText = SVNTeamUIPlugin.instance().getResource("MainPreferencePage.dateFormatPrompt");
        label.setText(labelText);
        this.dateFormatField = new Combo((Composite)dateFormatGroup, 12);
        String[] itemsDateFormat = new String[]{SVNTeamUIPlugin.instance().getResource("MainPreferencePage.dateFormatShort"), SVNTeamUIPlugin.instance().getResource("MainPreferencePage.dateFormatMedium"), SVNTeamUIPlugin.instance().getResource("MainPreferencePage.dateFormatLong"), SVNTeamUIPlugin.instance().getResource("MainPreferencePage.dateFormatCustom")};
        this.dateFormatField.setItems(itemsDateFormat);
        data = new GridData();
        data.widthHint = 100;
        this.dateFormatField.setLayoutData((Object)data);
        this.dateFormatField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SVNTeamPreferencesPage.this.dateFormat = SVNTeamPreferencesPage.this.dateFormatField.getSelectionIndex();
                if (SVNTeamPreferencesPage.this.dateFormat == 3) {
                    SVNTeamPreferencesPage.this.dateFormatCustomField.setEnabled(true);
                    SVNTeamPreferencesPage.this.dateFormatCustomField.setFocus();
                } else {
                    SVNTeamPreferencesPage.this.dateFormatCustomField.setEnabled(false);
                }
                SVNTeamPreferencesPage.this.validateContent();
            }
        });
        this.dateFormatCustomField = new Text((Composite)dateFormatGroup, 2052);
        data = new GridData(768);
        this.dateFormatCustomField.setLayoutData((Object)data);
        verifier = new CompositeVerifier();
        verifier.add(new NonEmptyFieldVerifier(labelText));
        verifier.add(new DateFormatVerifier(labelText));
        this.attachTo((Control)this.dateFormatCustomField, new AbstractVerifierProxy(verifier){

            protected boolean isVerificationEnabled(Control input) {
                return SVNTeamPreferencesPage.this.dateFormatField.getSelectionIndex() == 3;
            }
        });
        this.dateFormatCustomField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SVNTeamPreferencesPage.this.dateFormatCustom = SVNTeamPreferencesPage.this.dateFormatCustomField.getText();
            }
        });
        return composite;
    }

    protected Control createRepositorySettingsPage(Composite parent) {
        GridLayout layout = null;
        GridData data = null;
        Composite composite = new Composite(parent, 0);
        layout = new GridLayout();
        composite.setLayout((Layout)layout);
        data = new GridData(1808);
        composite.setLayoutData((Object)data);
        Group group = new Group(composite, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)new GridData(768));
        group.setText(SVNTeamUIPlugin.instance().getResource("MainPreferencePage.structureGroupName"));
        Label label = new Label((Composite)group, 0);
        data = new GridData();
        data.horizontalSpan = 2;
        label.setLayoutData((Object)data);
        label.setText(SVNTeamUIPlugin.instance().getResource("MainPreferencePage.repositoryPrompt"));
        label = new Label((Composite)group, 0);
        data = new GridData();
        label.setLayoutData((Object)data);
        String labelText = SVNTeamUIPlugin.instance().getResource("MainPreferencePage.repositoryHeadName");
        label.setText(labelText);
        this.headField = new Text((Composite)group, 2052);
        data = new GridData(768);
        data.grabExcessHorizontalSpace = true;
        this.headField.setLayoutData((Object)data);
        CompositeVerifier verifier = new CompositeVerifier();
        verifier.add(new NonEmptyFieldVerifier(labelText));
        verifier.add(new ResourceNameVerifier(labelText, false));
        this.attachTo((Control)this.headField, verifier);
        this.headField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SVNTeamPreferencesPage.this.head = SVNTeamPreferencesPage.this.headField.getText();
            }
        });
        label = new Label((Composite)group, 0);
        label.setLayoutData((Object)new GridData());
        labelText = SVNTeamUIPlugin.instance().getResource("MainPreferencePage.repositoryBranchesName");
        label.setText(labelText);
        this.branchesField = new Text((Composite)group, 2052);
        data = new GridData(768);
        data.grabExcessHorizontalSpace = true;
        this.branchesField.setLayoutData((Object)data);
        verifier = new CompositeVerifier();
        verifier.add(new NonEmptyFieldVerifier(labelText));
        verifier.add(new ResourceNameVerifier(labelText, false));
        this.attachTo((Control)this.branchesField, verifier);
        this.branchesField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SVNTeamPreferencesPage.this.branches = SVNTeamPreferencesPage.this.branchesField.getText();
            }
        });
        label = new Label((Composite)group, 0);
        label.setLayoutData((Object)new GridData());
        labelText = SVNTeamUIPlugin.instance().getResource("MainPreferencePage.repositoryTagsName");
        label.setText(labelText);
        this.tagsField = new Text((Composite)group, 2052);
        data = new GridData(768);
        data.grabExcessHorizontalSpace = true;
        this.tagsField.setLayoutData((Object)data);
        verifier = new CompositeVerifier();
        verifier.add(new NonEmptyFieldVerifier(labelText));
        verifier.add(new ResourceNameVerifier(labelText, false));
        this.attachTo((Control)this.tagsField, verifier);
        this.tagsField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SVNTeamPreferencesPage.this.tags = SVNTeamPreferencesPage.this.tagsField.getText();
            }
        });
        this.showExternalsButton = new Button((Composite)group, 32);
        data = new GridData(768);
        data.horizontalSpan = 2;
        this.showExternalsButton.setLayoutData((Object)data);
        this.showExternalsButton.setText(SVNTeamUIPlugin.instance().getResource("MainPreferencePage.showExternals"));
        this.showExternalsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SVNTeamPreferencesPage.this.showExternals = ((Button)e.widget).getSelection();
            }
        });
        group = new Group(composite, 0);
        group.setLayout((Layout)new GridLayout());
        group.setLayoutData((Object)new GridData(768));
        group.setText(SVNTeamUIPlugin.instance().getResource("MainPreferencePage.checkoutGroupName"));
        label = new Label((Composite)group, 64);
        data = new GridData(768);
        data.widthHint = 450;
        label.setLayoutData((Object)data);
        label.setText(SVNTeamUIPlugin.instance().getResource("MainPreferencePage.checkoutPrompt"));
        this.checkoutUsingDotProjectNameButton = new Button((Composite)group, 32);
        data = new GridData();
        this.checkoutUsingDotProjectNameButton.setLayoutData((Object)data);
        this.checkoutUsingDotProjectNameButton.setText(SVNTeamUIPlugin.instance().getResource("MainPreferencePage.checkoutUsingDotProjectName"));
        this.checkoutUsingDotProjectNameButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SVNTeamPreferencesPage.this.checkoutUsingDotProjectName = SVNTeamPreferencesPage.this.checkoutUsingDotProjectNameButton.getSelection();
            }
        });
        this.checkoutRespectProjectStructureButton = new Button((Composite)group, 32);
        data = new GridData();
        this.checkoutRespectProjectStructureButton.setLayoutData((Object)data);
        this.checkoutRespectProjectStructureButton.setText(SVNTeamUIPlugin.instance().getResource("MainPreferencePage.checkoutRespectProjectStructure"));
        this.checkoutRespectProjectStructureButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SVNTeamPreferencesPage.this.checkoutRespectProjectStructure = SVNTeamPreferencesPage.this.checkoutRespectProjectStructureButton.getSelection();
            }
        });
        group = new Group(composite, 0);
        group.setLayout((Layout)new GridLayout());
        group.setLayoutData((Object)new GridData(768));
        group.setText(SVNTeamUIPlugin.instance().getResource("MainPreferencePage.branchTagGroupName"));
        label = new Label((Composite)group, 64);
        data = new GridData(768);
        data.widthHint = 450;
        label.setLayoutData((Object)data);
        label.setText(SVNTeamUIPlugin.instance().getResource("MainPreferencePage.branchTagPrompt"));
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SVNTeamPreferencesPage.this.branchTagConsiderStructure = SVNTeamPreferencesPage.this.branchTagConsiderStructureButton.getSelection();
            }
        };
        this.branchTagConsiderStructureButton = new Button((Composite)group, 16);
        this.branchTagConsiderStructureButton.setLayoutData((Object)new GridData());
        this.branchTagConsiderStructureButton.setText(SVNTeamUIPlugin.instance().getResource("MainPreferencePage.branchTagConsiderStructureLabel"));
        this.branchTagConsiderStructureButton.addSelectionListener((SelectionListener)listener);
        this.branchTagManualUrlEditButton = new Button((Composite)group, 16);
        this.branchTagManualUrlEditButton.setLayoutData((Object)new GridData());
        this.branchTagManualUrlEditButton.setText(SVNTeamUIPlugin.instance().getResource("MainPreferencePage.branchTagManualLabel"));
        this.branchTagManualUrlEditButton.addSelectionListener((SelectionListener)listener);
        label = new Label((Composite)group, 258);
        data = new GridData(768);
        label.setLayoutData((Object)data);
        this.forceExternalsFreezeButton = new Button((Composite)group, 32);
        data = new GridData(768);
        this.forceExternalsFreezeButton.setLayoutData((Object)data);
        this.forceExternalsFreezeButton.setText(SVNTeamUIPlugin.instance().getResource("MainPreferencePage.forceFreezeExternals"));
        this.forceExternalsFreezeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SVNTeamPreferencesPage.this.forceExternalsFreeze = ((Button)e.widget).getSelection();
            }
        });
        return composite;
    }

    protected Control createErrorReportingSettingsPage(Composite parent) {
        GridLayout layout = null;
        GridData data = null;
        Composite composite = new Composite(parent, 0);
        layout = new GridLayout();
        composite.setLayout((Layout)layout);
        data = new GridData(1808);
        composite.setLayoutData((Object)data);
        Label label = new Label(composite, 64);
        data = new GridData(768);
        data.widthHint = 450;
        label.setLayoutData((Object)data);
        label.setText(SVNTeamUIPlugin.instance().getResource("MainPreferencePage.mailReporterPrompt"));
        this.mailReporterEnabledButton = new Button(composite, 32);
        data = new GridData();
        this.mailReporterEnabledButton.setLayoutData((Object)data);
        this.mailReporterEnabledButton.setText(SVNTeamUIPlugin.instance().getResource("MainPreferencePage.mailReporterEnabledName"));
        this.mailReporterEnabledButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SVNTeamPreferencesPage.this.mailReporterEnabled = SVNTeamPreferencesPage.this.mailReporterEnabledButton.getSelection();
            }
        });
        this.mailReporterErrorsEnabledButton = new Button(composite, 32);
        data = new GridData();
        this.mailReporterErrorsEnabledButton.setLayoutData((Object)data);
        this.mailReporterErrorsEnabledButton.setText(SVNTeamUIPlugin.instance().getResource("MainPreferencePage.mailReporterErrorsEnabledName"));
        this.mailReporterErrorsEnabledButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SVNTeamPreferencesPage.this.mailReporterErrorsEnabled = SVNTeamPreferencesPage.this.mailReporterErrorsEnabledButton.getSelection();
            }
        });
        return composite;
    }
}

