/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.crashrecovery;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.svn.core.IConnectedProjectInformation;
import org.eclipse.team.svn.core.extension.crashrecovery.ErrorDescription;
import org.eclipse.team.svn.core.extension.crashrecovery.IResolutionHelper;
import org.eclipse.team.svn.core.operation.IActionOperation;
import org.eclipse.team.svn.core.resource.IRepositoryContainer;
import org.eclipse.team.svn.core.resource.IRepositoryLocation;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.core.svnstorage.SVNRemoteStorage;
import org.eclipse.team.svn.core.utility.ProgressMonitorUtility;
import org.eclipse.team.svn.ui.SVNTeamUIPlugin;
import org.eclipse.team.svn.ui.utility.UIMonitorUtility;
import org.eclipse.team.svn.ui.wizard.NewRepositoryLocationWizard;

public class InaccessibleLocationDataHelper
implements IResolutionHelper {
    public boolean acquireResolution(ErrorDescription description) {
        if (description.code == ErrorDescription.CANNOT_READ_LOCATION_DATA) {
            final Object[] context = (Object[])description.context;
            if (context[1] == null) {
                return false;
            }
            final IProject project = (IProject)context[0];
            final boolean[] solved = new boolean[1];
            final IActionOperation[] op = new IActionOperation[1];
            final IRepositoryLocation[] location = new IRepositoryLocation[1];
            UIMonitorUtility.parallelSyncExec(new Runnable(){

                public void run() {
                    MessageDialog dlg = new MessageDialog(UIMonitorUtility.getShell(), SVNTeamUIPlugin.instance().getResource("InaccessibleLocationDataHelper.Dialog.Title"), null, SVNTeamUIPlugin.instance().getResource("InaccessibleLocationDataHelper.Dialog.Message", new String[]{project.getName()}), 4, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 0);
                    boolean bl = solved[0] = dlg.open() == 0;
                    if (solved[0]) {
                        String locationId = (String)context[2];
                        location[0] = locationId == null ? SVNRemoteStorage.instance().newRepositoryLocation() : SVNRemoteStorage.instance().newRepositoryLocation(locationId);
                        location[0].setUrl((String)context[1]);
                        NewRepositoryLocationWizard wizard = new NewRepositoryLocationWizard(location[0], false);
                        WizardDialog dialog = new WizardDialog(UIMonitorUtility.getShell(), (IWizard)wizard);
                        boolean bl2 = solved[0] = dialog.open() == 0;
                        if (solved[0]) {
                            op[0] = wizard.getOperationToPerform();
                            solved[0] = op[0] != null;
                        }
                    }
                }
            });
            if (solved[0]) {
                ProgressMonitorUtility.doTaskExternal((IActionOperation)op[0], (IProgressMonitor)new NullProgressMonitor());
                if (op[0].getExecutionState() == 0) {
                    IRepositoryContainer container = location[0].asRepositoryContainer((String)context[1], true);
                    if (container == null) {
                        return false;
                    }
                    IConnectedProjectInformation provider = (IConnectedProjectInformation)RepositoryProvider.getProvider((IProject)project, (String)"org.eclipse.team.svn.core.svnnature");
                    try {
                        provider.switchResource((IRepositoryResource)container);
                    }
                    catch (CoreException coreException) {
                        return false;
                    }
                } else {
                    return false;
                }
            }
            return solved[0];
        }
        return false;
    }
}

