/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.annotate;

import java.util.ArrayList;
import java.util.Date;
import org.eclipse.jface.text.revisions.Revision;
import org.eclipse.jface.text.source.ILineRange;
import org.eclipse.jface.text.source.LineRange;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.team.svn.core.SVNTeamPlugin;
import org.eclipse.team.svn.core.connector.SVNLogEntry;
import org.eclipse.team.svn.ui.SVNTeamUIPlugin;
import org.eclipse.team.svn.ui.utility.DateFormatter;

public class BuiltInAnnotateRevision
extends Revision {
    public static final int END_LINE = -1;
    protected String id;
    protected String author;
    private int startLine;
    private int stopLine;
    protected RGB color;
    protected SVNLogEntry msg;
    protected ArrayList<MergeInfo> mergeInfoList;

    public BuiltInAnnotateRevision(String id, String author, RGB color) {
        this.id = id;
        this.color = color;
        this.author = author;
        this.stopLine = -1;
        this.startLine = -1;
    }

    public void setLogMessage(SVNLogEntry msg) {
        this.msg = msg;
    }

    public long getRevision() {
        return Long.parseLong(this.id);
    }

    public String getId() {
        return this.mergeInfoList != null ? String.valueOf(this.id) + "+" : this.id;
    }

    public void addLine(int line) {
        if (this.startLine == -1) {
            this.startLine = this.stopLine = line;
        } else if (line == -1) {
            this.addRange((ILineRange)new LineRange(this.startLine - 1, this.stopLine - this.startLine + 1));
        } else if (line - this.stopLine == 1) {
            this.stopLine = line;
        } else {
            this.addRange((ILineRange)new LineRange(this.startLine - 1, this.stopLine - this.startLine + 1));
            this.startLine = this.stopLine = line;
        }
    }

    public void addMergeInfo(int line, long mergedRevision, long mergedDate, String mergedAuthor, String mergedPath) {
        if (this.mergeInfoList == null) {
            this.mergeInfoList = new ArrayList();
        }
        String reference = mergedPath != null ? String.valueOf(mergedPath) + "@" + mergedRevision : String.valueOf(mergedRevision);
        this.mergeInfoList.add(new MergeInfo(String.valueOf(line), reference, mergedDate, mergedAuthor));
    }

    public RGB getColor() {
        return this.color;
    }

    public Object getHoverInfo() {
        String message;
        String info = "<b>" + SVNTeamUIPlugin.instance().getResource("BuiltInAnnotateRevision.Revision") + " </b>" + this.id + "<br>";
        if (this.author != null) {
            info = String.valueOf(info) + "<b>" + SVNTeamUIPlugin.instance().getResource("BuiltInAnnotateRevision.Author") + " </b>" + this.author;
        }
        if (this.getDateImpl() != null) {
            info = String.valueOf(info) + "<br><b>" + SVNTeamUIPlugin.instance().getResource("BuiltInAnnotateRevision.Date") + " </b>" + DateFormatter.formatDate(this.getDate());
        }
        String string = message = this.msg == null ? null : this.msg.message;
        if (message != null && message.length() > 0) {
            info = String.valueOf(info) + "<br><b>" + SVNTeamUIPlugin.instance().getResource("BuiltInAnnotateRevision.Message") + "</b><br>" + this.msg.message;
        }
        if (this.mergeInfoList != null) {
            info = String.valueOf(info) + "<br>";
            for (MergeInfo mergeInfo : this.mergeInfoList) {
                info = String.valueOf(info) + "<br>" + SVNTeamUIPlugin.instance().getResource("BuiltInAnnotateRevision.MergedWith", new String[]{mergeInfo.line, mergeInfo.reference, mergeInfo.author, DateFormatter.formatDate(new Date(mergeInfo.date))});
            }
        }
        return info;
    }

    public Date getDate() {
        Date date = this.getDateImpl();
        return date == null ? new Date(0L) : date;
    }

    protected Date getDateImpl() {
        return this.msg == null || this.msg.date == 0L ? null : new Date(this.msg.date);
    }

    public String getAuthor() {
        String author = this.author == null ? SVNTeamPlugin.instance().getResource("SVNInfo.NoAuthor") : this.author;
        return String.valueOf(author) + " ";
    }

    protected class MergeInfo {
        public final String line;
        public final String reference;
        public final long date;
        public final String author;

        public MergeInfo(String line, String reference, long date, String author) {
            this.line = line;
            this.reference = reference;
            this.date = date;
            this.author = author;
        }
    }
}

