/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.action.remote;

import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.team.svn.core.operation.CompositeOperation;
import org.eclipse.team.svn.core.operation.IActionOperation;
import org.eclipse.team.svn.core.operation.IRevisionProvider;
import org.eclipse.team.svn.core.operation.remote.CopyResourcesOperation;
import org.eclipse.team.svn.core.operation.remote.MoveResourcesOperation;
import org.eclipse.team.svn.core.operation.remote.SetRevisionAuthorNameOperation;
import org.eclipse.team.svn.core.resource.IRepositoryContainer;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.core.resource.IRepositoryResourceProvider;
import org.eclipse.team.svn.core.utility.SVNUtility;
import org.eclipse.team.svn.ui.RemoteResourceTransfer;
import org.eclipse.team.svn.ui.RemoteResourceTransferrable;
import org.eclipse.team.svn.ui.SVNTeamUIPlugin;
import org.eclipse.team.svn.ui.action.AbstractRepositoryTeamAction;
import org.eclipse.team.svn.ui.dialog.DefaultDialog;
import org.eclipse.team.svn.ui.operation.RefreshRemoteResourcesOperation;
import org.eclipse.team.svn.ui.panel.common.CommentPanel;

public class PasteAction
extends AbstractRepositoryTeamAction {
    public void runImpl(IAction action) {
        final RemoteResourceTransferrable transferrable = this.getTransferrable();
        CommentPanel commentPanel = new CommentPanel(SVNTeamUIPlugin.instance().getResource("PasteAction.Comment.Title"));
        DefaultDialog dialog = new DefaultDialog(this.getShell(), commentPanel);
        if (dialog.open() == 0) {
            this.clearClipboard(transferrable);
            final IRepositoryResource[] resources = this.getSelectedRepositoryResources();
            resources[0] = resources[0] instanceof IRepositoryContainer ? resources[0] : resources[0].getParent();
            CopyResourcesOperation pasteOp = transferrable.operation == 0 ? new CopyResourcesOperation(resources[0], transferrable.resources, commentPanel.getMessage(), null) : new MoveResourcesOperation(resources[0], transferrable.resources, commentPanel.getMessage(), null);
            CompositeOperation op = new CompositeOperation(pasteOp.getId());
            op.add((IActionOperation)pasteOp);
            op.add((IActionOperation)new RefreshRemoteResourcesOperation(new IRepositoryResourceProvider(){

                public IRepositoryResource[] getRepositoryResources() {
                    if (transferrable.operation == 0) {
                        return resources;
                    }
                    HashSet fullSet = new HashSet(Arrays.asList(resources));
                    fullSet.addAll(Arrays.asList(SVNUtility.getCommonParents((IRepositoryResource[])transferrable.resources)));
                    return fullSet.toArray(new IRepositoryResource[fullSet.size()]);
                }
            }));
            op.add((IActionOperation)new SetRevisionAuthorNameOperation((IRevisionProvider)pasteOp, 4L));
            this.runScheduled((IActionOperation)op);
        }
    }

    public boolean isEnabled() {
        IRepositoryResource[] selected = this.getSelectedRepositoryResources();
        if (selected.length != 1 || selected[0].getSelectedRevision().getKind() != 7) {
            return false;
        }
        RemoteResourceTransferrable transferrable = this.getTransferrable();
        if (transferrable == null) {
            return false;
        }
        IRepositoryResource target = selected[0] instanceof IRepositoryContainer ? selected[0] : selected[0].getParent();
        int i = 0;
        while (i < transferrable.resources.length) {
            if (this.isSource(target, transferrable.resources[i])) {
                return false;
            }
            ++i;
        }
        return selected[0].getRepositoryLocation() == transferrable.resources[0].getRepositoryLocation();
    }

    protected boolean isSource(IRepositoryResource selectedResource, IRepositoryResource resource) {
        Path selectedUrl = new Path(selectedResource.getUrl());
        return new Path(resource.getUrl()).isPrefixOf((IPath)selectedUrl) || resource.getParent() != null && new Path(resource.getParent().getUrl()).equals((Object)selectedUrl);
    }

    protected RemoteResourceTransferrable getTransferrable() {
        Clipboard clipboard = new Clipboard(this.getShell().getDisplay());
        try {
            RemoteResourceTransferrable transferrable = (RemoteResourceTransferrable)clipboard.getContents((Transfer)new RemoteResourceTransfer());
            if (transferrable == null || transferrable.operation == 255 || transferrable.resources == null || transferrable.resources.length == 0) {
                return null;
            }
            RemoteResourceTransferrable remoteResourceTransferrable = transferrable;
            return remoteResourceTransferrable;
        }
        finally {
            clipboard.dispose();
        }
    }

    protected void clearClipboard(RemoteResourceTransferrable transferrable) {
        if (transferrable.operation == 1) {
            Clipboard clipboard = new Clipboard(this.getShell().getDisplay());
            try {
                clipboard.setContents(new Object[]{new RemoteResourceTransferrable(null, 255)}, new Transfer[]{new RemoteResourceTransfer()});
            }
            finally {
                clipboard.dispose();
            }
        }
    }
}

