/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.action.remote;

import org.eclipse.jface.action.IAction;
import org.eclipse.team.svn.core.connector.SVNConnectorException;
import org.eclipse.team.svn.core.extension.CoreExtensionsManager;
import org.eclipse.team.svn.core.operation.IActionOperation;
import org.eclipse.team.svn.core.resource.IRepositoryFile;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.ui.action.AbstractRepositoryTeamAction;
import org.eclipse.team.svn.ui.operation.CompareRepositoryResourcesOperation;
import org.eclipse.team.svn.ui.operation.UILoggedOperation;

public class CompareSelectedAction
extends AbstractRepositoryTeamAction {
    public void runImpl(IAction action) {
        IRepositoryResource[] resources = this.getSelectedRepositoryResources();
        try {
            if (resources[1].getRevision() > resources[0].getRevision()) {
                IRepositoryResource tmp = resources[1];
                resources[1] = resources[0];
                resources[0] = tmp;
            }
        }
        catch (SVNConnectorException ex) {
            UILoggedOperation.reportError("Compare", ex);
        }
        this.runScheduled((IActionOperation)new CompareRepositoryResourcesOperation(resources[1], resources[0]));
    }

    public boolean isEnabled() {
        boolean isCompareFoldersAllowed;
        IRepositoryResource[] resources = this.getSelectedRepositoryResources();
        if (resources.length != 2) {
            return false;
        }
        boolean bl = isCompareFoldersAllowed = CoreExtensionsManager.instance().getSVNConnectorFactory().getSVNAPIVersion() == 5;
        return (isCompareFoldersAllowed || resources[0] instanceof IRepositoryFile) && !(resources[0] instanceof IRepositoryFile ^ resources[1] instanceof IRepositoryFile);
    }
}

