/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.connector.svnkit;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.team.svn.core.connector.ISVNAnnotationCallback;
import org.eclipse.team.svn.core.connector.ISVNChangeListCallback;
import org.eclipse.team.svn.core.connector.ISVNConflictResolutionCallback;
import org.eclipse.team.svn.core.connector.ISVNConnector;
import org.eclipse.team.svn.core.connector.ISVNCredentialsPrompt;
import org.eclipse.team.svn.core.connector.ISVNDiffStatusCallback;
import org.eclipse.team.svn.core.connector.ISVNEntryCallback;
import org.eclipse.team.svn.core.connector.ISVNEntryInfoCallback;
import org.eclipse.team.svn.core.connector.ISVNEntryStatusCallback;
import org.eclipse.team.svn.core.connector.ISVNLogEntryCallback;
import org.eclipse.team.svn.core.connector.ISVNMergeStatusCallback;
import org.eclipse.team.svn.core.connector.ISVNNotificationCallback;
import org.eclipse.team.svn.core.connector.ISVNProgressMonitor;
import org.eclipse.team.svn.core.connector.ISVNPropertyCallback;
import org.eclipse.team.svn.core.connector.SVNConnectorAuthenticationException;
import org.eclipse.team.svn.core.connector.SVNConnectorCancelException;
import org.eclipse.team.svn.core.connector.SVNConnectorException;
import org.eclipse.team.svn.core.connector.SVNConnectorUnresolvedConflictException;
import org.eclipse.team.svn.core.connector.SVNDiffStatus;
import org.eclipse.team.svn.core.connector.SVNEntry;
import org.eclipse.team.svn.core.connector.SVNEntryInfo;
import org.eclipse.team.svn.core.connector.SVNEntryReference;
import org.eclipse.team.svn.core.connector.SVNEntryRevisionReference;
import org.eclipse.team.svn.core.connector.SVNLogEntry;
import org.eclipse.team.svn.core.connector.SVNLogPath;
import org.eclipse.team.svn.core.connector.SVNMergeInfo;
import org.eclipse.team.svn.core.connector.SVNMergeStatus;
import org.eclipse.team.svn.core.connector.SVNNotification;
import org.eclipse.team.svn.core.connector.SVNProperty;
import org.eclipse.team.svn.core.connector.SVNRevision;
import org.eclipse.team.svn.core.connector.SVNRevisionRange;
import org.eclipse.team.svn.core.utility.Notify2Composite;
import org.eclipse.team.svn.core.utility.SVNUtility;
import org.tigris.subversion.javahl.ChangelistCallback;
import org.tigris.subversion.javahl.ClientException;
import org.tigris.subversion.javahl.ConversionUtility;
import org.tigris.subversion.javahl.CopySource;
import org.tigris.subversion.javahl.DiffSummary;
import org.tigris.subversion.javahl.DiffSummaryReceiver;
import org.tigris.subversion.javahl.DirEntry;
import org.tigris.subversion.javahl.ListCallback;
import org.tigris.subversion.javahl.Lock;
import org.tigris.subversion.javahl.PromptUserPassword;
import org.tigris.subversion.javahl.SubversionException;
import org.tmatesoft.svn.core.client.SVNClientEx;
import org.tmatesoft.svn.core.javahl.PromptUserPasswordProxy;
import org.tmatesoft.svn.core.javahl.PromptUserPasswordSSH;
import org.tmatesoft.svn.core.javahl.PromptUserPasswordSSL;

public class SVNKitConnector
implements ISVNConnector {
    protected static ProgressMonitorThread monitorWrapperThread;
    protected SVNClientEx client = new SVNClientEx();
    protected ISVNCredentialsPrompt prompt;
    protected Notify2Composite composite = new Notify2Composite();
    protected ISVNNotificationCallback installedNotify2;

    public SVNKitConnector() {
        this.client.notification2(ConversionUtility.convert((ISVNNotificationCallback)this.composite));
    }

    public String getConfigDirectory() throws SVNConnectorException {
        try {
            return this.client.getConfigDirectory();
        }
        catch (ClientException ex) {
            this.handleClientException(ex);
            return null;
        }
    }

    public void setConfigDirectory(String configDir) throws SVNConnectorException {
        try {
            this.client.setConfigDirectory(configDir);
        }
        catch (ClientException ex) {
            this.handleClientException(ex);
        }
    }

    public void setUsername(String username) {
        this.client.username(username);
    }

    public void setPassword(String password) {
        this.client.password(password);
    }

    public boolean isCredentialsCacheEnabled() {
        return this.client.isCredentialsCacheEnabled();
    }

    public void setCredentialsCacheEnabled(boolean cacheCredentials) {
        this.client.setCredentialsCacheEnabled(cacheCredentials);
    }

    public void setPrompt(ISVNCredentialsPrompt prompt) {
        RepositoryInfoPrompt repositoryInfoPrompt;
        if (prompt == null) {
            repositoryInfoPrompt = null;
        } else {
            this.prompt = prompt;
            RepositoryInfoPrompt repositoryInfoPrompt2 = new RepositoryInfoPrompt(this.prompt);
            repositoryInfoPrompt = repositoryInfoPrompt2;
        }
        this.client.setPrompt((PromptUserPassword)repositoryInfoPrompt);
    }

    public ISVNCredentialsPrompt getPrompt() {
        return this.prompt;
    }

    public void setProxy(String host, int port, String userName, String password) {
        this.client.setProxy(host, port, userName, password);
    }

    public void setClientSSLCertificate(String certPath, String passphrase) {
        this.client.setClientSSLCertificate(certPath, passphrase);
    }

    public void setSSLCertificateCacheEnabled(boolean enabled) {
        this.client.setSSLCertificateCacheEnabled(enabled);
    }

    public boolean isSSLCertificateCacheEnabled() {
        return this.client.isSSLCertificateCacheEnabled();
    }

    public void setSSHCredentials(String userName, String privateKeyPath, String passphrase, int port) {
        this.client.setSSHCredentials(userName, privateKeyPath, passphrase, port);
    }

    public void setSSHCredentials(String userName, String password, int port) {
        this.client.setSSHCredentials(userName, password, port);
    }

    public void setCommitMissingFiles(boolean commitMissingFiles) {
        this.client.setCommitMissedFiles(commitMissingFiles);
    }

    public boolean isCommitMissingFiles() {
        return this.client.isCommitMissingFile();
    }

    public void setTouchUnresolved(boolean touchUnresolved) {
        this.client.setTouchUnresolved(touchUnresolved);
    }

    public boolean isTouchUnresolved() {
        return this.client.isTouchUnresolved();
    }

    public void setNotificationCallback(ISVNNotificationCallback notify) {
        if (this.installedNotify2 != null) {
            this.composite.remove(this.installedNotify2);
        }
        this.installedNotify2 = notify;
        if (this.installedNotify2 != null) {
            this.composite.add(this.installedNotify2);
        }
    }

    public ISVNNotificationCallback getNotificationCallback() {
        return this.installedNotify2;
    }

    public long checkout(SVNEntryRevisionReference fromReference, String destPath, int depth, long options, ISVNProgressMonitor monitor) throws SVNConnectorException {
        ProgressMonitorWrapper wrapper = new ProgressMonitorWrapper(monitor);
        try {
            this.composite.add((ISVNNotificationCallback)wrapper);
            wrapper.start();
            long l = this.client.checkout(fromReference.path, destPath, ConversionUtility.convert(fromReference.revision), ConversionUtility.convert(fromReference.pegRevision), depth, (options & 1L) != 0L, (options & 2L) != 0L);
            return l;
        }
        catch (ClientException ex) {
            this.handleClientException(ex);
        }
        finally {
            wrapper.interrupt();
            this.composite.remove((ISVNNotificationCallback)wrapper);
        }
        return 0L;
    }

    public void lock(String[] path, String comment, long options, ISVNProgressMonitor monitor) throws SVNConnectorException {
        ProgressMonitorWrapper wrapper = new ProgressMonitorWrapper(monitor);
        try {
            try {
                this.composite.add((ISVNNotificationCallback)wrapper);
                wrapper.start();
                this.client.lock(path, comment, (options & 4L) != 0L);
            }
            catch (ClientException ex) {
                this.handleClientException(ex);
                wrapper.interrupt();
                this.composite.remove((ISVNNotificationCallback)wrapper);
            }
        }
        finally {
            wrapper.interrupt();
            this.composite.remove((ISVNNotificationCallback)wrapper);
        }
    }

    public void unlock(String[] path, long options, ISVNProgressMonitor monitor) throws SVNConnectorException {
        ProgressMonitorWrapper wrapper = new ProgressMonitorWrapper(monitor);
        try {
            try {
                this.composite.add((ISVNNotificationCallback)wrapper);
                wrapper.start();
                this.client.unlock(path, (options & 4L) != 0L);
            }
            catch (ClientException ex) {
                this.handleClientException(ex);
                wrapper.interrupt();
                this.composite.remove((ISVNNotificationCallback)wrapper);
            }
        }
        finally {
            wrapper.interrupt();
            this.composite.remove((ISVNNotificationCallback)wrapper);
        }
    }

    public void add(String path, int depth, long options, ISVNProgressMonitor monitor) throws SVNConnectorException {
        ProgressMonitorWrapper wrapper = new ProgressMonitorWrapper(monitor);
        try {
            try {
                this.composite.add((ISVNNotificationCallback)wrapper);
                wrapper.start();
                this.client.add(path, depth, (options & 4L) != 0L, (options & 0x100L) != 0L, (options & 8L) != 0L);
            }
            catch (ClientException ex) {
                this.handleClientException(ex);
                wrapper.interrupt();
                this.composite.remove((ISVNNotificationCallback)wrapper);
            }
        }
        finally {
            wrapper.interrupt();
            this.composite.remove((ISVNNotificationCallback)wrapper);
        }
    }

    public long[] commit(String[] path, String message, String[] changelistNames, int depth, long options, Map revProps, ISVNProgressMonitor monitor) throws SVNConnectorException {
        ProgressMonitorWrapper wrapper = new ProgressMonitorWrapper(monitor);
        try {
            this.composite.add((ISVNNotificationCallback)wrapper);
            wrapper.start();
            long[] lArray = this.client.commit(path, message, depth, (options & 0x10L) != 0L, (options & 0x20L) != 0L, changelistNames, ConversionUtility.convert(revProps), true);
            return lArray;
        }
        catch (ClientException ex) {
            this.handleClientException(ex);
        }
        finally {
            wrapper.interrupt();
            this.composite.remove((ISVNNotificationCallback)wrapper);
        }
        return null;
    }

    public long[] update(String[] path, SVNRevision revision, int depth, long options, ISVNProgressMonitor monitor) throws SVNConnectorException {
        ProgressMonitorWrapper wrapper = new ProgressMonitorWrapper(monitor);
        try {
            this.composite.add((ISVNNotificationCallback)wrapper);
            wrapper.start();
            long[] lArray = this.client.update(path, ConversionUtility.convert(revision), depth, (options & 0x4000L) != 0L, (options & 1L) != 0L, (options & 2L) != 0L);
            return lArray;
        }
        catch (ClientException ex) {
            this.handleClientException(ex);
        }
        finally {
            wrapper.interrupt();
            this.composite.remove((ISVNNotificationCallback)wrapper);
        }
        return null;
    }

    public long doSwitch(String path, SVNEntryRevisionReference toReference, int depth, long options, ISVNProgressMonitor monitor) throws SVNConnectorException {
        ProgressMonitorWrapper wrapper = new ProgressMonitorWrapper(monitor);
        try {
            this.composite.add((ISVNNotificationCallback)wrapper);
            wrapper.start();
            long l = this.client.doSwitch(path, toReference.path, ConversionUtility.convert(toReference.revision), ConversionUtility.convert(toReference.pegRevision), depth, (options & 0x4000L) != 0L, (options & 1L) != 0L, (options & 2L) != 0L);
            return l;
        }
        catch (ClientException ex) {
            this.handleClientException(ex);
        }
        finally {
            wrapper.interrupt();
            this.composite.remove((ISVNNotificationCallback)wrapper);
        }
        return 0L;
    }

    public void revert(String path, int depth, String[] changelistNames, ISVNProgressMonitor monitor) throws SVNConnectorException {
        ProgressMonitorWrapper wrapper = new ProgressMonitorWrapper(monitor);
        try {
            try {
                this.composite.add((ISVNNotificationCallback)wrapper);
                wrapper.start();
                this.client.revert(path, depth, changelistNames);
            }
            catch (ClientException ex) {
                this.handleClientException(ex);
                wrapper.interrupt();
                this.composite.remove((ISVNNotificationCallback)wrapper);
            }
        }
        finally {
            wrapper.interrupt();
            this.composite.remove((ISVNNotificationCallback)wrapper);
        }
    }

    public void status(String path, int depth, long options, String[] changelistNames, ISVNEntryStatusCallback callback, ISVNProgressMonitor monitor) throws SVNConnectorException {
        ProgressMonitorWrapper wrapper = new ProgressMonitorWrapper(monitor);
        try {
            try {
                this.composite.add((ISVNNotificationCallback)wrapper);
                wrapper.start();
                this.client.status(path, depth, (options & 0x40L) != 0L, (options & 0x80L) != 0L, (options & 0x100L) != 0L, (options & 1L) != 0L, changelistNames, ConversionUtility.convert(callback));
            }
            catch (ClientException ex) {
                this.handleClientException(ex);
                wrapper.interrupt();
                this.composite.remove((ISVNNotificationCallback)wrapper);
            }
        }
        finally {
            wrapper.interrupt();
            this.composite.remove((ISVNNotificationCallback)wrapper);
        }
    }

    public void relocate(String from, String to, String path, int depth, ISVNProgressMonitor monitor) throws SVNConnectorException {
        ProgressMonitorWrapper wrapper = new ProgressMonitorWrapper(monitor);
        try {
            try {
                this.composite.add((ISVNNotificationCallback)wrapper);
                wrapper.start();
                this.client.relocate(from, to, path, depth == 3);
            }
            catch (ClientException ex) {
                this.handleClientException(ex);
                wrapper.interrupt();
                this.composite.remove((ISVNNotificationCallback)wrapper);
            }
        }
        finally {
            wrapper.interrupt();
            this.composite.remove((ISVNNotificationCallback)wrapper);
        }
    }

    public void cleanup(String path, ISVNProgressMonitor monitor) throws SVNConnectorException {
        ProgressMonitorWrapper wrapper = new ProgressMonitorWrapper(monitor);
        try {
            try {
                this.composite.add((ISVNNotificationCallback)wrapper);
                wrapper.start();
                this.client.cleanup(path);
            }
            catch (ClientException ex) {
                this.handleClientException(ex);
                wrapper.interrupt();
                this.composite.remove((ISVNNotificationCallback)wrapper);
            }
        }
        finally {
            wrapper.interrupt();
            this.composite.remove((ISVNNotificationCallback)wrapper);
        }
    }

    public void merge(SVNEntryRevisionReference reference1, SVNEntryRevisionReference reference2, String localPath, int depth, long options, ISVNProgressMonitor monitor) throws SVNConnectorException {
        ProgressMonitorWrapper wrapper = new ProgressMonitorWrapper(monitor);
        try {
            try {
                this.composite.add((ISVNNotificationCallback)wrapper);
                wrapper.start();
                this.client.merge(reference1.path, ConversionUtility.convert(reference1.revision), reference2.path, ConversionUtility.convert(reference2.revision), localPath, (options & 4L) != 0L, depth, (options & 0x200L) != 0L, (options & 0x400L) != 0L, (options & 0x800L) != 0L);
            }
            catch (ClientException ex) {
                this.handleClientException(ex);
                wrapper.interrupt();
                this.composite.remove((ISVNNotificationCallback)wrapper);
            }
        }
        finally {
            wrapper.interrupt();
            this.composite.remove((ISVNNotificationCallback)wrapper);
        }
    }

    public void merge(SVNEntryReference reference, SVNRevisionRange[] revisions, String localPath, int depth, long options, ISVNProgressMonitor monitor) throws SVNConnectorException {
        ProgressMonitorWrapper wrapper = new ProgressMonitorWrapper(monitor);
        try {
            try {
                this.composite.add((ISVNNotificationCallback)wrapper);
                wrapper.start();
                this.client.merge(reference.path, ConversionUtility.convert(reference.pegRevision), ConversionUtility.convert(revisions), localPath, (options & 4L) != 0L, depth, (options & 0x200L) != 0L, (options & 0x400L) != 0L, (options & 0x800L) != 0L);
            }
            catch (ClientException ex) {
                this.handleClientException(ex);
                wrapper.interrupt();
                this.composite.remove((ISVNNotificationCallback)wrapper);
            }
        }
        finally {
            wrapper.interrupt();
            this.composite.remove((ISVNNotificationCallback)wrapper);
        }
    }

    public void mergeReintegrate(SVNEntryReference reference, String localPath, long options, ISVNProgressMonitor monitor) throws SVNConnectorException {
        ProgressMonitorWrapper wrapper = new ProgressMonitorWrapper(monitor);
        try {
            try {
                this.composite.add((ISVNNotificationCallback)wrapper);
                wrapper.start();
                this.client.mergeReintegrate(reference.path, ConversionUtility.convert(reference.pegRevision), localPath, (options & 0x400L) != 0L);
            }
            catch (ClientException ex) {
                this.handleClientException(ex);
                wrapper.interrupt();
                this.composite.remove((ISVNNotificationCallback)wrapper);
            }
        }
        finally {
            wrapper.interrupt();
            this.composite.remove((ISVNNotificationCallback)wrapper);
        }
    }

    public SVNMergeInfo getMergeInfo(SVNEntryReference reference, ISVNProgressMonitor monitor) throws SVNConnectorException {
        ProgressMonitorWrapper wrapper = new ProgressMonitorWrapper(monitor);
        try {
            this.composite.add((ISVNNotificationCallback)wrapper);
            wrapper.start();
            SVNMergeInfo sVNMergeInfo = ConversionUtility.convert(this.client.getMergeinfo(reference.path, ConversionUtility.convert(reference.pegRevision)));
            return sVNMergeInfo;
        }
        catch (ClientException ex) {
            this.handleClientException(ex);
        }
        catch (SubversionException ex) {
            this.handleSubversionException(ex);
        }
        finally {
            wrapper.interrupt();
            this.composite.remove((ISVNNotificationCallback)wrapper);
        }
        return null;
    }

    public void getMergeInfoLog(int logKind, SVNEntryReference reference, SVNEntryReference mergeSourceReference, String[] revProps, long options, ISVNLogEntryCallback cb, ISVNProgressMonitor monitor) throws SVNConnectorException {
        ProgressMonitorWrapper wrapper = new ProgressMonitorWrapper(monitor);
        try {
            try {
                this.composite.add((ISVNNotificationCallback)wrapper);
                wrapper.start();
                this.client.getMergeinfoLog(logKind, reference.path, ConversionUtility.convert(reference.pegRevision), mergeSourceReference.path, ConversionUtility.convert(mergeSourceReference.pegRevision), (options & 0x40000L) != 0L, revProps, ConversionUtility.convert(cb));
            }
            catch (ClientException ex) {
                this.handleClientException(ex);
                wrapper.interrupt();
                this.composite.remove((ISVNNotificationCallback)wrapper);
            }
        }
        finally {
            wrapper.interrupt();
            this.composite.remove((ISVNNotificationCallback)wrapper);
        }
    }

    public String[] suggestMergeSources(SVNEntryReference reference, ISVNProgressMonitor monitor) throws SVNConnectorException {
        ProgressMonitorWrapper wrapper = new ProgressMonitorWrapper(monitor);
        try {
            this.composite.add((ISVNNotificationCallback)wrapper);
            wrapper.start();
            String[] stringArray = this.client.suggestMergeSources(reference.path, ConversionUtility.convert(reference.pegRevision));
            return stringArray;
        }
        catch (ClientException ex) {
            this.handleClientException(ex);
        }
        catch (SubversionException ex) {
            this.handleSubversionException(ex);
        }
        finally {
            wrapper.interrupt();
            this.composite.remove((ISVNNotificationCallback)wrapper);
        }
        return null;
    }

    public void resolve(String path, int conflictResult, int depth, ISVNProgressMonitor monitor) throws SVNConnectorException {
        ProgressMonitorWrapper wrapper = new ProgressMonitorWrapper(monitor);
        try {
            try {
                this.composite.add((ISVNNotificationCallback)wrapper);
                wrapper.start();
                this.client.resolve(path, depth, conflictResult);
            }
            catch (ClientException ex) {
                this.handleClientException(ex);
                wrapper.interrupt();
                this.composite.remove((ISVNNotificationCallback)wrapper);
            }
        }
        finally {
            wrapper.interrupt();
            this.composite.remove((ISVNNotificationCallback)wrapper);
        }
    }

    public void setConflictResolver(ISVNConflictResolutionCallback listener) {
        this.client.setConflictResolver(ConversionUtility.convert(listener));
    }

    public void addToChangeList(String[] paths, String changelist, int depth, String[] changelistNames, ISVNProgressMonitor monitor) throws SVNConnectorException {
        ProgressMonitorWrapper wrapper = new ProgressMonitorWrapper(monitor);
        try {
            try {
                this.composite.add((ISVNNotificationCallback)wrapper);
                wrapper.start();
                this.client.addToChangelist(paths, changelist, depth, changelistNames);
            }
            catch (ClientException ex) {
                this.handleClientException(ex);
                wrapper.interrupt();
                this.composite.remove((ISVNNotificationCallback)wrapper);
            }
        }
        finally {
            wrapper.interrupt();
            this.composite.remove((ISVNNotificationCallback)wrapper);
        }
    }

    public void removeFromChangeLists(String[] paths, int depth, String[] changelistNames, ISVNProgressMonitor monitor) throws SVNConnectorException {
        ProgressMonitorWrapper wrapper = new ProgressMonitorWrapper(monitor);
        try {
            try {
                this.composite.add((ISVNNotificationCallback)wrapper);
                wrapper.start();
                this.client.removeFromChangelists(paths, depth, changelistNames);
            }
            catch (ClientException ex) {
                this.handleClientException(ex);
                wrapper.interrupt();
                this.composite.remove((ISVNNotificationCallback)wrapper);
            }
        }
        finally {
            wrapper.interrupt();
            this.composite.remove((ISVNNotificationCallback)wrapper);
        }
    }

    public void dumpChangeLists(String[] changeLists, String rootPath, int depth, final ISVNChangeListCallback cb, ISVNProgressMonitor monitor) throws SVNConnectorException {
        ProgressMonitorWrapper wrapper = new ProgressMonitorWrapper(monitor);
        try {
            try {
                this.composite.add((ISVNNotificationCallback)wrapper);
                wrapper.start();
                this.client.getChangelists(rootPath, changeLists, depth, new ChangelistCallback(){

                    public void doChangelist(String path, String changelist) {
                        cb.next(path, changelist);
                    }
                });
            }
            catch (ClientException ex) {
                this.handleClientException(ex);
                wrapper.interrupt();
                this.composite.remove((ISVNNotificationCallback)wrapper);
            }
        }
        finally {
            wrapper.interrupt();
            this.composite.remove((ISVNNotificationCallback)wrapper);
        }
    }

    public void merge(SVNEntryReference reference, SVNRevisionRange[] revisions, String mergePath, SVNMergeStatus[] mergeStatus, long options, ISVNProgressMonitor monitor) throws SVNConnectorException {
        this.merge(reference, null, revisions, mergePath, mergeStatus, options, monitor);
    }

    public void merge(SVNEntryRevisionReference reference1, SVNEntryRevisionReference reference2, String mergePath, SVNMergeStatus[] mergeStatus, long options, ISVNProgressMonitor monitor) throws SVNConnectorException {
        this.merge((SVNEntryReference)reference1, reference2, null, mergePath, mergeStatus, options, monitor);
    }

    public void mergeStatus(SVNEntryReference reference, SVNRevisionRange[] revisions, String path, int depth, long options, ISVNMergeStatusCallback cb, ISVNProgressMonitor monitor) throws SVNConnectorException {
        this.mergeStatus(reference, null, revisions, path, depth, options, cb, monitor);
    }

    public void mergeStatus(SVNEntryRevisionReference reference1, SVNEntryRevisionReference reference2, String path, int depth, long options, ISVNMergeStatusCallback cb, ISVNProgressMonitor monitor) throws SVNConnectorException {
        this.mergeStatus((SVNEntryReference)reference1, reference2, null, path, depth, options, cb, monitor);
    }

    public void merge(SVNEntryReference reference, String mergePath, SVNMergeStatus[] mergeStatus, long options, ISVNProgressMonitor monitor) throws SVNConnectorException {
        this.merge(reference, null, null, mergePath, mergeStatus, options, monitor);
    }

    public void mergeStatus(SVNEntryReference reference, String mergePath, long options, ISVNMergeStatusCallback cb, ISVNProgressMonitor monitor) throws SVNConnectorException {
        this.mergeStatus(reference, null, null, mergePath, 3, options, cb, monitor);
    }

    /*
     * Unable to fully structure code
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void merge(SVNEntryReference reference1, SVNEntryRevisionReference reference2, SVNRevisionRange[] revisions, String mergePath, SVNMergeStatus[] mergeStatus, long options, ISVNProgressMonitor monitor) throws SVNConnectorException {
        wrapper = new ProgressMonitorWrapper(monitor);
        try {
            try {
                this.composite.add((ISVNNotificationCallback)wrapper);
                wrapper.start();
                i = 0;
                if (true) ** GOTO lbl61
                do {
                    localFile = new File(mergeStatus[i].path);
                    if (mergeStatus[i].textStatus == 4) {
                        this.client.remove(new String[]{mergeStatus[i].path}, null, (options & 4L) != 0L, false, null);
                    } else if (mergeStatus[i].textStatus == 3 || mergeStatus[i].textStatus == 2 && ((options & 4L) != 0L || !localFile.exists()) || mergeStatus[i].textStatus == 9 && (options & 4L) != 0L) {
                        if (localFile.exists()) {
                            localFile.delete();
                        }
                        parent = localFile.getParentFile();
                        while (!parent.exists() && parent.getParentFile() != null) {
                            tmp = parent.getParentFile();
                            if (tmp.exists()) {
                                localFile.getParentFile().mkdirs();
                                this.client.add(parent.getAbsolutePath(), 3, true, false, false);
                                break;
                            }
                            parent = tmp;
                        }
                        src = new CopySource(mergeStatus[i].endUrl, ConversionUtility.convert(reference2 == null ? (revisions != null ? revisions[revisions.length - 1].to : reference1.pegRevision) : reference2.revision), ConversionUtility.convert(reference2 == null ? reference1.pegRevision : reference2.pegRevision));
                        tmp = File.createTempFile("mergeCopyTarget", ".tmp", localFile.getParentFile());
                        tmp.delete();
                        this.client.copy(new CopySource[]{src}, tmp.getAbsolutePath(), null, true, false, null);
                        data = this.client.properties(tmp.getAbsolutePath());
                        this.client.revert(tmp.getAbsolutePath(), 3, null);
                        tmp.renameTo(new File(mergeStatus[i].path));
                        try {
                            this.client.add(mergeStatus[i].path, 3, true, false, false);
                        }
                        catch (ClientException v0) {}
                        if (data != null) {
                            var18_19 = data;
                            var17_18 = data.length;
                            var16_17 = 0;
                            while (var16_17 < var17_18) {
                                d = var18_19[var16_17];
                                if (d.getValue() != null) {
                                    this.client.propertySet(mergeStatus[i].path, d.getName(), d.getValue(), false);
                                } else {
                                    this.client.propertySet(mergeStatus[i].path, d.getName(), d.getData(), false);
                                }
                                ++var16_17;
                            }
                        }
                    } else if (reference2 != null) {
                        this.client.merge(mergeStatus[i].startUrl, ConversionUtility.convert(((SVNEntryRevisionReference)reference1).revision), mergeStatus[i].endUrl, ConversionUtility.convert(reference2.revision), mergeStatus[i].path, (options & 4L) != 0L, 1, (options & 512L) != 0L, false, (options & 2048L) != 0L);
                    } else if (revisions != null) {
                        this.client.merge(mergeStatus[i].endUrl, ConversionUtility.convert(reference1.pegRevision), ConversionUtility.convert(revisions), mergeStatus[i].path, (options & 4L) != 0L, 1, (options & 512L) != 0L, false, (options & 2048L) != 0L);
                    } else {
                        this.client.mergeReintegrate(mergeStatus[i].endUrl, ConversionUtility.convert(reference1.pegRevision), mergeStatus[i].path, false);
                    }
                    ++i;
lbl61:
                    // 2 sources

                    if (i >= mergeStatus.length) return;
                } while (!monitor.isActivityCancelled());
                return;
            }
            catch (ClientException ex) {
                this.handleClientException(ex);
                wrapper.interrupt();
                this.composite.remove((ISVNNotificationCallback)wrapper);
                return;
            }
            catch (IOException e) {
                throw new SVNConnectorException((Throwable)e);
            }
        }
        finally {
            wrapper.interrupt();
            this.composite.remove((ISVNNotificationCallback)wrapper);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void mergeStatus(SVNEntryReference reference1, SVNEntryRevisionReference reference2, SVNRevisionRange[] revisions, String path, int depth, long options, ISVNMergeStatusCallback cb, ISVNProgressMonitor monitor) throws SVNConnectorException {
        final ArrayList tmp = new ArrayList();
        ProgressMonitorWrapper wrapper = new ProgressMonitorWrapper(monitor){

            public void notify(SVNNotification arg0) {
                super.notify(arg0);
                tmp.add(arg0);
            }
        };
        try {
            try {
                String endUrlPref;
                SVNLogEntry[] entries;
                SVNRevision to;
                SVNRevision from;
                this.composite.add((ISVNNotificationCallback)wrapper);
                wrapper.start();
                if (reference2 != null) {
                    this.client.merge(reference1.path, ConversionUtility.convert(((SVNEntryRevisionReference)reference1).revision), reference2.path, ConversionUtility.convert(reference2.revision), path, (options & 4L) != 0L, depth, (options & 0x200L) != 0L, (options & 0x400L) != 0L, (options & 0x800L) != 0L);
                } else if (revisions != null) {
                    this.client.merge(reference1.path, ConversionUtility.convert(reference1.pegRevision), ConversionUtility.convert(revisions), path, (options & 4L) != 0L, depth, (options & 0x200L) != 0L, (options & 0x400L) != 0L, (options & 0x800L) != 0L);
                } else {
                    this.client.mergeReintegrate(reference1.path, ConversionUtility.convert(reference1.pegRevision), path, (options & 0x400L) != 0L);
                }
                Object object = reference2 == null ? (revisions != null ? revisions[0].from : SVNRevision.fromNumber((long)1L)) : (from = ((SVNEntryRevisionReference)reference1).revision);
                SVNRevision sVNRevision = reference2 == null ? (revisions != null ? revisions[revisions.length - 1].to : reference1.pegRevision) : (to = reference2.revision);
                if (from.getKind() != 1) {
                    entries = SVNUtility.logEntries((ISVNConnector)this, (SVNEntryReference)reference1, (SVNRevision)from, (SVNRevision)SVNRevision.fromNumber((long)1L), (long)0L, (String[])ISVNConnector.EMPTY_LOG_ENTRY_PROPS, (long)1L, (ISVNProgressMonitor)monitor);
                    from = SVNRevision.fromNumber((long)entries[0].revision);
                }
                if (to.getKind() != 1) {
                    entries = SVNUtility.logEntries((ISVNConnector)this, (SVNEntryReference)(reference2 == null ? reference1 : reference2), (SVNRevision)to, (SVNRevision)SVNRevision.fromNumber((long)1L), (long)0L, (String[])ISVNConnector.EMPTY_LOG_ENTRY_PROPS, (long)1L, (ISVNProgressMonitor)monitor);
                    to = SVNRevision.fromNumber((long)entries[0].revision);
                }
                if (reference2 != null && from.equals((Object)to)) {
                    from = SVNRevision.fromNumber((long)(((SVNRevision.Number)to).getNumber() - 1L));
                }
                boolean reversed = reference2 == null ? SVNUtility.compareRevisions((SVNRevision)from, (SVNRevision)to, (SVNEntryRevisionReference)new SVNEntryRevisionReference(reference1.path, reference1.pegRevision, from), (SVNEntryRevisionReference)new SVNEntryRevisionReference(reference1.path, reference1.pegRevision, to), (ISVNConnector)this) == 1 : SVNUtility.compareRevisions((SVNRevision)from, (SVNRevision)to, (SVNEntryRevisionReference)((SVNEntryRevisionReference)reference1), (SVNEntryRevisionReference)reference2, (ISVNConnector)this) == 1;
                int i = 0;
                String startUrlPref = reference1.path;
                String string = endUrlPref = reference2 == null ? reference1.path : reference2.path;
                SVNLogEntry[] allMsgs = reversed ? SVNUtility.logEntries((ISVNConnector)this, (SVNEntryReference)(reference2 == null ? reference1 : this.getValidReference((SVNEntryReference)reference2, from, monitor)), (SVNRevision)from, (SVNRevision)to, (long)262144L, (String[])ISVNConnector.DEFAULT_LOG_ENTRY_PROPS, (long)0L, (ISVNProgressMonitor)monitor) : SVNUtility.logEntries((ISVNConnector)this, (SVNEntryReference)(reference2 == null ? reference1 : reference2), (SVNRevision)to, (SVNRevision)from, (long)262144L, (String[])ISVNConnector.DEFAULT_LOG_ENTRY_PROPS, (long)0L, (ISVNProgressMonitor)monitor);
                long minRev = ((SVNRevision.Number)(reversed ? to : from)).getNumber();
                Iterator it = tmp.iterator();
                while (it.hasNext()) {
                    if (monitor.isActivityCancelled()) {
                        return;
                    }
                    SVNNotification state = (SVNNotification)it.next();
                    String tPath = state.path.substring(path.length());
                    String startUrl = SVNUtility.normalizeURL((String)(String.valueOf(startUrlPref) + tPath));
                    String endUrl = SVNUtility.normalizeURL((String)(String.valueOf(endUrlPref) + tPath));
                    boolean skipped = state.action == 7;
                    int cState = 0;
                    int pState = 0;
                    if (state.action == 9) {
                        cState = 3;
                    } else if (state.action == 8) {
                        cState = 4;
                    } else if (state.action == 10) {
                        int n = state.propState == 5 ? 2 : (pState = state.propState == 7 ? 9 : 0);
                        cState = state.contentState == 5 || state.contentState == 6 ? 2 : (state.contentState == 7 ? 9 : 0);
                    } else if (state.action == 7) {
                        if (state.contentState == 3) {
                            try {
                                SVNRevision pegRev = reference1.pegRevision;
                                if (reference2 != null) {
                                    pegRev = reference2.pegRevision;
                                }
                                SVNUtility.info((ISVNConnector)this, (SVNEntryRevisionReference)new SVNEntryRevisionReference(endUrl, pegRev, to), (int)0, (ISVNProgressMonitor)monitor);
                                pState = 2;
                                cState = 2;
                            }
                            catch (Exception exception) {
                                cState = 4;
                            }
                        } else if (state.contentState == 4) {
                            cState = 3;
                        }
                    }
                    if (cState != 0 || pState != 0) {
                        int idx;
                        long startRevision = -1L;
                        long endRevision = -1L;
                        long date = 0L;
                        String author = null;
                        String message = null;
                        monitor.progress(i, tmp.size(), SVNKitConnector.makeItemState(state));
                        if (cState == 3 && !reversed || cState == 4 && reversed) {
                            idx = this.getLogIndex(allMsgs, endUrl, false);
                            if (idx != -1) {
                                endRevision = allMsgs[idx].revision;
                                date = allMsgs[idx].date;
                                author = allMsgs[idx].author;
                                message = allMsgs[idx].message;
                            }
                        } else if (cState == 2 || cState == 9 || pState == 2 || pState == 9) {
                            idx = this.getLogIndex(allMsgs, endUrl, false);
                            if (idx != -1) {
                                endRevision = allMsgs[idx].revision;
                                date = allMsgs[idx].date;
                                author = allMsgs[idx].author;
                                message = allMsgs[idx].message;
                            }
                            startRevision = (idx = this.getLogIndex(allMsgs, startUrl, true)) != -1 ? Math.max(allMsgs[idx].revision, minRev) : minRev;
                        } else {
                            idx = this.getLogIndex(allMsgs, endUrl, false);
                            if (idx != -1) {
                                endRevision = allMsgs[idx].revision;
                                date = allMsgs[idx].date;
                                author = allMsgs[idx].author;
                                message = allMsgs[idx].message;
                            } else {
                                idx = this.getLogIndex(allMsgs, startUrl, false);
                                if (idx != -1) {
                                    endUrl = startUrl;
                                    endRevision = allMsgs[idx].revision;
                                    date = allMsgs[idx].date;
                                    author = allMsgs[idx].author;
                                    message = allMsgs[idx].message;
                                }
                            }
                            idx = this.getLogIndex(allMsgs, startUrl, true);
                            long l = startRevision = idx != -1 ? Math.max(allMsgs[idx].revision, minRev) : minRev;
                        }
                        if (reversed) {
                            startRevision = endRevision;
                            endRevision = allMsgs[allMsgs.length - 1].revision;
                            date = allMsgs[allMsgs.length - 1].date;
                            author = allMsgs[allMsgs.length - 1].author;
                            message = allMsgs[allMsgs.length - 1].message;
                        }
                        cb.next(new SVNMergeStatus(startUrl, endUrl, state.path, state.kind, cState, pState, startRevision, endRevision, date, author, message, skipped, false, null));
                    }
                    ++i;
                }
                return;
            }
            catch (ClientException ex) {
                this.handleClientException(ex);
                wrapper.interrupt();
                this.composite.remove((ISVNNotificationCallback)wrapper);
                return;
            }
        }
        finally {
            wrapper.interrupt();
            this.composite.remove((ISVNNotificationCallback)wrapper);
        }
    }

    protected SVNEntryReference getValidReference(SVNEntryReference referenceToExisting, SVNRevision lastRevision, ISVNProgressMonitor monitor) throws SVNConnectorException {
        if (referenceToExisting.pegRevision.getKind() != 7 && referenceToExisting.pegRevision.getKind() != 1) {
            throw new RuntimeException("Unexpected revision kind. Kind: " + referenceToExisting.pegRevision.getKind());
        }
        if (lastRevision.getKind() != 1) {
            throw new RuntimeException("Unexpected last revision kind. Kind: " + lastRevision.getKind());
        }
        if (referenceToExisting.pegRevision.getKind() == 7) {
            return referenceToExisting;
        }
        long start = ((SVNRevision.Number)referenceToExisting.pegRevision).getNumber();
        long end = ((SVNRevision.Number)lastRevision).getNumber();
        while (end > start) {
            referenceToExisting = this.getLastValidReference(referenceToExisting, lastRevision, monitor);
            if (referenceToExisting.pegRevision.equals((Object)lastRevision)) continue;
            start = ((SVNRevision.Number)referenceToExisting.pegRevision).getNumber() + 1L;
            SVNEntryReference tRef = new SVNEntryReference(referenceToExisting.path, (SVNRevision)SVNRevision.fromNumber((long)start));
            while (!this.exists(tRef, monitor)) {
                tRef = new SVNEntryReference(tRef.path.substring(0, tRef.path.lastIndexOf("/")), tRef.pegRevision);
            }
            SVNLogEntry[] log = SVNUtility.logEntries((ISVNConnector)this, (SVNEntryReference)tRef, (SVNRevision)tRef.pegRevision, (SVNRevision)referenceToExisting.pegRevision, (long)262144L, (String[])ISVNConnector.DEFAULT_LOG_ENTRY_PROPS, (long)0L, (ISVNProgressMonitor)monitor);
            SVNLogPath[] paths = log[0].changedPaths;
            boolean renamed = false;
            if (paths != null) {
                String decodedUrl = SVNUtility.decodeURL((String)referenceToExisting.path);
                int k = 0;
                while (k < paths.length) {
                    int idx;
                    if (paths[k].copiedFromPath != null && (idx = decodedUrl.indexOf(paths[k].copiedFromPath)) != -1 && (decodedUrl.charAt(idx + paths[k].copiedFromPath.length()) == '/' || decodedUrl.endsWith(paths[k].copiedFromPath))) {
                        decodedUrl = String.valueOf(decodedUrl.substring(0, idx)) + paths[k].path + decodedUrl.substring(idx + paths[k].copiedFromPath.length());
                        tRef = new SVNEntryReference(SVNUtility.encodeURL((String)decodedUrl), tRef.pegRevision);
                        renamed = true;
                        break;
                    }
                    ++k;
                }
            }
            referenceToExisting = tRef;
            if (renamed) continue;
            return referenceToExisting;
        }
        return referenceToExisting;
    }

    protected SVNEntryReference getLastValidReference(SVNEntryReference referenceToExisting, SVNRevision lastRevision, ISVNProgressMonitor monitor) {
        long start = ((SVNRevision.Number)referenceToExisting.pegRevision).getNumber();
        long end = ((SVNRevision.Number)lastRevision).getNumber();
        do {
            long middle;
            SVNEntryReference tRef;
            if (this.exists(tRef = new SVNEntryReference(referenceToExisting.path, (SVNRevision)SVNRevision.fromNumber((long)(middle = end - (end - start) / 2L))), monitor)) {
                start = middle;
                referenceToExisting = tRef;
                continue;
            }
            if (end - start == 1L) break;
            end = middle;
        } while (end > start);
        return referenceToExisting;
    }

    protected boolean exists(SVNEntryReference reference, ISVNProgressMonitor monitor) {
        try {
            SVNUtility.logEntries((ISVNConnector)this, (SVNEntryReference)reference, (SVNRevision)reference.pegRevision, (SVNRevision)reference.pegRevision, (long)0L, (String[])ISVNConnector.EMPTY_LOG_ENTRY_PROPS, (long)1L, (ISVNProgressMonitor)monitor);
            return true;
        }
        catch (SVNConnectorException sVNConnectorException) {
            return false;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected int getLogIndex(SVNLogEntry[] msgs, String url, boolean last) {
        String decodedUrl = SVNUtility.decodeURL((String)url);
        int retVal = -1;
        int j = 0;
        while (j < msgs.length) {
            SVNLogPath[] paths = msgs[j].changedPaths;
            if (paths != null) {
                int maxPathIdx = -1;
                int maxPathLen = 0;
                int k = 0;
                while (k < paths.length) {
                    int idx;
                    if (paths[k] != null && decodedUrl.endsWith(paths[k].path)) {
                        if (!last) return j;
                        if (paths[k].copiedFromPath != null) {
                            maxPathIdx = k;
                            maxPathLen = paths[k].path.length();
                        }
                        retVal = paths[k].action == 'A' ? j : -1;
                    } else if (paths[k].copiedFromPath != null && (idx = decodedUrl.indexOf(paths[k].path)) != -1 && (decodedUrl.charAt(idx + paths[k].path.length()) == '/' || decodedUrl.endsWith(paths[k].path)) && paths[k].path.length() > maxPathLen) {
                        maxPathIdx = k;
                        maxPathLen = paths[k].path.length();
                    }
                    ++k;
                }
                if (maxPathIdx != -1) {
                    int idx = decodedUrl.indexOf(paths[maxPathIdx].path);
                    decodedUrl = String.valueOf(decodedUrl.substring(0, idx)) + paths[maxPathIdx].copiedFromPath + decodedUrl.substring(idx + paths[maxPathIdx].path.length());
                }
            }
            ++j;
        }
        return retVal;
    }

    public void doImport(String path, String url, String message, int depth, long options, Map revProps, ISVNProgressMonitor monitor) throws SVNConnectorException {
        ProgressMonitorWrapper wrapper = new ProgressMonitorWrapper(monitor);
        try {
            try {
                this.composite.add((ISVNNotificationCallback)wrapper);
                wrapper.start();
                this.client.doImport(path, url, message, depth, (options & 0x100L) != 0L, (options & 0x1000L) != 0L, ConversionUtility.convert(revProps));
            }
            catch (ClientException ex) {
                this.handleClientException(ex);
                wrapper.interrupt();
                this.composite.remove((ISVNNotificationCallback)wrapper);
            }
        }
        finally {
            wrapper.interrupt();
            this.composite.remove((ISVNNotificationCallback)wrapper);
        }
    }

    public long doExport(SVNEntryRevisionReference fromReference, String destPath, String nativeEOL, int depth, long options, ISVNProgressMonitor monitor) throws SVNConnectorException {
        ProgressMonitorWrapper wrapper = new ProgressMonitorWrapper(monitor);
        try {
            this.composite.add((ISVNNotificationCallback)wrapper);
            wrapper.start();
            long l = this.client.doExport(fromReference.path, destPath, ConversionUtility.convert(fromReference.revision), ConversionUtility.convert(fromReference.pegRevision), (options & 4L) != 0L, (options & 1L) != 0L, depth, nativeEOL);
            return l;
        }
        catch (ClientException ex) {
            this.handleClientException(ex);
        }
        finally {
            wrapper.interrupt();
            this.composite.remove((ISVNNotificationCallback)wrapper);
        }
        return 0L;
    }

    public void diff(SVNEntryRevisionReference reference1, SVNEntryRevisionReference reference2, String relativeToDir, String outFileName, int depth, long options, String[] changelistNames, ISVNProgressMonitor monitor) throws SVNConnectorException {
        ProgressMonitorWrapper wrapper = new ProgressMonitorWrapper(monitor);
        try {
            try {
                this.composite.add((ISVNNotificationCallback)wrapper);
                wrapper.start();
                this.client.diff(reference1.path, ConversionUtility.convert(reference1.revision), reference2.path, ConversionUtility.convert(reference2.revision), relativeToDir, outFileName, depth, changelistNames, (options & 0x200L) != 0L, (options & 0x2000L) != 0L, (options & 4L) != 0L);
            }
            catch (ClientException ex) {
                this.handleClientException(ex);
                wrapper.interrupt();
                this.composite.remove((ISVNNotificationCallback)wrapper);
            }
        }
        finally {
            wrapper.interrupt();
            this.composite.remove((ISVNNotificationCallback)wrapper);
        }
    }

    public void diff(SVNEntryReference reference, SVNRevision revision1, SVNRevision revision2, String relativeToDir, String outFileName, int depth, long options, String[] changelistNames, ISVNProgressMonitor monitor) throws SVNConnectorException {
        ProgressMonitorWrapper wrapper = new ProgressMonitorWrapper(monitor);
        try {
            try {
                this.composite.add((ISVNNotificationCallback)wrapper);
                wrapper.start();
                this.client.diff(reference.path, ConversionUtility.convert(reference.pegRevision), ConversionUtility.convert(revision1), ConversionUtility.convert(revision2), relativeToDir, outFileName, depth, changelistNames, (options & 0x200L) != 0L, (options & 0x2000L) != 0L, (options & 4L) != 0L);
            }
            catch (ClientException ex) {
                this.handleClientException(ex);
                wrapper.interrupt();
                this.composite.remove((ISVNNotificationCallback)wrapper);
            }
        }
        finally {
            wrapper.interrupt();
            this.composite.remove((ISVNNotificationCallback)wrapper);
        }
    }

    public void diffStatus(SVNEntryRevisionReference reference1, SVNEntryRevisionReference reference2, int depth, long options, String[] changelistNames, ISVNDiffStatusCallback cb, ISVNProgressMonitor monitor) throws SVNConnectorException {
        SVNEntryInfo[] infos = SVNUtility.info((ISVNConnector)this, (SVNEntryRevisionReference)reference1, (int)0, (ISVNProgressMonitor)monitor);
        boolean isFile = infos.length > 0 && infos[0] != null && infos[0].kind == 1;
        ProgressMonitorWrapper wrapper = new ProgressMonitorWrapper(monitor);
        try {
            try {
                this.composite.add((ISVNNotificationCallback)wrapper);
                wrapper.start();
                DiffCallback callback = new DiffCallback(reference1.path, reference2.path, isFile, cb);
                this.client.diffSummarize(reference1.path, ConversionUtility.convert(reference1.revision), reference2.path, ConversionUtility.convert(reference2.revision), depth, changelistNames, (options & 0x200L) != 0L, (DiffSummaryReceiver)callback);
                callback.doLastDiff();
            }
            catch (ClientException ex) {
                this.handleClientException(ex);
                wrapper.interrupt();
                this.composite.remove((ISVNNotificationCallback)wrapper);
            }
        }
        finally {
            wrapper.interrupt();
            this.composite.remove((ISVNNotificationCallback)wrapper);
        }
    }

    public void diffStatus(SVNEntryReference reference, SVNRevision revision1, SVNRevision revision2, int depth, long options, String[] changelistNames, ISVNDiffStatusCallback cb, ISVNProgressMonitor monitor) throws SVNConnectorException {
        SVNEntryInfo[] infos = SVNUtility.info((ISVNConnector)this, (SVNEntryRevisionReference)new SVNEntryRevisionReference(reference, revision1), (int)0, (ISVNProgressMonitor)monitor);
        boolean isFile = infos.length > 0 && infos[0] != null && infos[0].kind == 1;
        ProgressMonitorWrapper wrapper = new ProgressMonitorWrapper(monitor);
        try {
            try {
                this.composite.add((ISVNNotificationCallback)wrapper);
                wrapper.start();
                DiffCallback callback = new DiffCallback(reference.path, reference.path, isFile, cb);
                this.client.diffSummarize(reference.path, ConversionUtility.convert(reference.pegRevision), ConversionUtility.convert(revision1), ConversionUtility.convert(revision2), depth, changelistNames, (options & 0x200L) != 0L, (DiffSummaryReceiver)callback);
                callback.doLastDiff();
            }
            catch (ClientException ex) {
                this.handleClientException(ex);
                wrapper.interrupt();
                this.composite.remove((ISVNNotificationCallback)wrapper);
            }
        }
        finally {
            wrapper.interrupt();
            this.composite.remove((ISVNNotificationCallback)wrapper);
        }
    }

    public void info(SVNEntryRevisionReference reference, int depth, String[] changelistNames, ISVNEntryInfoCallback cb, ISVNProgressMonitor monitor) throws SVNConnectorException {
        ProgressMonitorWrapper wrapper = new ProgressMonitorWrapper(monitor);
        try {
            try {
                this.composite.add((ISVNNotificationCallback)wrapper);
                wrapper.start();
                this.client.info2(reference.path, ConversionUtility.convert(reference.revision), ConversionUtility.convert(reference.pegRevision), depth, changelistNames, ConversionUtility.convert(cb));
            }
            catch (ClientException ex) {
                this.handleClientException(ex);
                wrapper.interrupt();
                this.composite.remove((ISVNNotificationCallback)wrapper);
            }
        }
        finally {
            wrapper.interrupt();
            this.composite.remove((ISVNNotificationCallback)wrapper);
        }
    }

    public void streamFileContent(SVNEntryRevisionReference reference, int bufferSize, OutputStream stream, ISVNProgressMonitor monitor) throws SVNConnectorException {
        ProgressMonitorWrapper wrapper = new ProgressMonitorWrapper(monitor);
        try {
            try {
                this.composite.add((ISVNNotificationCallback)wrapper);
                wrapper.start();
                this.client.streamFileContent(reference.path, ConversionUtility.convert(reference.revision), ConversionUtility.convert(reference.pegRevision), bufferSize, stream);
            }
            catch (ClientException ex) {
                this.handleClientException(ex);
                wrapper.interrupt();
                this.composite.remove((ISVNNotificationCallback)wrapper);
            }
        }
        finally {
            wrapper.interrupt();
            this.composite.remove((ISVNNotificationCallback)wrapper);
        }
    }

    public void mkdir(String[] path, String message, long options, Map revProps, ISVNProgressMonitor monitor) throws SVNConnectorException {
        ProgressMonitorWrapper wrapper = new ProgressMonitorWrapper(monitor);
        try {
            try {
                this.composite.add((ISVNNotificationCallback)wrapper);
                wrapper.start();
                this.client.mkdir(path, message, (options & 8L) != 0L, ConversionUtility.convert(revProps));
            }
            catch (ClientException ex) {
                this.handleClientException(ex);
                wrapper.interrupt();
                this.composite.remove((ISVNNotificationCallback)wrapper);
            }
        }
        finally {
            wrapper.interrupt();
            this.composite.remove((ISVNNotificationCallback)wrapper);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void move(String[] srcPaths, String dstPath, long options, ISVNProgressMonitor monitor) throws SVNConnectorException {
        ProgressMonitorWrapper wrapper = new ProgressMonitorWrapper(monitor);
        try {
            try {
                this.composite.add((ISVNNotificationCallback)wrapper);
                wrapper.start();
                int i = 0;
                while (i < srcPaths.length) {
                    if (monitor.isActivityCancelled()) {
                        return;
                    }
                    this.client.move(srcPaths[i], dstPath, (options & 4L) != 0L);
                    ++i;
                }
                return;
            }
            catch (ClientException ex) {
                this.handleClientException(ex);
                wrapper.interrupt();
                this.composite.remove((ISVNNotificationCallback)wrapper);
                return;
            }
        }
        finally {
            wrapper.interrupt();
            this.composite.remove((ISVNNotificationCallback)wrapper);
        }
    }

    public void move(SVNEntryReference[] srcPaths, String dstPath, String message, long options, Map revProps, ISVNProgressMonitor monitor) throws SVNConnectorException {
        ProgressMonitorWrapper wrapper = new ProgressMonitorWrapper(monitor);
        try {
            try {
                this.composite.add((ISVNNotificationCallback)wrapper);
                wrapper.start();
                ArrayList<String> src = new ArrayList<String>();
                SVNEntryReference[] sVNEntryReferenceArray = srcPaths;
                int n = srcPaths.length;
                int n2 = 0;
                while (n2 < n) {
                    SVNEntryReference current = sVNEntryReferenceArray[n2];
                    src.add(current.path);
                    ++n2;
                }
                this.client.move(src.toArray(new String[0]), dstPath, message, (options & 4L) != 0L, (options & 0x8000L) != 0L, (options & 8L) != 0L, ConversionUtility.convert(revProps));
            }
            catch (ClientException ex) {
                this.handleClientException(ex);
                wrapper.interrupt();
                this.composite.remove((ISVNNotificationCallback)wrapper);
            }
        }
        finally {
            wrapper.interrupt();
            this.composite.remove((ISVNNotificationCallback)wrapper);
        }
    }

    public void copy(String[] srcPaths, String destPath, SVNRevision revision, ISVNProgressMonitor monitor) throws SVNConnectorException {
        ProgressMonitorWrapper wrapper = new ProgressMonitorWrapper(monitor);
        try {
            try {
                this.composite.add((ISVNNotificationCallback)wrapper);
                wrapper.start();
                CopySource[] srcs = new CopySource[srcPaths.length];
                int i = 0;
                while (i < srcPaths.length) {
                    srcs[i] = new CopySource(srcPaths[i], ConversionUtility.convert(revision), null);
                    ++i;
                }
                this.client.copy(srcs, destPath, null, true, false, null);
            }
            catch (ClientException ex) {
                this.handleClientException(ex);
                wrapper.interrupt();
                this.composite.remove((ISVNNotificationCallback)wrapper);
            }
        }
        finally {
            wrapper.interrupt();
            this.composite.remove((ISVNNotificationCallback)wrapper);
        }
    }

    public void copy(SVNEntryRevisionReference[] srcPaths, String destPath, String message, long options, Map revProps, ISVNProgressMonitor monitor) throws SVNConnectorException {
        ProgressMonitorWrapper wrapper = new ProgressMonitorWrapper(monitor);
        try {
            try {
                this.composite.add((ISVNNotificationCallback)wrapper);
                wrapper.start();
                this.client.copy(ConversionUtility.convert(srcPaths), destPath, message, (options & 0x8000L) != 0L, (options & 8L) != 0L, ConversionUtility.convert(revProps));
            }
            catch (ClientException ex) {
                this.handleClientException(ex);
                wrapper.interrupt();
                this.composite.remove((ISVNNotificationCallback)wrapper);
            }
        }
        finally {
            wrapper.interrupt();
            this.composite.remove((ISVNNotificationCallback)wrapper);
        }
    }

    public void remove(String[] path, String message, long options, Map revProps, ISVNProgressMonitor monitor) throws SVNConnectorException {
        ProgressMonitorWrapper wrapper = new ProgressMonitorWrapper(monitor);
        try {
            try {
                this.composite.add((ISVNNotificationCallback)wrapper);
                wrapper.start();
                this.client.remove(path, message, (options & 4L) != 0L, (options & 0x10000L) != 0L, ConversionUtility.convert(revProps));
            }
            catch (ClientException ex) {
                this.handleClientException(ex);
                wrapper.interrupt();
                this.composite.remove((ISVNNotificationCallback)wrapper);
            }
        }
        finally {
            wrapper.interrupt();
            this.composite.remove((ISVNNotificationCallback)wrapper);
        }
    }

    public void logEntries(SVNEntryReference reference, SVNRevision revisionStart, SVNRevision revisionEnd, String[] revProps, long limit, long options, ISVNLogEntryCallback cb, ISVNProgressMonitor monitor) throws SVNConnectorException {
        ProgressMonitorWrapper wrapper = new ProgressMonitorWrapper(monitor);
        try {
            try {
                this.composite.add((ISVNNotificationCallback)wrapper);
                wrapper.start();
                this.client.logMessages(reference.path, ConversionUtility.convert(reference.pegRevision), ConversionUtility.convert(revisionStart), ConversionUtility.convert(revisionEnd), (options & 0x20000L) != 0L, (options & 0x40000L) != 0L, (options & 0x80000L) != 0L, revProps, limit, ConversionUtility.convert(cb));
            }
            catch (ClientException ex) {
                if (ex.getAprError() == 200007 && (options & 0x80000L) != 0L) {
                    this.logEntries(reference, revisionStart, revisionEnd, revProps, limit, options &= 0xFFFFFFFFFFF7FFFFL, cb, monitor);
                } else {
                    this.handleClientException(ex);
                }
                wrapper.interrupt();
                this.composite.remove((ISVNNotificationCallback)wrapper);
            }
        }
        finally {
            wrapper.interrupt();
            this.composite.remove((ISVNNotificationCallback)wrapper);
        }
    }

    public void annotate(SVNEntryReference reference, SVNRevision revisionStart, SVNRevision revisionEnd, long options, ISVNAnnotationCallback callback, ISVNProgressMonitor monitor) throws SVNConnectorException {
        ProgressMonitorWrapper wrapper = new ProgressMonitorWrapper(monitor);
        try {
            try {
                this.composite.add((ISVNNotificationCallback)wrapper);
                wrapper.start();
                this.client.blame(reference.path, ConversionUtility.convert(reference.pegRevision), ConversionUtility.convert(revisionStart), ConversionUtility.convert(revisionEnd), (options & 0x100000L) != 0L, (options & 0x80000L) != 0L, ConversionUtility.convert(callback));
            }
            catch (ClientException ex) {
                if (ex.getAprError() == 200007 && (options & 0x80000L) != 0L) {
                    this.annotate(reference, revisionStart, revisionEnd, options &= 0xFFFFFFFFFFF7FFFFL, callback, monitor);
                } else {
                    this.handleClientException(ex);
                }
                wrapper.interrupt();
                this.composite.remove((ISVNNotificationCallback)wrapper);
            }
        }
        finally {
            wrapper.interrupt();
            this.composite.remove((ISVNNotificationCallback)wrapper);
        }
    }

    public void list(SVNEntryRevisionReference reference, int depth, int direntFields, long options, final ISVNEntryCallback cb, ISVNProgressMonitor monitor) throws SVNConnectorException {
        ProgressMonitorWrapper wrapper = new ProgressMonitorWrapper(monitor);
        try {
            try {
                this.composite.add((ISVNNotificationCallback)wrapper);
                wrapper.start();
                this.client.list(reference.path, ConversionUtility.convert(reference.revision), ConversionUtility.convert(reference.pegRevision), depth, direntFields, (options & 0x200000L) != 0L, new ListCallback(){

                    public void doEntry(DirEntry dirent, Lock lock) {
                        String path = dirent.getPath();
                        if (path != null && path.length() != 0 || dirent.getNodeKind() == 1) {
                            Date date = dirent.getLastChanged();
                            cb.next(new SVNEntry(path, dirent.getLastChangedRevisionNumber(), date == null ? 0L : date.getTime(), dirent.getLastAuthor(), dirent.getHasProps(), dirent.getNodeKind(), dirent.getSize(), ConversionUtility.convert(lock)));
                        }
                    }
                });
            }
            catch (ClientException ex) {
                this.handleClientException(ex);
                wrapper.interrupt();
                this.composite.remove((ISVNNotificationCallback)wrapper);
            }
        }
        finally {
            wrapper.interrupt();
            this.composite.remove((ISVNNotificationCallback)wrapper);
        }
    }

    public void getProperties(SVNEntryRevisionReference reference, int depth, String[] changelistNames, ISVNPropertyCallback callback, ISVNProgressMonitor monitor) throws SVNConnectorException {
        ProgressMonitorWrapper wrapper = new ProgressMonitorWrapper(monitor);
        try {
            try {
                this.composite.add((ISVNNotificationCallback)wrapper);
                wrapper.start();
                this.client.properties(reference.path, ConversionUtility.convert(reference.revision), ConversionUtility.convert(reference.pegRevision), depth, changelistNames, ConversionUtility.convert(callback));
            }
            catch (ClientException ex) {
                this.handleClientException(ex);
                wrapper.interrupt();
                this.composite.remove((ISVNNotificationCallback)wrapper);
            }
        }
        finally {
            wrapper.interrupt();
            this.composite.remove((ISVNNotificationCallback)wrapper);
        }
    }

    public SVNProperty getProperty(SVNEntryRevisionReference reference, String name, ISVNProgressMonitor monitor) throws SVNConnectorException {
        ProgressMonitorWrapper wrapper = new ProgressMonitorWrapper(monitor);
        try {
            this.composite.add((ISVNNotificationCallback)wrapper);
            wrapper.start();
            SVNProperty sVNProperty = ConversionUtility.convert(this.client.propertyGet(reference.path, name, ConversionUtility.convert(reference.revision), ConversionUtility.convert(reference.pegRevision)));
            return sVNProperty;
        }
        catch (ClientException ex) {
            this.handleClientException(ex);
        }
        finally {
            wrapper.interrupt();
            this.composite.remove((ISVNNotificationCallback)wrapper);
        }
        return null;
    }

    public void removeProperty(String path, String name, int depth, String[] changelistNames, ISVNProgressMonitor monitor) throws SVNConnectorException {
        ProgressMonitorWrapper wrapper = new ProgressMonitorWrapper(monitor);
        try {
            try {
                this.composite.add((ISVNNotificationCallback)wrapper);
                wrapper.start();
                this.client.propertyRemove(path, name, depth, changelistNames);
            }
            catch (ClientException ex) {
                this.handleClientException(ex);
                wrapper.interrupt();
                this.composite.remove((ISVNNotificationCallback)wrapper);
            }
        }
        finally {
            wrapper.interrupt();
            this.composite.remove((ISVNNotificationCallback)wrapper);
        }
    }

    public void setProperty(String path, String name, String value, int depth, long options, String[] changelistNames, ISVNProgressMonitor monitor) throws SVNConnectorException {
        ProgressMonitorWrapper wrapper = new ProgressMonitorWrapper(monitor);
        try {
            try {
                this.composite.add((ISVNNotificationCallback)wrapper);
                wrapper.start();
                this.client.propertySet(path, name, value, depth, changelistNames, (options & 4L) != 0L, null);
            }
            catch (ClientException ex) {
                this.handleClientException(ex);
                wrapper.interrupt();
                this.composite.remove((ISVNNotificationCallback)wrapper);
            }
        }
        finally {
            wrapper.interrupt();
            this.composite.remove((ISVNNotificationCallback)wrapper);
        }
    }

    public SVNProperty[] getRevisionProperties(SVNEntryReference reference, ISVNProgressMonitor monitor) throws SVNConnectorException {
        ProgressMonitorWrapper wrapper = new ProgressMonitorWrapper(monitor);
        try {
            this.composite.add((ISVNNotificationCallback)wrapper);
            wrapper.start();
            SVNProperty[] sVNPropertyArray = ConversionUtility.convert(this.client.revProperties(reference.path, ConversionUtility.convert(reference.pegRevision)));
            return sVNPropertyArray;
        }
        catch (ClientException ex) {
            this.handleClientException(ex);
        }
        finally {
            wrapper.interrupt();
            this.composite.remove((ISVNNotificationCallback)wrapper);
        }
        return null;
    }

    public SVNProperty getRevisionProperty(SVNEntryReference reference, String name, ISVNProgressMonitor monitor) throws SVNConnectorException {
        ProgressMonitorWrapper wrapper = new ProgressMonitorWrapper(monitor);
        try {
            this.composite.add((ISVNNotificationCallback)wrapper);
            wrapper.start();
            SVNProperty sVNProperty = ConversionUtility.convert(this.client.revProperty(reference.path, name, ConversionUtility.convert(reference.pegRevision)));
            return sVNProperty;
        }
        catch (ClientException ex) {
            this.handleClientException(ex);
        }
        finally {
            wrapper.interrupt();
            this.composite.remove((ISVNNotificationCallback)wrapper);
        }
        return null;
    }

    public void setRevisionProperty(SVNEntryReference reference, String name, String value, long options, ISVNProgressMonitor monitor) throws SVNConnectorException {
        ProgressMonitorWrapper wrapper = new ProgressMonitorWrapper(monitor);
        try {
            try {
                this.composite.add((ISVNNotificationCallback)wrapper);
                wrapper.start();
                this.client.setRevProperty(reference.path, name, ConversionUtility.convert(reference.pegRevision), value, (options & 4L) != 0L);
            }
            catch (ClientException ex) {
                this.handleClientException(ex);
                wrapper.interrupt();
                this.composite.remove((ISVNNotificationCallback)wrapper);
            }
        }
        finally {
            wrapper.interrupt();
            this.composite.remove((ISVNNotificationCallback)wrapper);
        }
    }

    public void removeRevisionProperty(SVNEntryReference reference, String name, long options, ISVNProgressMonitor monitor) throws SVNConnectorException {
    }

    public void dispose() {
        this.client.dispose();
    }

    protected void handleSubversionException(SubversionException ex) throws SVNConnectorException {
        throw new SVNConnectorException(ex.getMessage(), (Throwable)ex);
    }

    protected void handleClientException(ClientException ex) throws SVNConnectorException {
        String msg = ex.getMessage();
        if (this.findConflict(ex)) {
            throw new SVNConnectorUnresolvedConflictException(msg, (Throwable)ex);
        }
        if (this.findCancel(ex)) {
            throw new SVNConnectorCancelException(msg, (Throwable)ex);
        }
        if (this.findAuthentication(ex)) {
            throw new SVNConnectorAuthenticationException(msg, (Throwable)ex);
        }
        throw new SVNConnectorException(msg, ex.getAprError(), (Throwable)ex);
    }

    protected boolean findAuthentication(ClientException t) {
        return t.getAprError() == 170001;
    }

    protected boolean findCancel(ClientException t) {
        return t.getAprError() == 200015;
    }

    protected boolean findConflict(ClientException t) {
        return t.getAprError() == 160024 || t.getAprError() == 160028;
    }

    public static ISVNProgressMonitor.ItemState makeItemState(SVNNotification arg0) {
        return new ISVNProgressMonitor.ItemState(arg0.path, arg0.action, arg0.kind, arg0.mimeType, arg0.contentState, arg0.propState, arg0.revision);
    }

    protected static synchronized ProgressMonitorThread getProgressMonitorThread() {
        if (monitorWrapperThread == null) {
            monitorWrapperThread = new ProgressMonitorThread();
            monitorWrapperThread.start();
        }
        return monitorWrapperThread;
    }

    public void createRepository(String repositoryPath, String repositoryType, ISVNProgressMonitor monitor) throws SVNConnectorException {
    }

    private class DiffCallback
    implements DiffSummaryReceiver {
        private String prev;
        private String next;
        private boolean isFile;
        private SVNDiffStatus savedDiff;
        private ISVNDiffStatusCallback cb;

        public DiffCallback(String prev, String next, boolean isFile, ISVNDiffStatusCallback cb) {
            this.prev = SVNUtility.decodeURL((String)prev);
            this.next = SVNUtility.decodeURL((String)next);
            this.isFile = isFile;
            this.cb = cb;
        }

        public void onSummary(DiffSummary descriptor) {
            int propChangeType;
            int changeType = 1;
            if (descriptor.getDiffKind() == DiffSummary.DiffKind.ADDED) {
                changeType = 3;
            } else if (descriptor.getDiffKind() == DiffSummary.DiffKind.DELETED) {
                changeType = 4;
            } else if (descriptor.getDiffKind() == DiffSummary.DiffKind.MODIFIED) {
                changeType = 2;
            }
            int n = propChangeType = descriptor.propsChanged() ? 2 : 1;
            if (changeType != 1 || propChangeType != 1) {
                String tPath1;
                String tPath2 = tPath1 = descriptor.getPath();
                if (tPath1.length() == 0 || this.isFile) {
                    tPath1 = this.prev;
                    tPath2 = this.next;
                } else {
                    tPath1 = String.valueOf(this.prev) + "/" + tPath1;
                    tPath2 = String.valueOf(this.next) + "/" + tPath2;
                }
                SVNDiffStatus status = new SVNDiffStatus(SVNUtility.encodeURL((String)tPath1), SVNUtility.encodeURL((String)tPath2), descriptor.getNodeKind(), changeType, propChangeType);
                if (this.savedDiff != null) {
                    if (this.savedDiff.pathPrev.equals(status.pathPrev) && this.savedDiff.pathNext.equals(status.pathNext) && this.savedDiff.textStatus == 4 && status.textStatus == 3) {
                        this.savedDiff = new SVNDiffStatus(SVNUtility.encodeURL((String)tPath1), SVNUtility.encodeURL((String)tPath2), descriptor.getNodeKind(), 7, 1);
                        status = null;
                    }
                    this.cb.next(this.savedDiff);
                }
                this.savedDiff = status;
            }
        }

        public void doLastDiff() {
            if (this.savedDiff != null) {
                this.cb.next(this.savedDiff);
            }
        }
    }

    protected static class ProgressMonitorThread
    extends Thread {
        private final List<ProgressMonitorWrapper> monitors = new ArrayList<ProgressMonitorWrapper>();

        public ProgressMonitorThread() {
            super("SVN Kit 1.2 Connector");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(ProgressMonitorWrapper monitor) {
            List<ProgressMonitorWrapper> list = this.monitors;
            synchronized (list) {
                this.monitors.add(monitor);
                this.monitors.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void remove(ProgressMonitorWrapper monitor) {
            List<ProgressMonitorWrapper> list = this.monitors;
            synchronized (list) {
                this.monitors.remove(monitor);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            List<ProgressMonitorWrapper> list = this.monitors;
            synchronized (list) {
                while (!this.isInterrupted()) {
                    this.checkForActivityCancelled();
                    try {
                        if (this.monitors.size() == 0) {
                            this.monitors.wait();
                            continue;
                        }
                        this.monitors.wait(100L);
                        continue;
                    }
                    catch (InterruptedException interruptedException) {}
                    break;
                }
                return;
            }
        }

        private void checkForActivityCancelled() {
            for (ProgressMonitorWrapper monitor : this.monitors) {
                if (monitor.isCanceled() || !monitor.monitor.isActivityCancelled()) continue;
                monitor.cancel();
            }
        }
    }

    protected class ProgressMonitorWrapper
    implements ISVNNotificationCallback {
        protected ISVNProgressMonitor monitor;
        protected int current;
        protected String errorMessage;
        protected boolean isCanceled;

        public ProgressMonitorWrapper(ISVNProgressMonitor monitor) {
            this.monitor = monitor;
            this.current = 0;
            this.isCanceled = false;
        }

        public void cancel() {
            try {
                this.isCanceled = true;
                SVNKitConnector.this.client.cancelOperation();
            }
            catch (Exception exception) {}
        }

        public String getErrorMessage() {
            return this.errorMessage;
        }

        public void notify(SVNNotification arg0) {
            if (arg0.errMsg != null) {
                this.errorMessage = this.errorMessage == null ? arg0.errMsg : String.valueOf(this.errorMessage) + "\n\n" + arg0.errMsg;
                this.monitor.reportError(arg0.errMsg);
            } else {
                this.monitor.progress(this.current++, -1, SVNKitConnector.makeItemState(arg0));
            }
        }

        public void start() {
            SVNKitConnector.getProgressMonitorThread().add(this);
        }

        public void interrupt() {
            SVNKitConnector.getProgressMonitorThread().remove(this);
        }

        public boolean isCanceled() {
            return this.isCanceled;
        }
    }

    protected class RepositoryInfoPrompt
    implements PromptUserPasswordSSL,
    PromptUserPasswordSSH,
    PromptUserPasswordProxy {
        protected ISVNCredentialsPrompt prompt;

        public RepositoryInfoPrompt(ISVNCredentialsPrompt prompt) {
            this.prompt = prompt;
        }

        public boolean prompt(String realm, String username, boolean maySave) {
            return this.prompt(realm, username);
        }

        public boolean prompt(String realm, String username) {
            return this.prompt.prompt(null, realm);
        }

        public boolean promptSSL(String realm, boolean maySave) {
            return this.prompt.promptSSL(null, realm);
        }

        public boolean promptSSH(String realm, String username, int sshPort, boolean maySave) {
            return this.prompt.promptSSH(null, realm);
        }

        public int askTrustSSLServer(String info, boolean allowPermanently) {
            return this.prompt.askTrustSSLServer(null, info, allowPermanently);
        }

        public String getUsername() {
            return this.prompt.getUsername();
        }

        public String getPassword() {
            return this.prompt.getPassword();
        }

        public String getSSHPrivateKeyPath() {
            return this.prompt.getSSHPrivateKeyPath();
        }

        public String getSSHPrivateKeyPassphrase() {
            return this.prompt.getSSHPrivateKeyPassphrase();
        }

        public int getSSHPort() {
            return this.prompt.getSSHPort();
        }

        public String getSSLClientCertPath() {
            return this.prompt.getSSLClientCertPath();
        }

        public String getSSLClientCertPassword() {
            return this.prompt.getSSLClientCertPassword();
        }

        public boolean promptProxy(String url, boolean maySave) {
            return this.prompt.promptProxy(null);
        }

        public String getProxyHost() {
            return this.prompt.getProxyHost();
        }

        public int getProxyPort() {
            return this.prompt.getProxyPort();
        }

        public String getProxyUserName() {
            return this.prompt.getProxyUserName();
        }

        public String getProxyPassword() {
            return this.prompt.getProxyPassword();
        }

        public boolean askYesNo(String realm, String question, boolean yesIsDefault) {
            return false;
        }

        public String askQuestion(String realm, String question, boolean showAnswer, boolean maySave) {
            return null;
        }

        public String askQuestion(String realm, String question, boolean showAnswer) {
            return null;
        }

        public boolean userAllowedSave() {
            return false;
        }
    }
}

