/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.javahl;

import java.io.Serializable;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class LogDate
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final DateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS z");
    private static final TimeZone UTC = TimeZone.getTimeZone("UTC");
    private final long timeMicros;
    private final String cachedString;
    private final Calendar cachedDate;

    public LogDate(String datestr) throws ParseException {
        if (datestr == null || datestr.length() != 27 || datestr.charAt(26) != 'Z') {
            throw new ParseException("String is not a valid Subversion date", 0);
        }
        Date date = formatter.parse(String.valueOf(datestr.substring(0, 23)) + " UTC");
        this.cachedString = datestr;
        this.cachedDate = Calendar.getInstance(UTC);
        this.cachedDate.setTime(date);
        this.timeMicros = this.cachedDate.getTimeInMillis() * 1000L + (long)Integer.parseInt(datestr.substring(23, 26));
    }

    public long getTimeMicros() {
        return this.timeMicros;
    }

    public long getTimeMillis() {
        return this.cachedDate.getTimeInMillis();
    }

    public Calendar getCalender() {
        return this.cachedDate;
    }

    public Date getDate() {
        return this.cachedDate.getTime();
    }

    public String toString() {
        return this.cachedString;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (int)(this.timeMicros ^ this.timeMicros >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LogDate other = (LogDate)obj;
        return this.timeMicros == other.getTimeMicros();
    }
}

