/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.operation;

import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.svn.core.SVNMessages;
import org.eclipse.team.svn.core.connector.ISVNProgressMonitor;
import org.eclipse.team.svn.core.connector.SVNConnectorException;
import org.eclipse.team.svn.core.connector.SVNConnectorUnresolvedConflictException;
import org.eclipse.team.svn.core.connector.SVNNotification;
import org.eclipse.team.svn.core.operation.IActionOperation;
import org.eclipse.team.svn.core.operation.IConsoleStream;
import org.eclipse.team.svn.core.utility.ProgressMonitorUtility;

public class SVNProgressMonitor
implements ISVNProgressMonitor {
    protected IProgressMonitor monitor;
    protected IActionOperation parent;
    protected IConsoleStream stream;
    protected IPath root;
    protected boolean enableConsoleOutput;

    public SVNProgressMonitor(IActionOperation parent, IProgressMonitor monitor, IPath root) {
        this(parent, monitor, root, true);
    }

    public SVNProgressMonitor(IActionOperation parent, IProgressMonitor monitor, IPath root, boolean enableConsoleOutput) {
        this.monitor = monitor;
        this.parent = parent;
        this.root = root;
        this.stream = parent.getConsoleStream();
        this.enableConsoleOutput = enableConsoleOutput;
    }

    public void progress(int current, int total, ISVNProgressMonitor.ItemState state) {
        if (state.error != null) {
            SVNConnectorException ex = state.path != null && state.path.length() > 0 ? new SVNConnectorUnresolvedConflictException(state.error) : new SVNConnectorException(state.error);
            this.parent.reportStatus(4, null, ex);
        }
        if (state != null && state.path != null) {
            ProgressMonitorUtility.setTaskInfo(this.monitor, this.parent, state.path);
            if (this.enableConsoleOutput) {
                SVNProgressMonitor.writeToConsole(this.stream, state.contentState, state.propState, state.action, state.path, state.revision);
            }
        }
        ProgressMonitorUtility.progress(this.monitor, current, total);
    }

    public boolean isActivityCancelled() {
        return this.monitor.isCanceled();
    }

    public static void writeToConsole(IConsoleStream stream, int contentState, int propState, int action, String path, long revision) {
        if (stream != null && path != null && path.length() > 0) {
            if (action == 11 || action == 13) {
                String message = SVNMessages.format(SVNMessages.Console_AtRevision, new String[]{String.valueOf(revision)});
                stream.write(1, message);
            } else if (action == 12) {
                String message = SVNMessages.format(SVNMessages.Console_UpdateExternal, new String[]{path});
                stream.write(1, message);
            } else {
                int severity = 1;
                String status = null;
                switch (action) {
                    case 0: 
                    case 9: 
                    case 16: {
                        status = SVNMessages.Console_Action_Added;
                        break;
                    }
                    case 2: 
                    case 8: 
                    case 17: {
                        status = SVNMessages.Console_Action_Deleted;
                        break;
                    }
                    case 10: {
                        int resourceState = contentState == 0 || contentState == 2 ? propState : contentState;
                        int n = severity = contentState == 7 || contentState == 4 || propState == 7 ? 2 : 1;
                        if (resourceState >= 0 && resourceState < SVNNotification.NodeStatus.shortStatusNames.length && (status = SVNMessages.getString("Console_Update_Status_" + SVNNotification.NodeStatus.statusNames[resourceState])).length() > 0) break;
                        status = " ";
                        break;
                    }
                    case 15: {
                        status = SVNMessages.Console_Action_Modified;
                        break;
                    }
                    case 18: {
                        status = SVNMessages.Console_Action_Replaced;
                        break;
                    }
                    case 4: {
                        status = SVNMessages.Console_Action_Reverted;
                        break;
                    }
                    case 3: {
                        status = SVNMessages.Console_Action_Restored;
                        break;
                    }
                    case 21: {
                        status = SVNMessages.Console_Action_Locked;
                        break;
                    }
                    case 22: {
                        status = SVNMessages.Console_Action_Unlocked;
                        break;
                    }
                    case 38: {
                        status = SVNMessages.Console_Status_Conflicted;
                        severity = 2;
                        break;
                    }
                    default: {
                        int resourceState = contentState == 1 ? propState : contentState;
                        status = SVNProgressMonitor.getStatus(resourceState);
                        int n = severity = resourceState == 9 || resourceState == 10 ? 2 : 1;
                    }
                }
                if (action == 19) {
                    String message = SVNMessages.format(SVNMessages.Console_TransmittingData, new String[]{path});
                    stream.write(severity, message);
                } else if (status != null) {
                    String message = SVNMessages.format(SVNMessages.Console_Status, new String[]{status, path});
                    stream.write(severity, message);
                }
            }
        }
    }

    protected static String getStatus(int resourceState) {
        switch (resourceState) {
            case 3: {
                return SVNMessages.Console_Status_Added;
            }
            case 2: {
                return SVNMessages.Console_Status_Modified;
            }
            case 4: {
                return SVNMessages.Console_Status_Deleted;
            }
            case 6: {
                return SVNMessages.Console_Status_Missing;
            }
            case 7: {
                return SVNMessages.Console_Status_Replaced;
            }
            case 8: {
                return SVNMessages.Console_Status_Merged;
            }
            case 9: {
                return SVNMessages.Console_Status_Conflicted;
            }
            case 10: {
                return SVNMessages.Console_Status_Obstructed;
            }
        }
        return null;
    }
}

