/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.core.ProjectSetCapability;
import org.eclipse.team.core.ProjectSetSerializationContext;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.svn.core.DefaultProjectSetHandler;
import org.eclipse.team.svn.core.IProjectSetHandler;
import org.eclipse.team.svn.core.SVNMessages;
import org.eclipse.team.svn.core.SVNTeamPlugin;
import org.eclipse.team.svn.core.SubclipseProjectSetHandler;
import org.eclipse.team.svn.core.operation.CompositeOperation;
import org.eclipse.team.svn.core.operation.local.RefreshResourcesOperation;
import org.eclipse.team.svn.core.operation.remote.management.SaveRepositoryLocationsOperation;
import org.eclipse.team.svn.core.utility.ProgressMonitorUtility;

public class SVNTeamProjectSetCapability
extends ProjectSetCapability {
    protected static IProjectSetHandler DEFAULT_HANDLER = new DefaultProjectSetHandler();
    protected static IProjectSetHandler SUBCLIPSE_HANDLER = new SubclipseProjectSetHandler();

    public String[] asReference(IProject[] projects, ProjectSetSerializationContext context, IProgressMonitor monitor) throws TeamException {
        monitor.beginTask(SVNMessages.Operation_ExportProjectSet, projects.length);
        try {
            String[] result = new String[projects.length];
            int i = 0;
            while (i < projects.length) {
                result[i] = DEFAULT_HANDLER.asReference(projects[i]);
                monitor.worked(1);
                ++i;
            }
            String[] stringArray = result;
            return stringArray;
        }
        finally {
            monitor.done();
        }
    }

    public IProject[] addToWorkspace(String[] referenceStrings, ProjectSetSerializationContext context, IProgressMonitor monitor) throws TeamException {
        if (referenceStrings.length == 0) {
            return new IProject[0];
        }
        IProjectSetHandler handler = SVNTeamProjectSetCapability.getProjectSetHandler(referenceStrings[0]);
        if (handler == null) {
            return new IProject[0];
        }
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        HashMap<IProject, String> project2reference = new HashMap<IProject, String>();
        int i = 0;
        while (i < referenceStrings.length) {
            String name = handler.getProjectNameForReference(referenceStrings[i]);
            if (name != null) {
                project2reference.put(root.getProject(name), referenceStrings[i]);
            }
            ++i;
        }
        Set allProjects = project2reference.keySet();
        IProject[] projects = this.confirmOverwrite(context, allProjects.toArray(new IProject[allProjects.size()]));
        if (projects != null && projects.length > 0) {
            CompositeOperation op = new CompositeOperation("Operation_ImportProjectSet", SVNMessages.class);
            op.add(new SaveRepositoryLocationsOperation());
            ArrayList<IProject> retVal = new ArrayList<IProject>();
            int i2 = 0;
            while (i2 < projects.length) {
                String fullReference = (String)project2reference.get(projects[i2]);
                IProject project = handler.configureCheckoutOperation(op, projects[i2], fullReference);
                if (project != null) {
                    retVal.add(project);
                }
                ++i2;
            }
            projects = retVal.toArray(new IProject[retVal.size()]);
            op.add(new RefreshResourcesOperation((IResource[])projects));
            SVNTeamPlugin.instance().getOptionProvider().addProjectSetCapabilityProcessing(op);
            ProgressMonitorUtility.doTaskExternal(op, monitor);
        }
        return projects;
    }

    public static IProjectSetHandler getProjectSetHandler(String referenceString) {
        if (DEFAULT_HANDLER.accept(referenceString)) {
            return DEFAULT_HANDLER;
        }
        if (SUBCLIPSE_HANDLER.accept(referenceString)) {
            return SUBCLIPSE_HANDLER;
        }
        return null;
    }
}

