/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.revision.graph.graphic.actions;

import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.team.svn.core.connector.SVNRevision;
import org.eclipse.team.svn.core.operation.IActionOperation;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.core.utility.SVNUtility;
import org.eclipse.team.svn.revision.graph.graphic.actions.BaseRevisionGraphAction;
import org.eclipse.team.svn.revision.graph.graphic.editpart.RevisionEditPart;
import org.eclipse.team.svn.ui.SVNUIMessages;
import org.eclipse.team.svn.ui.wizard.CreatePatchWizard;
import org.eclipse.ui.IWorkbenchPart;

public class CreatePatchAction
extends BaseRevisionGraphAction {
    public static final String CreatePatchAction_ID = "CreatePatch";

    public CreatePatchAction(IWorkbenchPart part) {
        super(part);
        this.setText(SVNUIMessages.CreatePatchCommand_label);
        this.setId(CreatePatchAction_ID);
        this.setToolTipText(SVNUIMessages.CreatePatchCommand_label);
    }

    protected boolean calculateEnabled() {
        if (this.isEnable(BaseRevisionGraphAction.EXIST_IN_PREVIOUS_FILTER, 1)) {
            return true;
        }
        RevisionEditPart[] editParts = this.getSelectedEditParts(BaseRevisionGraphAction.NOT_DELETED_ACTION_FILTER);
        return editParts.length == 2 && editParts[0].getCastedModel().getPath().equals(editParts[1].getCastedModel().getPath());
    }

    public void run() {
        IRepositoryResource[] resources = BaseRevisionGraphAction.convertToResources(this.getSelectedEditParts());
        CreatePatchWizard wizard = new CreatePatchWizard(resources[0].getName());
        WizardDialog dialog = new WizardDialog(this.getWorkbenchPart().getSite().getShell(), (IWizard)wizard);
        if (dialog.open() == 0) {
            IRepositoryResource next = resources[0];
            IRepositoryResource prev = null;
            if (resources.length == 1) {
                prev = SVNUtility.copyOf((IRepositoryResource)next);
                prev.setSelectedRevision((SVNRevision)SVNRevision.fromNumber((long)(((SVNRevision.Number)next.getSelectedRevision()).getNumber() - 1L)));
                prev.setPegRevision(next.getPegRevision());
            } else {
                prev = resources[1];
                if (((SVNRevision.Number)next.getSelectedRevision()).getNumber() < ((SVNRevision.Number)prev.getSelectedRevision()).getNumber()) {
                    IRepositoryResource tmp = next;
                    next = prev;
                    prev = tmp;
                }
            }
            IActionOperation op = org.eclipse.team.svn.ui.action.remote.CreatePatchAction.getCreatePatchOperation((IRepositoryResource)prev, (IRepositoryResource)next, (CreatePatchWizard)wizard);
            this.runOperation(op);
        }
    }
}

