/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.revision.graph.cache;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class MergeInfoStorage {
    protected Map<Long, Set<Long>> mergeInfo = new HashMap<Long, Set<Long>>();

    public MergeInfoStorage() {
    }

    public MergeInfoStorage(byte[] bytes) {
        this.fromBytes(bytes);
    }

    public void addMergeInfo(long mergeTargetRevision, long mergeSourceRevision) {
        Set<Long> revs = this.mergeInfo.get(mergeTargetRevision);
        if (revs == null) {
            revs = new HashSet<Long>();
            this.mergeInfo.put(mergeTargetRevision, revs);
        }
        revs.add(mergeSourceRevision);
    }

    public void addMergeInfo(long mergeTargetRevision, long[] mergeSourceRevisions) {
        Set<Long> revs = this.mergeInfo.get(mergeTargetRevision);
        if (revs == null) {
            revs = new HashSet<Long>();
            this.mergeInfo.put(mergeTargetRevision, revs);
        }
        long[] lArray = mergeSourceRevisions;
        int n = mergeSourceRevisions.length;
        int n2 = 0;
        while (n2 < n) {
            long mergeSourceRevision = lArray[n2];
            revs.add(mergeSourceRevision);
            ++n2;
        }
    }

    public long[] getMergeTargetRevisions() {
        Set<Long> revisions = this.mergeInfo.keySet();
        long[] result = new long[revisions.size()];
        int i = 0;
        for (long revision : revisions) {
            result[i++] = revision;
        }
        return result;
    }

    public long[] getMergeSourceRevisions(long mergeTargetRevision) {
        long[] result;
        Set<Long> revs = this.mergeInfo.get(mergeTargetRevision);
        if (revs != null && !revs.isEmpty()) {
            result = new long[revs.size()];
            int i = 0;
            Iterator<Long> iter = revs.iterator();
            while (iter.hasNext()) {
                result[i++] = iter.next();
            }
        } else {
            result = new long[]{};
        }
        return result;
    }

    protected final void fromBytes(byte[] bytes) {
        try {
            DataInputStream bytesIn = new DataInputStream(new ByteArrayInputStream(bytes));
            int count = bytesIn.readInt();
            int i = 0;
            while (i < count) {
                long targetRev = bytesIn.readLong();
                int sourceCount = bytesIn.readInt();
                HashSet<Long> sourceRevs = new HashSet<Long>(sourceCount);
                this.mergeInfo.put(targetRev, sourceRevs);
                int j = 0;
                while (j < sourceCount) {
                    sourceRevs.add(bytesIn.readLong());
                    ++j;
                }
                ++i;
            }
        }
        catch (IOException iOException) {}
    }

    public byte[] toBytes() {
        try {
            ByteArrayOutputStream byteArray = new ByteArrayOutputStream();
            DataOutputStream bytes = new DataOutputStream(byteArray);
            bytes.writeInt(this.mergeInfo.size());
            for (Map.Entry<Long, Set<Long>> entry : this.mergeInfo.entrySet()) {
                long targetRev = entry.getKey();
                Set<Long> sourceRevs = entry.getValue();
                bytes.writeLong(targetRev);
                bytes.writeInt(sourceRevs.size());
                for (long sourceRev : sourceRevs) {
                    bytes.writeLong(sourceRev);
                }
            }
            return byteArray.toByteArray();
        }
        catch (IOException iOException) {
            return new byte[0];
        }
    }
}

