/*
 * Decompiled with CFR 0.152.
 */
import info.jdictionary.JDictionary;
import info.jdictionary.Plugin;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class SmartHunEngPlugin
implements Plugin {
    JPanel contentPane;
    SearchThread searchThread;
    Prefs prefs = this.loadPrefs();
    GUI gui = new GUI(this.prefs);
    ResultManager resultManager;
    TextAnalyser textAnalyser;

    public SmartHunEngPlugin() {
        this.textAnalyser = new TextAnalyser(this.gui.expressionTypeChooserToolBar);
    }

    public void construct(JPanel contentPane) {
        this.contentPane = contentPane;
    }

    public void start() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SmartHunEngPlugin.this.gui.setHeader(ImageBank.SmartHunEngHeader);
                SmartHunEngPlugin.this.gui.wordToFindLabel.setText(Resources.getString("HungarianWord"));
                SmartHunEngPlugin.this.contentPane.add(SmartHunEngPlugin.this.gui);
                SmartHunEngPlugin.this.contentPane.validate();
            }
        });
        this.gui.findButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SmartHunEngPlugin.this.findButton_actionPerformed(e);
            }
        });
        this.gui.inputTextField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SmartHunEngPlugin.this.find(((JTextField)e.getSource()).getText());
            }
        });
        this.gui.expressionTypeChooserToolBar.huhh.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                URL url = SmartHunEngPlugin.this.getURLForHelpFile();
                if (url != null) {
                    SmartHunEngPlugin.this.gui.loadHtmlToOutputPanel(url, Resources.getString("LoadingExpHelp"), IconBank.hourGlass, Resources.getString("InputMethodHelp"), IconBank.info);
                } else {
                    SmartHunEngPlugin.this.gui.putMessageToOutputPanel(Resources.getString("HelpNotFound"), IconBank.warning);
                }
            }
        });
        this.gui.pasteButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String text = SmartHunEngPlugin.this.gui.getTextFromClipboard();
                if (text == null || text.length() < 1) {
                    SmartHunEngPlugin.this.gui.putMessageToOutputPanel(Resources.getString("NoTextOnClip"), IconBank.warning);
                } else if (text.length() > 50) {
                    SmartHunEngPlugin.this.gui.putMessageToOutputPanel(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(Resources.getString("TooLongText")))).append(" (").append(text.length()).append(Resources.getString("Chars")).append(")"))), IconBank.warning);
                } else {
                    SmartHunEngPlugin.this.gui.inputTextField.setText(text);
                }
            }
        });
    }

    public void stop() {
        System.out.println("Saving prefs file...".concat(String.valueOf(String.valueOf(this))));
        this.savePrefs();
    }

    public ImageIcon getIcon() {
        return null;
    }

    public String toString() {
        return Resources.getString("HunEngPlugin");
    }

    void findButton_actionPerformed(ActionEvent e) {
        String text = this.gui.inputTextField.getText();
        this.find(text);
    }

    void find(final String rawText) {
        if (rawText.length() < 1) {
            this.gui.putMessageToOutputPanel(Resources.getString("NoTextGiven"), IconBank.warning);
            return;
        }
        final String text = this.textAnalyser.analyse(rawText);
        if (text == null) {
            this.gui.putMessageToOutputPanel(Resources.getString("SyntaxError"), IconBank.warning);
            return;
        }
        if (!Buffer.isBufferLoaded()) {
            this.gui.putMessageToOutputPanel(Resources.getString("Caching"), IconBank.hourGlass);
        }
        new Thread(){

            public void run() {
                LineFeed lineFeed = new LineFeed();
                SmartHunEngPlugin.this.resultManager = new ResultManager(true, SmartHunEngPlugin.this.gui, 10000, SmartHunEngPlugin.this.prefs, rawText);
                if (SmartHunEngPlugin.this.searchThread != null && SmartHunEngPlugin.this.searchThread.isAlive()) {
                    SmartHunEngPlugin.this.searchThread.terminate();
                }
                SmartHunEngPlugin.this.searchThread = new SearchThread(SmartHunEngPlugin.this.prefs, lineFeed, 10000, text, SmartHunEngPlugin.this.resultManager, true);
                SmartHunEngPlugin.this.searchThread.start();
                SmartHunEngPlugin.this.gui.putMessageToOutputPanel(Resources.getString("Searching"), IconBank.hourGlass);
            }
        }.start();
    }

    Prefs loadPrefs() {
        return Prefs.loadPrefs(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(JDictionary.getSavedDir()))).append(JDictionary.getFileSeparator()).append(this.toString()).append("_SavedPrefs.obj"))));
    }

    void savePrefs() {
        this.prefs.textFieldContent = this.gui.inputTextField.getText();
        Prefs.savePrefs(this.prefs, String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(JDictionary.getSavedDir()))).append(JDictionary.getFileSeparator()).append(this.toString()).append("_SavedPrefs.obj"))));
    }

    URL getURLForHelpFile() {
        URL url = null;
        try {
            url = new URL(String.valueOf(String.valueOf(new StringBuffer("jar:file:").append(MySelf.getPath()).append("!/").append(Resources.getString("ResourcesDir")).append("/").append(Resources.getString("HelpDir")).append("/").append(JDictionary.getLanguage()).append("/").append(Resources.getString("ExpHelpStartPage")))));
            url.openStream();
        }
        catch (MalformedURLException e) {
            URL uRL = null;
            return uRL;
        }
        catch (IOException e) {
            try {
                url = new URL(String.valueOf(String.valueOf(new StringBuffer("jar:file:").append(MySelf.getPath()).append("!/").append(Resources.getString("ResourcesDir")).append("/").append(Resources.getString("HelpDir")).append("/default/").append(Resources.getString("ExpHelpStartPage")))));
                url.openStream();
            }
            catch (MalformedURLException ex) {
                URL uRL = null;
                return uRL;
            }
            catch (IOException ex) {
                URL uRL = null;
                return uRL;
            }
        }
        return url;
    }
}

