/*
 * Decompiled with CFR 0.152.
 */
package splmm.Actions;

import freemind.modes.MindMapNode;
import freemind.modes.mindmapmode.MindMapController;
import freemind.modes.mindmapmode.MindMapMapModel;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JOptionPane;
import javax.swing.JTree;
import splmm.Actions.AbstractMonitoringAction;
import splmm.BookmarkMindMapNode;
import splmm.Localization.LocalizationSupport;
import splmm.Preferences.SplmmPreferences;
import splmm.SciPloreUtils;
import splmm.Thread.EventSenderThread;

public class AllUpdateMonitoringAction
extends AbstractMonitoringAction {
    JTree tree;

    public AllUpdateMonitoringAction(MindMapController controller) {
        super(LocalizationSupport.message("splmm_monitoringDir_all_update"), controller);
    }

    public AllUpdateMonitoringAction(MindMapController controller, JTree tree) {
        super(LocalizationSupport.message("splmm_monitoringDir_all_update"), controller);
        this.tree = tree;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.selected = this.tree != null ? SciPloreUtils.getMonitoringNodeFromPath(this.tree.getSelectionPath()) : this.controller.getSelected();
        this.updateMonitoringNode();
    }

    public void performAction(MindMapNode node) {
        this.selected = node;
        this.updateMonitoringNode();
    }

    private void updateMonitoringNode() {
        String link = SciPloreUtils.getLink(this.controller.getController(), this.selected.getAttribute(SciPloreUtils.SPLMM_DIRMON_PATH));
        this.directory = new File(link);
        if (!this.directory.exists()) {
            JOptionPane.showMessageDialog(this.controller.getFrame().getJFrame(), LocalizationSupport.message("splmm_monitoringDir_dirNotFound"));
            return;
        }
        this.controller.getFrame().out(LocalizationSupport.message("splmm_monitoringDir_importBookmarks"));
        if (this.isNotUnsavedMapWithRelativePathes()) {
            MindMapMapModel model = (MindMapMapModel)this.selected.getMap();
            model.setAutomaticSaveLock(true);
            this.ExecuteMyTask(new MyTask(), this);
            model.setAutomaticSaveLock(false);
        }
        this.controller.getFrame().out(LocalizationSupport.message("splmm_monitoringDir_pasteBookmarks"));
        this.controller.getSelectedView().getAttributeView().setOptimalColumnWidth();
    }

    private class MyTask
    extends AbstractMonitoringAction.Task {
        private MyTask() {
        }

        @Override
        protected Void doInBackground() throws Exception {
            this.name = "update";
            AllUpdateMonitoringAction.this.newFileCounter = 0;
            AllUpdateMonitoringAction.this.bibTexMap = BookmarkMindMapNode.ReadBibtexFile();
            AllUpdateMonitoringAction.this.newBookmarkNodes = new ArrayList();
            AllUpdateMonitoringAction.this.newFileNodes = new ArrayList();
            AllUpdateMonitoringAction.this.controller = (MindMapController)AllUpdateMonitoringAction.this.selected.getMap().getModeController();
            Map<String, Collection<MindMapNode>> nodesLinkedToMonFiles = AllUpdateMonitoringAction.this.getMonFileLinkedNodes(AllUpdateMonitoringAction.this.controller.getRootNode(), new HashMap<String, Collection<MindMapNode>>());
            if (this.canceled) {
                return null;
            }
            System.out.println();
            List<File> filesFromMonDir = AllUpdateMonitoringAction.this.getMonDirFiles(AllUpdateMonitoringAction.this.directory);
            if (this.canceled) {
                return null;
            }
            List<File> importedFiles = AllUpdateMonitoringAction.this.importNewMonDirFiles(nodesLinkedToMonFiles, filesFromMonDir);
            if (this.canceled) {
                return null;
            }
            if (SplmmPreferences.getAutoImport().booleanValue()) {
                filesFromMonDir = AllUpdateMonitoringAction.this.removeImportedFiles(filesFromMonDir, importedFiles);
                if (this.canceled) {
                    return null;
                }
                AllUpdateMonitoringAction.this.importNewBookMarks(this, filesFromMonDir, nodesLinkedToMonFiles);
                if (this.canceled) {
                    return null;
                }
                AllUpdateMonitoringAction.this.setAllNodesUpToDate(filesFromMonDir, nodesLinkedToMonFiles);
                if (this.canceled) {
                    return null;
                }
            }
            AllUpdateMonitoringAction.this.pasteAllNodes(this);
            new EventSenderThread(SciPloreUtils.EVENT_READ_MON_DIR, "" + AllUpdateMonitoringAction.this.newFileCounter);
            return null;
        }
    }
}

