/*
 * Decompiled with CFR 0.152.
 */
package freemind.modes.mindmapmode.hooks;

import freemind.common.XmlBindingTools;
import freemind.controller.actions.generated.instance.Plugin;
import freemind.controller.actions.generated.instance.PluginAction;
import freemind.controller.actions.generated.instance.PluginMode;
import freemind.controller.actions.generated.instance.PluginRegistration;
import freemind.extensions.HookDescriptorPluginAction;
import freemind.extensions.HookDescriptorRegistration;
import freemind.extensions.HookFactory;
import freemind.extensions.HookFactoryAdapter;
import freemind.extensions.HookInstanciationMethod;
import freemind.extensions.ImportWizard;
import freemind.extensions.MindMapHook;
import freemind.extensions.ModeControllerHook;
import freemind.extensions.NodeHook;
import freemind.main.FreeMindMain;
import freemind.main.Resources;
import freemind.modes.mindmapmode.MindMapController;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Vector;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import org.jibx.runtime.IUnmarshallingContext;

public class MindMapHookFactory
extends HookFactoryAdapter {
    private static final String pluginPrefixRegEx = ".*(accessories(/|\\\\)|)plugins(/|\\\\)[^/\\\\]*";
    private FreeMindMain frame;
    private Logger logger;
    private static HashMap pluginInfo = null;
    private static Vector allPlugins = null;
    private static ImportWizard importWizard = null;
    protected static HashSet allRegistrations;

    public MindMapHookFactory(FreeMindMain frame) {
        this.frame = frame;
        this.logger = frame.getLogger(this.getClass().getName());
        this.allRegistrationInstances = new HashMap();
    }

    @Override
    public Vector getPossibleNodeHooks() {
        return this.searchFor(NodeHook.class, MindMapController.class);
    }

    @Override
    public Vector getPossibleModeControllerHooks() {
        return this.searchFor(ModeControllerHook.class, MindMapController.class);
    }

    private Vector searchFor(Class baseClass, Class mode) {
        this.actualizePlugins();
        Vector<String> returnValue = new Vector<String>();
        String modeName = mode.getPackage().getName();
        for (String label : allPlugins) {
            HookDescriptorPluginAction descriptor = this.getHookDescriptor(label);
            try {
                this.logger.finest("Loading: " + label);
                if (!baseClass.isAssignableFrom(Class.forName(descriptor.getBaseClass()))) continue;
                for (String pmode : descriptor.getModes()) {
                    if (!pmode.equals(modeName)) continue;
                    returnValue.add(label);
                }
            }
            catch (ClassNotFoundException e) {
                this.logger.severe("Class not found.");
                Resources.getInstance().logException(e);
            }
        }
        return returnValue;
    }

    private void actualizePlugins() {
        if (importWizard == null) {
            importWizard = new ImportWizard(this.frame);
            MindMapHookFactory.importWizard.CLASS_LIST.clear();
            importWizard.buildClassList();
            pluginInfo = new HashMap();
            allPlugins = new Vector();
            allRegistrations = new HashSet();
            IUnmarshallingContext unmarshaller = XmlBindingTools.getInstance().createUnmarshaller();
            for (String xmlPluginFile : MindMapHookFactory.importWizard.CLASS_LIST) {
                if (!xmlPluginFile.matches(pluginPrefixRegEx)) continue;
                xmlPluginFile = xmlPluginFile.replace('\\', '/') + MindMapHookFactory.importWizard.lookFor;
                URL pluginURL = this.frame.getFreeMindClassLoader().getResource(xmlPluginFile);
                Plugin plugin = null;
                try {
                    this.logger.finest("Reading: " + xmlPluginFile + " from " + pluginURL);
                    if (pluginURL.getPath().endsWith("build.xml") || pluginURL.getPath().endsWith("build_database.xml") || pluginURL.getPath().endsWith("build_help.xml") || pluginURL.getPath().endsWith("build_import.xml") || pluginURL.getPath().endsWith("build_jabber.xml") || pluginURL.getPath().endsWith("build_latex.xml") || pluginURL.getPath().endsWith("build_scripting.xml") || pluginURL.getPath().endsWith("build_svg.xml")) continue;
                    InputStream in = pluginURL.openStream();
                    plugin = (Plugin)unmarshaller.unmarshalDocument(in, null);
                }
                catch (Exception e) {
                    Resources.getInstance().logException(e);
                    continue;
                }
                for (Object obj : plugin.getListChoiceList()) {
                    if (obj instanceof PluginAction) {
                        PluginAction action = (PluginAction)obj;
                        pluginInfo.put(action.getLabel(), new HookDescriptorPluginAction(this.frame, xmlPluginFile, plugin, action));
                        allPlugins.add(action.getLabel());
                        continue;
                    }
                    if (!(obj instanceof PluginRegistration)) continue;
                    PluginRegistration registration = (PluginRegistration)obj;
                    allRegistrations.add(new HookDescriptorRegistration(this.frame, xmlPluginFile, plugin, registration));
                }
            }
        }
    }

    @Override
    public ModeControllerHook createModeControllerHook(String hookName) {
        HookDescriptorPluginAction descriptor = this.getHookDescriptor(hookName);
        return (ModeControllerHook)this.createJavaHook(hookName, descriptor);
    }

    private MindMapHook createJavaHook(String hookName, HookDescriptorPluginAction descriptor) {
        try {
            ClassLoader loader = descriptor.getPluginClassLoader();
            Class<?> hookClass = Class.forName(descriptor.getClassName(), true, loader);
            MindMapHook hook = (MindMapHook)hookClass.newInstance();
            this.decorateHook(hookName, descriptor, hook);
            return hook;
        }
        catch (Exception e) {
            Resources.getInstance().logException(e, "Error occurred loading hook: " + descriptor.getClassName() + "\nException:");
            return null;
        }
    }

    @Override
    public NodeHook createNodeHook(String hookName) {
        this.logger.finest("CreateNodeHook: " + hookName);
        HookDescriptorPluginAction descriptor = this.getHookDescriptor(hookName);
        return (NodeHook)this.createJavaHook(hookName, descriptor);
    }

    private void decorateHook(String hookName, final HookDescriptorPluginAction descriptor, MindMapHook hook) {
        hook.setProperties(descriptor.getProperties());
        hook.setName(hookName);
        MindMapHook.PluginBaseClassSearcher pluginBaseClassSearcher = new MindMapHook.PluginBaseClassSearcher(){

            @Override
            public Object getPluginBaseObject() {
                return MindMapHookFactory.this.getPluginBaseClass(descriptor);
            }
        };
        hook.setPluginBaseClass(pluginBaseClassSearcher);
    }

    public void decorateAction(String hookName, AbstractAction action) {
        String key;
        String icon;
        HookDescriptorPluginAction descriptor = this.getHookDescriptor(hookName);
        String name = descriptor.getName();
        if (name != null) {
            action.putValue("Name", name);
        } else {
            action.putValue("Name", descriptor.getClassName());
        }
        String docu = descriptor.getDocumentation();
        if (docu != null) {
            action.putValue("ShortDescription", docu);
            action.putValue("LongDescription", docu);
        }
        if ((icon = descriptor.getIconPath()) != null) {
            ImageIcon imageIcon = new ImageIcon(descriptor.getPluginClassLoader().getResource(icon));
            action.putValue("SmallIcon", imageIcon);
        }
        if ((key = descriptor.getKeyStroke()) != null) {
            action.putValue("AcceleratorKey", KeyStroke.getKeyStroke(key));
        }
    }

    @Override
    public List getHookMenuPositions(String hookName) {
        HookDescriptorPluginAction descriptor = this.getHookDescriptor(hookName);
        return descriptor.menuPositions;
    }

    @Override
    public HookInstanciationMethod getInstanciationMethod(String hookName) {
        HookDescriptorPluginAction descriptor = this.getHookDescriptor(hookName);
        return descriptor.getInstanciationMethod();
    }

    @Override
    public List getRegistrations() {
        Class<MindMapController> mode = MindMapController.class;
        this.actualizePlugins();
        Vector<HookFactory.RegistrationContainer> returnValue = new Vector<HookFactory.RegistrationContainer>();
        System.out.println("Size: " + allRegistrations.size());
        for (HookDescriptorRegistration descriptor : allRegistrations) {
            boolean modeFound = false;
            for (PluginMode possibleMode : descriptor.getListPluginModeList()) {
                if (!mode.getPackage().getName().equals(possibleMode.getClassName())) continue;
                modeFound = true;
            }
            if (!modeFound) continue;
            try {
                Plugin plugin = descriptor.getPluginBase();
                ClassLoader loader = descriptor.getPluginClassLoader();
                Class<?> hookRegistrationClass = Class.forName(descriptor.getClassName(), true, loader);
                HookFactory.RegistrationContainer container = new HookFactory.RegistrationContainer();
                container.hookRegistrationClass = hookRegistrationClass;
                container.correspondingPlugin = plugin;
                container.isPluginBase = descriptor.getIsPluginBase();
                returnValue.add(container);
            }
            catch (ClassNotFoundException e) {
                Resources.getInstance().logException(e);
            }
        }
        return returnValue;
    }

    @Override
    public Object getPluginBaseClass(String hookName) {
        this.logger.finest("getPluginBaseClass: " + hookName);
        HookDescriptorPluginAction descriptor = this.getHookDescriptor(hookName);
        return this.getPluginBaseClass(descriptor);
    }

    private Object getPluginBaseClass(HookDescriptorPluginAction descriptor) {
        Object baseClass = null;
        String label = descriptor.getPluginBase().getLabel();
        if (this.allRegistrationInstances.containsKey(label)) {
            baseClass = this.allRegistrationInstances.get(label);
        }
        return baseClass;
    }

    private HookDescriptorPluginAction getHookDescriptor(String hookName) {
        HookDescriptorPluginAction descriptor = (HookDescriptorPluginAction)pluginInfo.get(hookName);
        if (hookName == null || descriptor == null) {
            throw new IllegalArgumentException("Unknown hook name " + hookName);
        }
        return descriptor;
    }

    public JMenuItem getMenuItem(String pHookName, AbstractAction pHookAction) {
        HookDescriptorPluginAction descriptor = this.getHookDescriptor(pHookName);
        if (descriptor.isSelectable()) {
            return new JCheckBoxMenuItem(pHookAction);
        }
        return new JMenuItem(pHookAction);
    }
}

