/*
 * Decompiled with CFR 0.152.
 */
package org.sciplore.resources;

import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import org.hibernate.Session;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;
import org.sciplore.resources.MindmapNode;
import org.sciplore.resources.Resource;

@Entity
@Table(name="mindmap_attributes")
public class MindmapAttribute
extends Resource {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Integer id;
    @ManyToOne
    @JoinColumn(name="node_id")
    @Cascade(value={CascadeType.SAVE_UPDATE})
    private MindmapNode mindmapNode;
    private String attributeName;
    private String attributeValue;
    private String elementName;
    private String elementContent;

    public MindmapAttribute() {
    }

    public MindmapAttribute(Session s) {
        this.setSession(s);
    }

    public void create(MindmapNode node, String attributeName, String attributeValue, String elementName, String elementContent) {
        this.setMindmapNode(node);
        this.setAttributeName(attributeName);
        this.setAttributeValue(attributeValue);
        this.setElementName(elementName);
        this.setElementContent(elementContent);
        this.save();
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public MindmapNode getMindmapNode() {
        return this.mindmapNode;
    }

    public void setMindmapNode(MindmapNode mindmapNode) {
        this.mindmapNode = mindmapNode;
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    public void setAttributeName(String attributeName) {
        this.attributeName = attributeName;
    }

    public String getAttributeValue() {
        return this.attributeValue;
    }

    public void setAttributeValue(String attributeValue) {
        this.attributeValue = attributeValue;
    }

    public String getElementName() {
        return this.elementName;
    }

    public void setElementName(String elementName) {
        this.elementName = elementName;
    }

    public String getElementContent() {
        return this.elementContent;
    }

    public void setElementContent(String elementContent) {
        this.elementContent = elementContent;
    }
}

