/*
 * Decompiled with CFR 0.152.
 */
package spl;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.multipart.FormDataMultiPart;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import javax.ws.rs.core.MediaType;
import javax.xml.bind.JAXB;
import org.sciplore.xml.XmlApplication;
import org.sciplore.xml.XmlDocuments;
import spl.Tools;

public class SplWebClient {
    private static Client CLIENT = Client.create();
    private static WebResource WEBRESOURCE;
    private static WebResource INTERNETRESOURCE;
    public static XmlDocuments metadata;

    public static WebServiceStatus getMetaData(File file) {
        try {
            if (!SplWebClient.isWebServiceAvailable()) {
                if (SplWebClient.isInternetAvailable()) {
                    return WebServiceStatus.WEBSERVICE_DOWN;
                }
                return WebServiceStatus.NO_INTERNET;
            }
            if (SplWebClient.isWebServiceOutDated()) {
                return WebServiceStatus.OUTDATED;
            }
            if (!SplWebClient.isMetaDataServiceAvailable()) {
                return WebServiceStatus.UNAVAILABLE;
            }
            byte[] data = Tools.zip(file);
            FormDataMultiPart formDataMultiPart = new FormDataMultiPart();
            formDataMultiPart.field("gzippedpdf", (Object)data, MediaType.APPLICATION_OCTET_STREAM_TYPE);
            ClientResponse response = (ClientResponse)WEBRESOURCE.path("service/metadata").type(MediaType.MULTIPART_FORM_DATA_TYPE).post(ClientResponse.class, (Object)formDataMultiPart);
            if (response.getClientResponseStatus() == ClientResponse.Status.OK && response.hasEntity()) {
                String entity = (String)response.getEntity(String.class);
                byte[] bytes = new byte[]{};
                try {
                    bytes = entity.getBytes("UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    return null;
                }
                ByteArrayInputStream is = new ByteArrayInputStream(bytes);
                if (is != null) {
                    XmlDocuments documents;
                    metadata = documents = (XmlDocuments)JAXB.unmarshal((InputStream)is, XmlDocuments.class);
                    return WebServiceStatus.OK;
                }
                return WebServiceStatus.NO_METADATA;
            }
            if (response.getClientResponseStatus() == ClientResponse.Status.SERVICE_UNAVAILABLE) {
                return WebServiceStatus.UNAVAILABLE;
            }
        }
        catch (Exception e) {
            System.out.println(Tools.getStackTraceAsString(e));
        }
        return WebServiceStatus.NO_METADATA;
    }

    public static boolean isWebServiceOutDated() {
        try {
            XmlApplication app;
            String entity;
            byte[] bytes;
            ByteArrayInputStream is;
            ClientResponse response = (ClientResponse)WEBRESOURCE.path("service/versioncheck/" + Tools.WEBSERVICE_APP_ID + "/current").get(ClientResponse.class);
            if (response.getClientResponseStatus() == ClientResponse.Status.OK && response.hasEntity() && (is = new ByteArrayInputStream(bytes = (entity = (String)response.getEntity(String.class)).getBytes())) != null && (app = (XmlApplication)JAXB.unmarshal((InputStream)is, XmlApplication.class)) != null && app.getVersion() != null && !app.getVersion().equalsIgnoreCase(Tools.WEBSERVICE_VERSION_SHORT)) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static boolean isMetaDataServiceAvailable() {
        try {
            String entity;
            ClientResponse response = (ClientResponse)WEBRESOURCE.path("service/metadata/available").get(ClientResponse.class);
            if (response.getClientResponseStatus() == ClientResponse.Status.OK && response.hasEntity() && (entity = (String)response.getEntity(String.class)) != null && entity.equalsIgnoreCase("false")) {
                return false;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    public static boolean isWebServiceAvailable() {
        try {
            ClientResponse response = (ClientResponse)WEBRESOURCE.path("service/metadata/available").get(ClientResponse.class);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static boolean isInternetAvailable() {
        try {
            ClientResponse response = (ClientResponse)INTERNETRESOURCE.get(ClientResponse.class);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    static {
        CLIENT.setConnectTimeout(Integer.valueOf(1000));
        CLIENT.setReadTimeout(Integer.valueOf(70000));
        WEBRESOURCE = CLIENT.resource("http://api.mr-dlib.org/rest/");
        INTERNETRESOURCE = CLIENT.resource("http://www.google.com");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum WebServiceStatus {
        OK,
        NO_METADATA,
        UNAVAILABLE,
        OUTDATED,
        WEBSERVICE_DOWN,
        NO_INTERNET;

    }
}

