/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.wizard.auximport.gui;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import net.sf.jabref.BasePanel;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRef;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.gui.FileDialogs;
import net.sf.jabref.wizard.auximport.AuxSubGenerator;
import net.sf.jabref.wizard.auximport.gui.FromAuxDialog_Cancel_actionAdapter;
import net.sf.jabref.wizard.auximport.gui.FromAuxDialog_generate_actionAdapter;
import net.sf.jabref.wizard.auximport.gui.FromAuxDialog_ok_actionAdapter;

public class FromAuxDialog
extends JDialog {
    private JPanel statusPanel = new JPanel();
    private JPanel buttons = new JPanel();
    private JButton okButton = new JButton();
    private JButton cancelButton = new JButton();
    private JButton generateButton = new JButton();
    private JComboBox dbChooser = new JComboBox();
    private JTextField auxFileField;
    private JButton browseAuxFileButton;
    private JList notFoundList;
    private JTextArea statusInfos;
    private JTabbedPane parentTabbedPane;
    private boolean okPressed = false;
    private AuxSubGenerator auxParser;

    public FromAuxDialog(JabRefFrame frame, String title, boolean modal, JTabbedPane viewedDBs) {
        super(frame, title, modal);
        this.parentTabbedPane = viewedDBs;
        this.auxParser = new AuxSubGenerator(null);
        try {
            this.jbInit(frame);
            this.pack();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void jbInit(JabRefFrame parent) {
        JPanel panel1 = new JPanel();
        panel1.setLayout(new BorderLayout());
        this.okButton.setText(Globals.lang("Ok"));
        this.okButton.setEnabled(false);
        this.okButton.addActionListener(new FromAuxDialog_ok_actionAdapter(this));
        this.cancelButton.setText(Globals.lang("Cancel"));
        this.cancelButton.addActionListener(new FromAuxDialog_Cancel_actionAdapter(this));
        this.generateButton.setText(Globals.lang("Generate"));
        this.generateButton.addActionListener(new FromAuxDialog_generate_actionAdapter(this));
        this.initOptionsPanel(parent);
        this.initStatusPanel();
        ButtonBarBuilder bb = new ButtonBarBuilder();
        JPanel buttonPanel = bb.getPanel();
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        bb.addGlue();
        bb.addGridded(this.generateButton);
        bb.addGridded(this.okButton);
        bb.addGridded(this.cancelButton);
        bb.addGlue();
        this.setModal(true);
        this.setResizable(false);
        this.setTitle(Globals.lang("AUX file import"));
        this.getContentPane().add(panel1);
        JPanel desc = this.getDescriptionPanel();
        if (desc != null) {
            panel1.add((Component)desc, "North");
            panel1.add((Component)buttonPanel, "South");
            JPanel centerPane = new JPanel(new BorderLayout());
            centerPane.add((Component)this.buttons, "North");
            centerPane.add((Component)this.statusPanel, "Center");
            panel1.add((Component)centerPane, "Center");
        } else {
            panel1.add((Component)this.buttons, "North");
            panel1.add((Component)buttonPanel, "South");
            panel1.add((Component)this.statusPanel, "Center");
        }
        ActionMap am = this.statusPanel.getActionMap();
        InputMap im = this.statusPanel.getInputMap(2);
        im.put(parent.prefs().getKey("Close dialog"), "close");
        am.put("close", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                FromAuxDialog.this.dispose();
            }
        });
    }

    private void initOptionsPanel(JabRefFrame parent) {
        int len = this.parentTabbedPane.getTabCount();
        for (int t = 0; t < len; ++t) {
            this.dbChooser.addItem(this.parentTabbedPane.getTitleAt(t));
        }
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints con = new GridBagConstraints();
        con.weightx = 0.0;
        con.insets = new Insets(5, 10, 0, 10);
        con.fill = 2;
        TitledBorder border = new TitledBorder(BorderFactory.createLineBorder(new Color(153, 153, 153), 2), Globals.lang("Options"));
        this.buttons.setBorder(border);
        this.buttons.setLayout(gbl);
        JLabel lab1 = new JLabel(Globals.lang("Reference database") + ":");
        lab1.setHorizontalAlignment(2);
        gbl.setConstraints(lab1, con);
        this.buttons.add(lab1);
        con.gridwidth = 0;
        gbl.setConstraints(this.dbChooser, con);
        this.buttons.add(this.dbChooser);
        con.gridwidth = 1;
        con.weightx = 0.0;
        con.insets = new Insets(5, 10, 15, 10);
        con.fill = 1;
        lab1 = new JLabel(Globals.lang("LaTeX AUX file") + ":");
        lab1.setHorizontalAlignment(2);
        gbl.setConstraints(lab1, con);
        this.buttons.add(lab1);
        con.weightx = 1.0;
        this.auxFileField = new JTextField("", 25);
        gbl.setConstraints(this.auxFileField, con);
        this.buttons.add(this.auxFileField);
        con.weightx = 0.0;
        con.insets = new Insets(5, 10, 15, 2);
        this.browseAuxFileButton = new JButton(Globals.lang("Browse"));
        this.browseAuxFileButton.addActionListener(new BrowseAction(this.auxFileField, parent));
        gbl.setConstraints(this.browseAuxFileButton, con);
        this.buttons.add(this.browseAuxFileButton);
    }

    private void initStatusPanel() {
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints con = new GridBagConstraints();
        con.weightx = 0.0;
        con.insets = new Insets(5, 10, 0, 10);
        con.fill = 2;
        TitledBorder titledBorder1 = new TitledBorder(BorderFactory.createLineBorder(new Color(153, 153, 153), 2), Globals.lang("Results"));
        this.statusPanel.setLayout(gbl);
        this.statusPanel.setBorder(titledBorder1);
        JLabel lab1 = new JLabel(Globals.lang("Unknown bibtex entries") + ":");
        lab1.setHorizontalAlignment(2);
        con.gridwidth = 1;
        gbl.setConstraints(lab1, con);
        this.statusPanel.add(lab1);
        lab1 = new JLabel(Globals.lang("Messages") + ":");
        lab1.setHorizontalAlignment(2);
        con.gridwidth = 0;
        gbl.setConstraints(lab1, con);
        this.statusPanel.add(lab1);
        this.notFoundList = new JList();
        JScrollPane listScrollPane = new JScrollPane(this.notFoundList);
        listScrollPane.setPreferredSize(new Dimension(250, 120));
        con.gridwidth = 1;
        con.weightx = 0.0;
        con.gridheight = 2;
        con.insets = new Insets(5, 10, 15, 10);
        con.fill = 1;
        gbl.setConstraints(listScrollPane, con);
        this.statusPanel.add(listScrollPane);
        this.statusInfos = new JTextArea("", 5, 20);
        this.statusInfos.setBorder(BorderFactory.createEtchedBorder());
        this.statusInfos.setEditable(false);
        con.gridheight = 1;
        gbl.setConstraints(this.statusInfos, con);
        this.statusPanel.add(this.statusInfos);
    }

    private JPanel getDescriptionPanel() {
        JPanel back = null;
        JEditorPane infoText = null;
        URL infoURL = JabRef.class.getResource(GUIGlobals.getLocaleHelpPath() + GUIGlobals.shortAuxImport);
        if (infoURL != null) {
            try {
                infoText = new JEditorPane();
                infoText.setEditable(false);
                infoText.setPreferredSize(new Dimension(240, 50));
                infoText.setMinimumSize(new Dimension(180, 50));
                infoText.setPage(infoURL);
                infoText.setBackground(GUIGlobals.infoField);
                infoText.setBorder(new EtchedBorder(1));
                back = new JPanel();
                back.setLayout(new BorderLayout());
                back.add((Component)infoText, "First");
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        return back;
    }

    void ok_actionPerformed(ActionEvent e) {
        this.okPressed = true;
        this.dispose();
    }

    void Cancel_actionPerformed(ActionEvent e) {
        this.dispose();
    }

    void generate_actionPerformed(ActionEvent e) {
        this.generateButton.setEnabled(false);
        BasePanel bp = (BasePanel)this.parentTabbedPane.getComponentAt(this.dbChooser.getSelectedIndex());
        this.notFoundList.removeAll();
        this.statusInfos.setText(null);
        BibtexDatabase refBase = bp.getDatabase();
        String auxName = this.auxFileField.getText();
        if (auxName != null && refBase != null && auxName.length() > 0) {
            this.auxParser.clear();
            this.notFoundList.setListData(this.auxParser.generate(auxName, refBase));
            this.statusInfos.append(Globals.lang("keys in database") + " " + refBase.getEntryCount());
            this.statusInfos.append("\n" + Globals.lang("found in aux file") + " " + this.auxParser.getFoundKeysInAux());
            this.statusInfos.append("\n" + Globals.lang("resolved") + " " + this.auxParser.getResolvedKeysCount());
            this.statusInfos.append("\n" + Globals.lang("not found") + " " + this.auxParser.getNotResolvedKeysCount());
            this.statusInfos.append("\n" + Globals.lang("crossreferenced entries included") + " " + this.auxParser.getCrossreferencedEntriesCount());
            int nested = this.auxParser.getNestedAuxCounter();
            if (nested > 0) {
                this.statusInfos.append("\n" + Globals.lang("nested_aux_files") + " " + nested);
            }
            this.okButton.setEnabled(true);
        }
        if (this.auxParser.getGeneratedDatabase().getEntryCount() < 1) {
            this.statusInfos.append("\n" + Globals.lang("empty database"));
            this.okButton.setEnabled(false);
        }
        this.generateButton.setEnabled(true);
    }

    public boolean okPressed() {
        return this.okPressed;
    }

    public BibtexDatabase getGenerateDB() {
        return this.auxParser.getGeneratedDatabase();
    }

    class BrowseAction
    extends AbstractAction {
        private JTextField comp;
        private JabRefFrame _frame;

        public BrowseAction(JTextField tc, JabRefFrame frame) {
            super(Globals.lang("Browse"));
            this._frame = frame;
            this.comp = tc;
        }

        public void actionPerformed(ActionEvent e) {
            String chosen = null;
            chosen = FileDialogs.getNewFile(this._frame, new File(this.comp.getText()), ".aux", 0, false);
            if (chosen != null) {
                File newFile = new File(chosen);
                this.comp.setText(newFile.getPath());
            }
        }
    }
}

