/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.imports;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JPanel;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.Globals;
import net.sf.jabref.OutputPrinter;
import net.sf.jabref.imports.BibsonomyScraper;
import net.sf.jabref.imports.EntryFetcher;
import net.sf.jabref.imports.ImportInspector;
import net.sf.jabref.net.URLDownload;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScienceDirectFetcher
implements EntryFetcher {
    protected static int MAX_PAGES_TO_LOAD = 8;
    protected static final String WEBSITE_URL = "http://www.sciencedirect.com";
    protected static final String SEARCH_URL = "http://www.sciencedirect.com/science/quicksearch?query=";
    protected static final String linkPrefix = "http://www.sciencedirect.com/science?_ob=ArticleURL&";
    protected static final Pattern linkPattern = Pattern.compile("<a href=\"" + "http://www.sciencedirect.com/science?_ob=ArticleURL&".replaceAll("\\?", "\\\\?") + "([^\"]+)\"\"");
    protected static final Pattern nextPagePattern = Pattern.compile("<a href=\"(.*)\">Next &gt;");
    protected boolean stopFetching = false;
    protected boolean noAccessFound = false;

    @Override
    public String getHelpPage() {
        return "ScienceDirect.html";
    }

    @Override
    public URL getIcon() {
        return GUIGlobals.getIconUrl("www");
    }

    @Override
    public String getKeyName() {
        return "Search ScienceDirect";
    }

    @Override
    public JPanel getOptionsPanel() {
        return null;
    }

    @Override
    public String getTitle() {
        return Globals.menuTitle("Search ScienceDirect");
    }

    @Override
    public void stopFetching() {
        this.stopFetching = true;
        this.noAccessFound = false;
    }

    @Override
    public boolean processQuery(String query, ImportInspector dialog, OutputPrinter status) {
        this.stopFetching = false;
        try {
            List<String> citations = this.getCitations(query);
            if (citations == null) {
                return false;
            }
            if (citations.size() == 0) {
                status.showMessage(Globals.lang("No entries found for the search string '%0'", query), Globals.lang("Search ScienceDirect"), 1);
                return false;
            }
            int i = 0;
            for (String cit : citations) {
                if (this.stopFetching) break;
                BibtexEntry entry = BibsonomyScraper.getEntry(cit);
                if (entry != null) {
                    dialog.addEntry(entry);
                }
                dialog.setProgress(++i, citations.size());
            }
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            status.showMessage(Globals.lang("Error while fetching from ScienceDirect") + ": " + e.getMessage());
            return false;
        }
    }

    protected List<String> getCitations(String query) throws IOException {
        ArrayList<String> ids = new ArrayList<String>();
        try {
            String urlQuery = SEARCH_URL + URLEncoder.encode(query, "UTF-8");
            String nextPage = null;
            for (int count = 1; (nextPage = this.getCitationsFromUrl(urlQuery, ids)) != null && count < MAX_PAGES_TO_LOAD; ++count) {
                urlQuery = nextPage;
            }
            return ids;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    protected String getCitationsFromUrl(String urlQuery, List<String> ids) throws IOException {
        URL url = new URL(urlQuery);
        URLDownload ud = new URLDownload(url);
        ud.download();
        String cont = ud.getStringContent();
        Matcher m = linkPattern.matcher(cont);
        if (m.find()) {
            while (m.find()) {
                ids.add(linkPrefix + m.group(1));
                cont = cont.substring(m.end());
                m = linkPattern.matcher(cont);
            }
        } else {
            return null;
        }
        return null;
    }
}

