/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.imports;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeSet;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.Globals;
import net.sf.jabref.Util;
import net.sf.jabref.imports.ImportFormatReader;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MedlineHandler
extends DefaultHandler {
    ArrayList<BibtexEntry> bibitems = new ArrayList();
    boolean inTitle = false;
    boolean inYear = false;
    boolean inJournal = false;
    boolean inMonth = false;
    boolean inVolume = false;
    boolean inAuthorList = false;
    boolean inAuthor = false;
    boolean inLastName = false;
    boolean inInitials = false;
    boolean inMedlinePgn = false;
    boolean inMedlineID = false;
    boolean inURL = false;
    boolean inIssue = false;
    boolean inPubDate = false;
    boolean inUrl = false;
    boolean inForename = false;
    boolean inAbstractText = false;
    boolean inMedlineDate = false;
    boolean inPubMedID = false;
    boolean inDescriptorName = false;
    boolean inDoi = false;
    boolean inPii = false;
    boolean inAffiliation = false;
    boolean inMeshHeader = false;
    boolean inQualifierName = false;
    boolean inLanguage = false;
    boolean inPst = false;
    String title = "";
    String journal = "";
    String keywords = "";
    String author = "";
    String lastName = "";
    String year = "";
    String forename = "";
    String abstractText = "";
    String affiliation = "";
    String month = "";
    String volume = "";
    String lastname = "";
    String initials = "";
    String number = "";
    String page = "";
    String medlineID = "";
    String url = "";
    String MedlineDate = "";
    String series = "";
    String editor = "";
    String booktitle = "";
    String type = "article";
    String key = "";
    String address = "";
    String pubmedid = "";
    String doi = "";
    String pii = "";
    String majorTopic = "";
    String minorTopics = "";
    String language = "";
    String pst = "";
    ArrayList<String> authors = new ArrayList();
    TreeSet<String> descriptors = new TreeSet();
    int rowNum = 0;
    private static final String KEYWORD_SEPARATOR = "; ";

    public ArrayList<BibtexEntry> getItems() {
        return this.bibitems;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) {
        if (!localName.equals("PubmedArticle")) {
            if (localName.equals("ArticleTitle")) {
                this.inTitle = true;
                this.title = "";
            } else if (localName.equals("PubDate")) {
                this.inPubDate = true;
            } else if (localName.equals("Year") && this.inPubDate) {
                this.inYear = true;
            } else if (localName.equals("MedlineDate") && this.inPubDate) {
                this.inMedlineDate = true;
            } else if (localName.equals("MedlineTA")) {
                this.inJournal = true;
                this.journal = "";
            } else if (localName.equals("Month") && this.inPubDate) {
                this.inMonth = true;
            } else if (localName.equals("Volume")) {
                this.inVolume = true;
            } else if (localName.equals("Language")) {
                this.inLanguage = true;
            } else if (localName.equals("PublicationStatus")) {
                this.inPst = true;
            } else if (localName.equals("AuthorList")) {
                this.inAuthorList = true;
                this.authors.clear();
            } else if (localName.equals("MeshHeading")) {
                this.inMeshHeader = true;
                this.majorTopic = "";
                this.minorTopics = "";
            } else if (localName.equals("DescriptorName")) {
                this.inDescriptorName = true;
            } else if (localName.equals("QualifierName")) {
                this.inQualifierName = true;
            } else if (localName.equals("Author")) {
                this.inAuthor = true;
                this.author = "";
            } else if (localName.equals("CollectiveName")) {
                this.inForename = true;
                this.forename = "";
            } else if (localName.equals("PMID")) {
                if (this.pubmedid.length() == 0) {
                    this.inPubMedID = true;
                    this.pubmedid = "";
                }
            } else if (localName.equals("LastName")) {
                this.inLastName = true;
                this.lastName = "";
            } else if (localName.equals("ForeName") || localName.equals("FirstName")) {
                this.inForename = true;
                this.forename = "";
            } else if (localName.equals("Issue")) {
                this.inIssue = true;
            } else if (localName.equals("MedlinePgn")) {
                this.inMedlinePgn = true;
            } else if (localName.equals("URL")) {
                this.inUrl = true;
            } else if (localName.equals("Initials")) {
                this.inInitials = true;
            } else if (localName.equals("AbstractText")) {
                this.inAbstractText = true;
            } else if (localName.equals("ArticleId")) {
                for (int i = 0; i < atts.getLength(); ++i) {
                    String value = atts.getValue(i);
                    if (value.equals("doi")) {
                        this.inDoi = true;
                        continue;
                    }
                    if (!value.equals("pii")) continue;
                    this.inPii = true;
                }
            } else if (localName.equals("Affiliation")) {
                this.inAffiliation = true;
            }
        }
    }

    String join(Object[] sa, String delim) {
        StringBuffer sb = new StringBuffer();
        sb.append(sa[0].toString());
        for (int i = 1; i < sa.length; ++i) {
            sb.append(delim);
            sb.append(sa[i].toString());
        }
        return sb.toString();
    }

    String makeBibtexString() {
        String out = "";
        out = "article{,\n author = { " + this.author + " },\n title = { " + this.title + "},\n journal ={ " + this.journal + "},\n year = " + this.year + "},\n volume = { " + this.volume + "},\n number = { " + this.number + "},\n pages = { " + this.fixPageRange(this.page) + "},\n abstract = { " + this.abstractText + "},\n}";
        return out;
    }

    @Override
    public void endElement(String uri, String localName, String qName) {
        if (localName.equals("PubmedArticle")) {
            if (this.year.equals("") && !this.MedlineDate.equals("")) {
                this.year = this.MedlineDate.substring(0, 4);
            }
            StringBuffer sb = new StringBuffer();
            Iterator<String> iterator = this.descriptors.iterator();
            while (iterator.hasNext()) {
                String s = iterator.next();
                sb.append(s);
                if (!iterator.hasNext()) continue;
                sb.append(KEYWORD_SEPARATOR);
            }
            this.keywords = sb.toString();
            BibtexEntry b = new BibtexEntry(Util.createNeutralId(), Globals.getEntryType("article"));
            if (!this.author.equals("")) {
                b.setField("author", ImportFormatReader.expandAuthorInitials(this.author));
                this.author = "";
            }
            if (!this.title.equals("")) {
                b.setField("title", this.title);
            }
            if (!this.journal.equals("")) {
                b.setField("journal", this.journal);
            }
            if (!this.year.equals("")) {
                b.setField("year", this.year);
            }
            if (!this.page.equals("")) {
                b.setField("pages", this.fixPageRange(this.page));
            }
            if (!this.volume.equals("")) {
                b.setField("volume", this.volume);
            }
            if (!this.language.equals("")) {
                b.setField("language", this.language);
            }
            if (!this.pst.equals("")) {
                b.setField("medline-pst", this.pst);
            }
            if (!this.abstractText.equals("")) {
                b.setField("abstract", this.abstractText.replaceAll("%", "\\\\%"));
            }
            if (!this.keywords.equals("")) {
                b.setField("keywords", this.keywords);
            }
            if (!this.month.equals("")) {
                b.setField("month", this.month);
            }
            if (!this.number.equals("")) {
                b.setField("number", this.number);
            }
            if (!this.doi.equals("")) {
                b.setField("doi", this.doi);
                b.setField("url", "http://dx.doi.org/" + this.doi);
            }
            if (!this.pii.equals("")) {
                b.setField("pii", this.pii);
            }
            if (!this.affiliation.equals("")) {
                b.setField("institution", this.affiliation.replaceAll("#", "\\\\#"));
            }
            if (!this.pubmedid.equals("")) {
                b.setField("pmid", this.pubmedid);
            }
            this.bibitems.add(b);
            this.abstractText = "";
            this.author = "";
            this.title = "";
            this.journal = "";
            this.keywords = "";
            this.doi = "";
            this.pii = "";
            this.year = "";
            this.forename = "";
            this.lastName = "";
            this.abstractText = "";
            this.affiliation = "";
            this.pubmedid = "";
            this.majorTopic = "";
            this.minorTopics = "";
            this.month = "";
            this.volume = "";
            this.language = "";
            this.pst = "";
            this.lastname = "";
            this.initials = "";
            this.number = "";
            this.page = "";
            this.medlineID = "";
            this.url = "";
            this.MedlineDate = "";
            this.descriptors.clear();
        } else if (localName.equals("ArticleTitle")) {
            this.inTitle = false;
        } else if (localName.equals("PubDate")) {
            this.inPubDate = false;
        } else if (localName.equals("Year")) {
            this.inYear = false;
        } else if (localName.equals("PMID")) {
            this.inPubMedID = false;
        } else if (localName.equals("MedlineDate")) {
            this.inMedlineDate = false;
        } else if (localName.equals("MedlineTA")) {
            this.inJournal = false;
        } else if (localName.equals("Month")) {
            this.inMonth = false;
        } else if (localName.equals("Volume")) {
            this.inVolume = false;
        } else if (localName.equals("Language")) {
            this.inLanguage = false;
        } else if (localName.equals("PublicationStatus")) {
            this.inPst = false;
        } else if (localName.equals("AuthorList")) {
            this.author = this.join(this.authors.toArray(), " and ");
            this.inAuthorList = false;
        } else if (localName.equals("Author")) {
            if (this.forename.length() == 3 && this.forename.charAt(1) == ' ') {
                this.forename = this.initials;
            }
            this.author = this.forename + " " + this.lastname;
            this.authors.add(this.author);
            this.inAuthor = false;
            this.forename = "";
            this.initials = "";
            this.lastname = "";
        } else if (localName.equals("DescriptorName")) {
            this.inDescriptorName = false;
        } else if (localName.equals("QualifierName")) {
            this.inQualifierName = false;
        } else if (localName.equals("MeshHeading")) {
            this.inMeshHeader = false;
            if (this.minorTopics.equals("")) {
                this.descriptors.add(this.majorTopic);
            } else {
                this.descriptors.add(this.majorTopic + ", " + this.minorTopics);
            }
        } else if (localName.equals("LastName")) {
            this.inLastName = false;
        } else if (localName.equals("ForeName") || localName.equals("FirstName")) {
            this.inForename = false;
        } else if (localName.equals("Issue")) {
            this.inIssue = false;
        } else if (localName.equals("MedlinePgn")) {
            this.inMedlinePgn = false;
        } else if (localName.equals("URL")) {
            this.inUrl = false;
        } else if (localName.equals("Initials")) {
            this.inInitials = false;
        } else if (localName.equals("AbstractText")) {
            this.inAbstractText = false;
        } else if (localName.equals("Affiliation")) {
            this.inAffiliation = false;
        } else if (localName.equals("ArticleId")) {
            if (this.inDoi) {
                this.inDoi = false;
            } else if (this.inPii) {
                this.inPii = false;
            }
        }
    }

    @Override
    public void characters(char[] data, int start, int length) {
        if (this.inTitle) {
            this.title = this.title + new String(data, start, length);
        } else if (this.inYear) {
            this.year = this.year + new String(data, start, length);
        } else if (this.inJournal) {
            this.journal = this.journal + new String(data, start, length);
        } else if (this.inMonth) {
            this.month = this.month + new String(data, start, length);
        } else if (this.inVolume) {
            this.volume = this.volume + new String(data, start, length);
        } else if (this.inLanguage) {
            this.language = this.language + new String(data, start, length).toLowerCase();
        } else if (this.inPst) {
            this.pst = this.pst + new String(data, start, length);
        } else if (this.inLastName) {
            this.lastname = this.lastname + new String(data, start, length);
        } else if (this.inInitials) {
            this.initials = this.initials + new String(data, start, length);
        } else if (this.inIssue) {
            this.number = this.number + new String(data, start, length);
        } else if (this.inMedlinePgn) {
            this.page = this.page + new String(data, start, length);
        } else if (this.inMedlineID) {
            this.medlineID = this.medlineID + new String(data, start, length);
        } else if (this.inURL) {
            this.url = this.url + new String(data, start, length);
        } else if (this.inPubMedID) {
            this.pubmedid = new String(data, start, length);
        } else if (this.inQualifierName) {
            if (!this.minorTopics.equals("")) {
                this.minorTopics = this.minorTopics + "/";
            }
            this.minorTopics = this.minorTopics + new String(data, start, length);
        } else if (this.inDescriptorName) {
            this.majorTopic = new String(data, start, length);
        } else if (this.inForename) {
            this.forename = this.forename + new String(data, start, length);
        } else if (this.inAbstractText) {
            this.abstractText = this.abstractText + new String(data, start, length);
        } else if (this.inMedlineDate) {
            this.MedlineDate = this.MedlineDate + new String(data, start, length);
        } else if (this.inDoi) {
            this.doi = new String(data, start, length);
        } else if (this.inPii) {
            this.pii = new String(data, start, length);
        } else if (this.inAffiliation) {
            this.affiliation = new String(data, start, length);
        }
    }

    public String fixPageRange(String pageRange) {
        int lfirst;
        int minusPos = pageRange.indexOf(45);
        if (minusPos < 0) {
            return pageRange;
        }
        String first = pageRange.substring(0, minusPos).trim();
        String last = pageRange.substring(minusPos + 1).trim();
        int llast = last.length();
        if (llast < (lfirst = first.length())) {
            last = first.substring(0, lfirst - llast) + last;
        }
        return first + "--" + last;
    }
}

