/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.groups;

import java.util.Vector;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.Globals;
import net.sf.jabref.Util;
import net.sf.jabref.groups.AbstractGroup;
import net.sf.jabref.groups.AllEntriesGroup;
import net.sf.jabref.groups.GroupTreeNode;
import net.sf.jabref.groups.KeywordGroup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VersionHandling {
    public static final int CURRENT_VERSION = 3;

    public static GroupTreeNode importFlatGroups(Vector<String> groups) throws IllegalArgumentException {
        GroupTreeNode root = new GroupTreeNode(new AllEntriesGroup());
        int number = groups.size() / 3;
        for (int i = 0; i < number; ++i) {
            String field = groups.get(3 * i + 0);
            String name = groups.get(3 * i + 1);
            String regexp = groups.get(3 * i + 2);
            root.add(new GroupTreeNode(new KeywordGroup(name, field, regexp, false, true, 0)));
        }
        return root;
    }

    public static GroupTreeNode importGroups(Vector<String> orderedData, BibtexDatabase db, int version) throws Exception {
        switch (version) {
            case 0: 
            case 1: {
                return Version0_1.fromString(orderedData.firstElement(), db, version);
            }
            case 2: 
            case 3: {
                return Version2_3.fromString(orderedData, db, version);
            }
        }
        throw new IllegalArgumentException(Globals.lang("Failed to read groups data (unsupported version: %0)", "" + version));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Version2_3 {
        private Version2_3() {
        }

        private static GroupTreeNode fromString(Vector<String> data, BibtexDatabase db, int version) throws Exception {
            GroupTreeNode cursor = null;
            GroupTreeNode root = null;
            for (int i = 0; i < data.size(); ++i) {
                String s = data.elementAt(i).toString();
                int spaceIndex = s.indexOf(32);
                if (spaceIndex <= 0) {
                    throw new Exception("bad format");
                }
                int level = Integer.parseInt(s.substring(0, spaceIndex));
                AbstractGroup group = AbstractGroup.fromString(s.substring(spaceIndex + 1), db, version);
                GroupTreeNode newNode = new GroupTreeNode(group);
                if (cursor == null) {
                    root = cursor = newNode;
                    continue;
                }
                while (level <= cursor.getLevel()) {
                    cursor = (GroupTreeNode)cursor.getParent();
                }
                cursor.add(newNode);
                cursor = newNode;
            }
            return root;
        }
    }

    private static class Version0_1 {
        private Version0_1() {
        }

        private static GroupTreeNode fromString(String s, BibtexDatabase db, int version) throws Exception {
            GroupTreeNode root = null;
            while (s.length() > 0) {
                int i;
                GroupTreeNode newNode;
                if (s.startsWith("(")) {
                    String subtree = Version0_1.getSubtree(s);
                    newNode = Version0_1.fromString(subtree, db, version);
                    i = 3 + subtree.length();
                    s = i >= s.length() ? "" : s.substring(i);
                } else {
                    i = Version0_1.indexOfUnquoted(s, ',');
                    String g = i < 0 ? s : s.substring(0, i);
                    s = i >= 0 ? s.substring(i + 1) : "";
                    newNode = new GroupTreeNode(AbstractGroup.fromString(Util.unquote(g, '\\'), db, version));
                }
                if (root == null) {
                    root = newNode;
                    continue;
                }
                root.add(newNode);
            }
            return root;
        }

        private static String getSubtree(String s) {
            int level = 1;
            block5: for (int i = 1; i < s.length(); ++i) {
                switch (s.charAt(i)) {
                    case '\\': {
                        ++i;
                        continue block5;
                    }
                    case '(': {
                        ++level;
                        continue block5;
                    }
                    case ')': {
                        if (--level != 0) continue block5;
                        return s.substring(1, i);
                    }
                }
            }
            return "";
        }

        private static int indexOfUnquoted(String s, char c) {
            for (int i = 0; i < s.length(); ++i) {
                if (s.charAt(i) == '\\') {
                    ++i;
                    continue;
                }
                if (s.charAt(i) != c) continue;
                return i;
            }
            return -1;
        }
    }
}

