/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.groups;

import javax.swing.undo.AbstractUndoableEdit;
import net.sf.jabref.Globals;
import net.sf.jabref.groups.AbstractGroup;
import net.sf.jabref.groups.GroupSelector;
import net.sf.jabref.groups.GroupTreeNode;

public class UndoableModifyGroup
extends AbstractUndoableEdit {
    private final GroupSelector m_groupSelector;
    private final AbstractGroup m_oldGroupBackup;
    private final AbstractGroup m_newGroupBackup;
    private final GroupTreeNode m_groupsRootHandle;
    private final int[] m_pathToNode;

    public UndoableModifyGroup(GroupSelector gs, GroupTreeNode groupsRoot, GroupTreeNode node, AbstractGroup newGroup) {
        this.m_groupSelector = gs;
        this.m_oldGroupBackup = node.getGroup().deepCopy();
        this.m_newGroupBackup = newGroup.deepCopy();
        this.m_pathToNode = node.getIndexedPath();
        this.m_groupsRootHandle = groupsRoot;
    }

    public String getUndoPresentationName() {
        return Globals.lang("Undo") + ": " + Globals.lang("modify group");
    }

    public String getRedoPresentationName() {
        return Globals.lang("Redo") + ": " + Globals.lang("modify group");
    }

    public void undo() {
        super.undo();
        this.m_groupsRootHandle.getDescendant(this.m_pathToNode).setGroup(this.m_oldGroupBackup.deepCopy());
        this.m_groupSelector.revalidateGroups();
    }

    public void redo() {
        super.redo();
        this.m_groupsRootHandle.getDescendant(this.m_pathToNode).setGroup(this.m_newGroupBackup.deepCopy());
        this.m_groupSelector.revalidateGroups();
    }
}

