/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.export;

import java.awt.event.ActionEvent;
import net.sf.jabref.BasePanel;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.MnemonicAwareAction;
import net.sf.jabref.Worker;
import spin.Spin;

public class SaveAllAction
extends MnemonicAwareAction
implements Worker {
    private JabRefFrame frame;
    private int databases = 0;
    private int saved = 0;

    public SaveAllAction(JabRefFrame frame) {
        super(GUIGlobals.getImage("saveAll"));
        this.frame = frame;
        this.putValue("AcceleratorKey", Globals.prefs.getKey("Save all"));
        this.putValue("ShortDescription", Globals.lang("Save all open databases"));
        this.putValue("Name", "Save all");
    }

    public void actionPerformed(ActionEvent e) {
        this.databases = this.frame.getTabbedPane().getTabCount();
        this.saved = 0;
        this.frame.output(Globals.lang("Saving all databases..."));
        Spin.off(this);
        this.run();
        this.frame.output(Globals.lang("Save all finished."));
    }

    public void run() {
        for (int i = 0; i < this.databases; ++i) {
            if (i >= this.frame.getTabbedPane().getTabCount()) continue;
            BasePanel panel = this.frame.baseAt(i);
            if (panel.getFile() == null) {
                this.frame.showBaseAt(i);
            }
            panel.runCommand("save");
            ++this.saved;
        }
    }
}

