/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import net.sf.jabref.EntryEditor;
import net.sf.jabref.FieldEditor;
import net.sf.jabref.Globals;

public class SimpleUrlDragDrop
implements DropTargetListener {
    private static Logger logger = Logger.getLogger(SimpleUrlDragDrop.class.getName());
    private FieldEditor editor;
    private EntryEditor.StoreFieldAction storeFieldAction;

    public SimpleUrlDragDrop(FieldEditor _editor, EntryEditor.StoreFieldAction _storeFieldAction) {
        this.editor = _editor;
        this.storeFieldAction = _storeFieldAction;
    }

    public void dragEnter(DropTargetDragEvent dtde) {
    }

    public void dragOver(DropTargetDragEvent dtde) {
    }

    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    public void dragExit(DropTargetEvent dte) {
    }

    public void drop(DropTargetDropEvent dtde) {
        Transferable tsf = dtde.getTransferable();
        dtde.acceptDrop(3);
        DataFlavor dtURL = null;
        try {
            dtURL = new DataFlavor("application/x-java-url; class=java.net.URL");
        }
        catch (ClassNotFoundException e) {
            logger.log(Level.WARNING, "Class not found for DnD... should not happen", e);
        }
        try {
            URL url = (URL)tsf.getTransferData(dtURL);
            this.editor.setText(url.toString());
            this.storeFieldAction.actionPerformed(new ActionEvent(this.editor, 0, ""));
            return;
        }
        catch (UnsupportedFlavorException nfe) {
            JOptionPane.showMessageDialog((Component)((Object)this.editor), Globals.lang("Operation not supported"), Globals.lang("Drag and Drop Error"), 0);
            logger.log(Level.WARNING, "Transfer exception", nfe);
        }
        catch (IOException ioex) {
            logger.log(Level.WARNING, "!should not happen!", ioex);
        }
    }
}

