/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.Globals;
import net.sf.jabref.HelpAction;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.JabRefPreferences;
import net.sf.jabref.PrefsTab;

public class FileTab
extends JPanel
implements PrefsTab {
    JabRefPreferences _prefs;
    JabRefFrame _frame;
    private JCheckBox backup;
    private JCheckBox openLast;
    private JCheckBox autoDoubleBraces;
    private JCheckBox autoSave;
    private JCheckBox promptBeforeUsingAutoSave;
    private JRadioButton saveOriginalOrder;
    private JRadioButton saveAuthorOrder;
    private JRadioButton saveTableOrder;
    private JRadioButton exportOriginalOrder;
    private JRadioButton exportAuthorOrder;
    private JRadioButton exportTableOrder;
    private JRadioButton resolveStringsStandard;
    private JRadioButton resolveStringsAll;
    private JTextField bracesAroundCapitalsFields;
    private JTextField nonWrappableFields;
    private JTextField doNotResolveStringsFor;
    private JSpinner autoSaveInterval;
    private boolean origAutoSaveSetting = false;
    private HelpAction autosaveHelp;

    public FileTab(JabRefFrame frame, JabRefPreferences prefs) {
        this._prefs = prefs;
        this._frame = frame;
        this.autosaveHelp = new HelpAction(frame.helpDiag, GUIGlobals.autosaveHelp, "Help", GUIGlobals.getIconUrl("helpSmall"));
        this.openLast = new JCheckBox(Globals.lang("Open last edited databases at startup"));
        this.backup = new JCheckBox(Globals.lang("Backup old file when saving"));
        this.saveAuthorOrder = new JRadioButton(Globals.lang("Save ordered by author/editor/year"));
        this.exportAuthorOrder = new JRadioButton(Globals.lang("Export ordered by author/editor/year"));
        this.saveOriginalOrder = new JRadioButton(Globals.lang("Save entries in their original order"));
        this.exportOriginalOrder = new JRadioButton(Globals.lang("Export entries in their original order"));
        this.saveTableOrder = new JRadioButton(Globals.lang("Save in current table sort order"));
        this.exportTableOrder = new JRadioButton(Globals.lang("Export in current table sort order"));
        this.autoSave = new JCheckBox(Globals.lang("Autosave"));
        this.promptBeforeUsingAutoSave = new JCheckBox(Globals.lang("Prompt before recovering a database from an autosave file"));
        this.autoSaveInterval = new JSpinner(new SpinnerNumberModel(1, 1, 60, 1));
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.saveAuthorOrder);
        bg.add(this.saveOriginalOrder);
        bg.add(this.saveTableOrder);
        bg = new ButtonGroup();
        bg.add(this.exportAuthorOrder);
        bg.add(this.exportOriginalOrder);
        bg.add(this.exportTableOrder);
        this.resolveStringsAll = new JRadioButton(Globals.lang("Resolve strings for all fields except") + ":");
        this.resolveStringsStandard = new JRadioButton(Globals.lang("Resolve strings for standard BibTeX fields only"));
        bg = new ButtonGroup();
        bg.add(this.resolveStringsAll);
        bg.add(this.resolveStringsStandard);
        this.bracesAroundCapitalsFields = new JTextField(25);
        this.nonWrappableFields = new JTextField(25);
        this.doNotResolveStringsFor = new JTextField(30);
        this.autoDoubleBraces = new JCheckBox(Globals.lang("Remove double braces around BibTeX fields when loading."));
        this.autoSave.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                FileTab.this.autoSaveInterval.setEnabled(FileTab.this.autoSave.isSelected());
                FileTab.this.promptBeforeUsingAutoSave.setEnabled(FileTab.this.autoSave.isSelected());
            }
        });
        FormLayout layout = new FormLayout("left:pref, 4dlu, fill:pref", "");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        builder.appendSeparator(Globals.lang("General"));
        builder.nextLine();
        builder.append((Component)this.openLast, 3);
        builder.nextLine();
        builder.append((Component)this.backup, 3);
        builder.nextLine();
        builder.append((Component)this.autoDoubleBraces, 3);
        builder.nextLine();
        JLabel label = new JLabel(Globals.lang("Store the following fields with braces around capital letters") + ":");
        builder.append(label);
        builder.append(this.bracesAroundCapitalsFields);
        builder.nextLine();
        label = new JLabel(Globals.lang("Do not wrap the following fields when saving") + ":");
        builder.append(label);
        builder.append(this.nonWrappableFields);
        builder.nextLine();
        builder.append((Component)this.resolveStringsStandard, 3);
        builder.nextLine();
        builder.append(this.resolveStringsAll);
        builder.append(this.doNotResolveStringsFor);
        builder.nextLine();
        builder.appendSeparator(Globals.lang("Autosave"));
        builder.append((Component)this.autoSave, 1);
        JButton hlp = new JButton(this.autosaveHelp);
        hlp.setText(null);
        hlp.setPreferredSize(new Dimension(24, 24));
        JPanel hPan = new JPanel();
        hPan.setLayout(new BorderLayout());
        hPan.add((Component)hlp, "East");
        builder.append(hPan);
        builder.nextLine();
        builder.append(Globals.lang("Autosave interval (minutes)") + ":");
        builder.append(this.autoSaveInterval);
        builder.nextLine();
        builder.append(this.promptBeforeUsingAutoSave);
        builder.nextLine();
        builder.appendSeparator(Globals.lang("Sort order"));
        builder.append((Component)this.saveAuthorOrder, 1);
        builder.append((Component)this.exportAuthorOrder, 1);
        builder.nextLine();
        builder.append((Component)this.saveTableOrder, 1);
        builder.append((Component)this.exportTableOrder, 1);
        builder.nextLine();
        builder.append((Component)this.saveOriginalOrder, 1);
        builder.append((Component)this.exportOriginalOrder, 1);
        builder.nextLine();
        JPanel pan = builder.getPanel();
        pan.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.setLayout(new BorderLayout());
        this.add((Component)pan, "Center");
    }

    public void setValues() {
        this.openLast.setSelected(this._prefs.getBoolean("openLastEdited"));
        this.backup.setSelected(this._prefs.getBoolean("backup"));
        if (this._prefs.getBoolean("saveInStandardOrder")) {
            this.saveAuthorOrder.setSelected(true);
        } else if (this._prefs.getBoolean("saveInOriginalOrder")) {
            this.saveOriginalOrder.setSelected(true);
        } else {
            this.saveTableOrder.setSelected(true);
        }
        if (this._prefs.getBoolean("exportInStandardOrder")) {
            this.exportAuthorOrder.setSelected(true);
        } else if (this._prefs.getBoolean("exportInOriginalOrder")) {
            this.exportOriginalOrder.setSelected(true);
        } else {
            this.exportTableOrder.setSelected(true);
        }
        this.autoDoubleBraces.setSelected(this._prefs.getBoolean("autoDoubleBraces"));
        this.resolveStringsAll.setSelected(this._prefs.getBoolean("resolveStringsAllFields"));
        this.resolveStringsStandard.setSelected(!this.resolveStringsAll.isSelected());
        this.doNotResolveStringsFor.setText(this._prefs.get("doNotResolveStringsFor"));
        this.bracesAroundCapitalsFields.setText(this._prefs.get("putBracesAroundCapitals"));
        this.nonWrappableFields.setText(this._prefs.get("nonWrappableFields"));
        this.autoSave.setSelected(this._prefs.getBoolean("autoSave"));
        this.promptBeforeUsingAutoSave.setSelected(this._prefs.getBoolean("promptBeforeUsingAutosave"));
        this.autoSaveInterval.setValue(this._prefs.getInt("autoSaveInterval"));
        this.origAutoSaveSetting = this.autoSave.isSelected();
    }

    public void storeSettings() {
        this._prefs.putBoolean("backup", this.backup.isSelected());
        this._prefs.putBoolean("openLastEdited", this.openLast.isSelected());
        this._prefs.putBoolean("saveInStandardOrder", this.saveAuthorOrder.isSelected());
        this._prefs.putBoolean("saveInOriginalOrder", this.saveOriginalOrder.isSelected());
        this._prefs.putBoolean("exportInStandardOrder", this.exportAuthorOrder.isSelected());
        this._prefs.putBoolean("exportInOriginalOrder", this.exportOriginalOrder.isSelected());
        this._prefs.putBoolean("autoDoubleBraces", this.autoDoubleBraces.isSelected());
        this._prefs.putBoolean("resolveStringsAllFields", this.resolveStringsAll.isSelected());
        this._prefs.put("doNotResolveStringsFor", this.doNotResolveStringsFor.getText().trim());
        this._prefs.putBoolean("autoSave", this.autoSave.isSelected());
        this._prefs.putBoolean("promptBeforeUsingAutosave", this.promptBeforeUsingAutoSave.isSelected());
        this._prefs.putInt("autoSaveInterval", (Integer)this.autoSaveInterval.getValue());
        this.doNotResolveStringsFor.setText(this._prefs.get("doNotResolveStringsFor"));
        boolean updateSpecialFields = false;
        if (!this.bracesAroundCapitalsFields.getText().trim().equals(this._prefs.get("putBracesAroundCapitals"))) {
            this._prefs.put("putBracesAroundCapitals", this.bracesAroundCapitalsFields.getText());
            updateSpecialFields = true;
        }
        if (!this.nonWrappableFields.getText().trim().equals(this._prefs.get("nonWrappableFields"))) {
            this._prefs.put("nonWrappableFields", this.nonWrappableFields.getText());
            updateSpecialFields = true;
        }
        if (updateSpecialFields) {
            this._prefs.updateSpecialFieldHandling();
        }
        if (!this.origAutoSaveSetting && this.autoSave.isSelected()) {
            Globals.startAutoSaveManager(this._frame);
        } else if (this.origAutoSaveSetting && !this.autoSave.isSelected()) {
            Globals.stopAutoSaveManager();
        }
    }

    public boolean readyToClose() {
        return true;
    }

    public String getTabName() {
        return Globals.lang("File");
    }
}

