/*
 * Decompiled with CFR 0.152.
 */
package gnu.dtools.ritopt;

import gnu.dtools.ritopt.Option;
import gnu.dtools.ritopt.OptionEvent;
import gnu.dtools.ritopt.OptionListener;
import gnu.dtools.ritopt.OptionModificationException;
import gnu.dtools.ritopt.OptionNotifier;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class NotifyOption
extends Option
implements OptionNotifier {
    private String value = "";
    private String command = "Default";
    private List<OptionListener> listeners;

    public NotifyOption() {
        this("");
    }

    public NotifyOption(OptionListener listener) {
        this(listener, "Default");
    }

    public NotifyOption(OptionListener listener, String command) {
        this(listener, command, "");
    }

    public NotifyOption(OptionListener listener, String command, String value) {
        this(value);
        this.command = command;
        this.listeners.add(listener);
    }

    public NotifyOption(NotifyOption op) {
        super(op);
        op.value = op.getValue();
        this.listeners = new ArrayList<OptionListener>(op.listeners);
    }

    public NotifyOption(String value) {
        this(value, null);
    }

    public NotifyOption(String value, String longOption) {
        this(value, longOption, '\u0000');
    }

    public NotifyOption(String value, char shortOption) {
        this(value, null, shortOption);
    }

    public NotifyOption(String value, String longOption, char shortOption) {
        super(longOption, shortOption);
        this.value = value;
        this.listeners = new ArrayList<OptionListener>();
    }

    public Object getObject() {
        return this.value;
    }

    public void modify(String value) throws OptionModificationException {
        this.value = value;
        Iterator<OptionListener> iterator = this.listeners.iterator();
        OptionEvent event = new OptionEvent(this.command, value, this);
        while (iterator.hasNext()) {
            OptionListener listener = iterator.next();
            listener.optionInvoked(event);
        }
    }

    public void setValue(String value) throws OptionModificationException {
        this.modify(value);
    }

    public String getValue() {
        return this.value;
    }

    public String getStringValue() {
        return this.value;
    }

    public String getTypeName() {
        return "NOTIFY";
    }

    public void addOptionListener(OptionListener listener) {
        this.listeners.add(listener);
    }

    public void removeOptionListener(OptionListener listener) {
        this.listeners.remove(listener);
    }

    public void setOptionCommand(String command) {
        this.command = command;
    }

    public String toString() {
        return this.value;
    }
}

