/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.pd;

import de.intarsys.pdf.cos.COSArray;
import de.intarsys.pdf.cos.COSDictionary;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSNumber;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.pd.PDFunction;
import de.intarsys.pdf.pd.PDShading;

public class PDAxialShading
extends PDShading {
    private static final COSName DK_Coords = COSName.constant("Coords");
    private static final COSName DK_Domain = COSName.constant("Domain");
    private static final COSName DK_Extend = COSName.constant("Extend");
    private static final COSName DK_Function = COSName.constant("Function");
    public static final MetaClass META = new MetaClass((Class)MetaClass.class.getDeclaringClass());
    private float[] coords;
    private float[] domain;
    private boolean[] extend;
    private PDFunction function;

    protected PDAxialShading(COSObject object) {
        super(object);
        COSArray cosCoords = object.asDictionary().get(DK_Coords).asArray();
        this.coords = new float[4];
        int index = 0;
        while (index < 4) {
            this.coords[index] = ((COSNumber)cosCoords.get(index)).floatValue();
            ++index;
        }
        COSObject cosDomain = object.asDictionary().get(DK_Domain);
        if (cosDomain.isNull()) {
            this.domain = new float[]{0.0f, 1.0f};
        } else {
            this.domain = new float[2];
            index = 0;
            while (index < 2) {
                this.domain[index] = ((COSNumber)cosDomain.asArray().get(index)).floatValue();
                ++index;
            }
        }
        COSObject cosExtend = object.asDictionary().get(DK_Extend);
        if (cosExtend.isNull()) {
            this.extend = new boolean[2];
        } else {
            this.extend = new boolean[2];
            index = 0;
            while (index < 2) {
                this.extend[index] = cosExtend.asArray().get(index).asBoolean().booleanValue();
                ++index;
            }
        }
    }

    public float[] getCoords() {
        return this.coords;
    }

    public float[] getDomain() {
        return this.domain;
    }

    public PDFunction getFunction() {
        if (this.function == null) {
            this.function = (PDFunction)PDFunction.META.createFromCos(((COSDictionary)this.cosGetObject()).get(DK_Function));
        }
        return this.function;
    }

    public int getShadingType() {
        return 2;
    }

    public static class MetaClass
    extends PDShading.MetaClass {
        protected MetaClass(Class paramInstanceClass) {
            super(paramInstanceClass);
        }
    }
}

