/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.font;

import de.intarsys.pdf.font.PDFontDescriptor;
import de.intarsys.pdf.pd.AbstractBitFlags;

public class FontDescriptorFlags
extends AbstractBitFlags {
    public static final int Bit_FixedPitch = 1;
    public static final int Bit_Serif = 2;
    public static final int Bit_Symbolic = 4;
    public static final int Bit_Script = 8;
    public static final int Bit_Nonsymbolic = 32;
    public static final int Bit_Italic = 64;
    public static final int Bit_AllCap = 65536;
    public static final int Bit_SmallCap = 131072;
    public static final int Bit_ForceBold = 262144;
    private PDFontDescriptor fontDescriptor;

    public FontDescriptorFlags(int value) {
        super(value);
    }

    public FontDescriptorFlags(PDFontDescriptor fontDescriptor) {
        super(fontDescriptor, null);
        this.fontDescriptor = fontDescriptor;
    }

    protected PDFontDescriptor getFontDescriptor() {
        return this.fontDescriptor;
    }

    protected int getValueInObject() {
        return this.getFontDescriptor().getFlagsValue();
    }

    public boolean isAllCap() {
        return this.isSetAnd(65536);
    }

    public boolean isFixedPitch() {
        return this.isSetAnd(1);
    }

    public boolean isForceBold() {
        return this.isSetAnd(262144);
    }

    public boolean isItalic() {
        return this.isSetAnd(64);
    }

    public boolean isNonsymbolic() {
        return this.isSetAnd(32);
    }

    public boolean isScript() {
        return this.isSetAnd(8);
    }

    public boolean isSerif() {
        return this.isSetAnd(2);
    }

    public boolean isSmallCap() {
        return this.isSetAnd(131072);
    }

    public boolean isSymbolic() {
        return this.isSetAnd(4);
    }

    public void setAllCap(boolean flag) {
        this.set(65536, flag);
    }

    public void setFixedPitch(boolean flag) {
        this.set(1, flag);
    }

    public void setForceBold(boolean flag) {
        this.set(262144, flag);
    }

    public void setItalic(boolean flag) {
        this.set(64, flag);
    }

    public void setNonsymbolic(boolean flag) {
        this.set(32, flag);
        this.set(4, !flag);
    }

    public void setScript(boolean flag) {
        this.set(8, flag);
    }

    public void setSerif(boolean flag) {
        this.set(2, flag);
    }

    public void setSmallCap(boolean flag) {
        this.set(131072, flag);
    }

    public void setSymbolic(boolean flag) {
        this.set(4, flag);
        this.set(32, !flag);
    }

    protected void setValueInObject(int newValue) {
        this.getFontDescriptor().setFlagsValue(newValue);
    }
}

