/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.string;

import de.intarsys.tools.file.FileTools;
import de.intarsys.tools.string.ConverterException;
import de.intarsys.tools.string.StringTools;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

public class Converter {
    public static final String ELEMENT_SEPARATOR = ";";
    public static final String KEY_VALUE_SEPARATOR = "=";

    public static boolean asBoolean(String booleanString) throws ConverterException {
        if ((booleanString = booleanString.toLowerCase().trim()).equals("false") || booleanString.equals("f") || booleanString.equals("no") || booleanString.equals("n") || booleanString.equals("0") || booleanString.equals("falsch") || booleanString.equals("nein")) {
            return false;
        }
        if (booleanString.equals("true") || booleanString.equals("t") || booleanString.equals("yes") || booleanString.equals("y") || booleanString.equals("1") || booleanString.equals("wahr") || booleanString.equals("w") || booleanString.equals("ja") || booleanString.equals("j")) {
            return true;
        }
        throw new ConverterException("Can't parse boolean string: " + booleanString + " to a legal value");
    }

    public static boolean asBoolean(String booleanString, boolean defaultValue) {
        if (StringTools.isEmpty(booleanString)) {
            return defaultValue;
        }
        try {
            return Converter.asBoolean(booleanString);
        }
        catch (ConverterException e) {
            return defaultValue;
        }
    }

    public static boolean asBooleanChecked(String booleanString, boolean defaultValue) throws ConverterException {
        if (StringTools.isEmpty(booleanString)) {
            return defaultValue;
        }
        return Converter.asBoolean(booleanString);
    }

    public static Class asClass(String str) throws ConverterException {
        if ((str = str.trim()).equals("")) {
            return null;
        }
        try {
            return Class.forName(str);
        }
        catch (ClassNotFoundException cnfe) {
            throw new ConverterException(String.valueOf(str) + " is not a possible Classname!");
        }
    }

    public static double asDouble(String str) throws ConverterException {
        try {
            str = str.trim();
            return Double.parseDouble(str);
        }
        catch (NumberFormatException e) {
            throw new ConverterException("Can't parse number string: " + str + " to a legal value");
        }
    }

    public static double asDouble(String str, double defaultValue) {
        if (StringTools.isEmpty(str)) {
            return defaultValue;
        }
        try {
            return Converter.asDouble(str);
        }
        catch (ConverterException e) {
            return defaultValue;
        }
    }

    public static double asDoubleChecked(String str, double defaultValue) throws ConverterException {
        if (StringTools.isEmpty(str)) {
            return defaultValue;
        }
        return Converter.asDouble(str);
    }

    public static File asFile(String pValue) throws ConverterException {
        String str = pValue.trim();
        if ((str = FileTools.trimPath(str)).equals("")) {
            throw new ConverterException("Parameter " + pValue + " is not a valid Filename");
        }
        try {
            return new File(str);
        }
        catch (NullPointerException e) {
            throw new ConverterException("Can't parse file string: " + str + " to a file");
        }
    }

    public static float asFloat(String str) throws ConverterException {
        try {
            str = str.trim();
            return Float.parseFloat(str);
        }
        catch (NumberFormatException e) {
            throw new ConverterException("Can't parse number string: " + str + " to a legal value");
        }
    }

    public static float asFloat(String str, float defaultValue) {
        if (StringTools.isEmpty(str)) {
            return defaultValue;
        }
        try {
            return Converter.asFloat(str);
        }
        catch (ConverterException e) {
            return defaultValue;
        }
    }

    public static float[] asFloatArray(String value) {
        if (value == null) {
            return null;
        }
        StringTokenizer tk = new StringTokenizer(value, ELEMENT_SEPARATOR, false);
        float[] result = new float[tk.countTokens()];
        int i = 0;
        try {
            while (tk.hasMoreTokens()) {
                String token = tk.nextToken();
                result[i] = Float.parseFloat(token.trim());
                ++i;
            }
        }
        catch (NumberFormatException e) {
            return null;
        }
        return result;
    }

    public static float asFloatChecked(String str, float defaultValue) throws ConverterException {
        if (StringTools.isEmpty(str)) {
            return defaultValue;
        }
        return Converter.asFloat(str);
    }

    public static int[] asIntArray(String value) {
        if (value == null) {
            return null;
        }
        StringTokenizer tk = new StringTokenizer(value, ELEMENT_SEPARATOR, false);
        int[] result = new int[tk.countTokens()];
        int i = 0;
        try {
            while (tk.hasMoreTokens()) {
                String token = tk.nextToken();
                result[i] = Integer.parseInt(token.trim());
                ++i;
            }
        }
        catch (NumberFormatException e) {
            return null;
        }
        return result;
    }

    public static int asInteger(String str) throws ConverterException {
        try {
            str = str.trim();
            return Integer.parseInt(str);
        }
        catch (NumberFormatException e) {
            throw new ConverterException("Can't parse integer string: " + str + " to a legal value");
        }
    }

    public static int asInteger(String str, int defaultValue) {
        if (StringTools.isEmpty(str)) {
            return defaultValue;
        }
        try {
            return Converter.asInteger(str);
        }
        catch (ConverterException e) {
            return defaultValue;
        }
    }

    public static int asIntegerChecked(String str, int defaultValue) throws ConverterException {
        if (StringTools.isEmpty(str)) {
            return defaultValue;
        }
        return Converter.asInteger(str);
    }

    public static long asLong(String str) throws ConverterException {
        try {
            str = str.trim();
            return Long.parseLong(str);
        }
        catch (NumberFormatException e) {
            throw new ConverterException("Can't parse integer string: " + str + " to a legal value");
        }
    }

    public static long asLong(String str, long defaultValue) {
        if (StringTools.isEmpty(str)) {
            return defaultValue;
        }
        try {
            return Converter.asLong(str);
        }
        catch (ConverterException e) {
            return defaultValue;
        }
    }

    public static long asLongChecked(String str, long defaultValue) throws ConverterException {
        if (StringTools.isEmpty(str)) {
            return defaultValue;
        }
        return Converter.asLong(str);
    }

    public static Map asMap(String string) {
        HashMap<String, String> map = new HashMap<String, String>(5);
        if (string == null) {
            return map;
        }
        StringTokenizer tk = new StringTokenizer(string, ELEMENT_SEPARATOR, false);
        while (tk.hasMoreTokens()) {
            String value;
            String key;
            String token = tk.nextToken();
            int i = token.indexOf(KEY_VALUE_SEPARATOR);
            if (i == -1) {
                key = token;
                value = "";
            } else {
                key = token.substring(0, i);
                if (i >= token.length()) {
                    value = "";
                }
                value = token.substring(i + 1);
            }
            map.put(key, value);
        }
        return map;
    }

    public static Map asMapBoolean(String string) {
        Map stringMap = Converter.asMap(string);
        HashMap boolMap = new HashMap(stringMap.size() * 2);
        for (Map.Entry entry : stringMap.entrySet()) {
            Boolean value = Boolean.valueOf((String)entry.getValue());
            boolMap.put(entry.getKey(), value);
        }
        return boolMap;
    }

    public static String asString(String str, String defaultValue) {
        if (StringTools.isEmpty(str)) {
            return defaultValue;
        }
        return str.trim();
    }

    public static String[] asStringArray(String value) {
        if (value == null) {
            return null;
        }
        return value.split(ELEMENT_SEPARATOR);
    }

    public static Boolean asThreeState(String booleanString) throws ConverterException {
        if ((booleanString = booleanString.toLowerCase().trim()).equals("false") || booleanString.equals("f") || booleanString.equals("no") || booleanString.equals("n") || booleanString.equals("0") || booleanString.equals("falsch") || booleanString.equals("nein")) {
            return Boolean.FALSE;
        }
        if (booleanString.equals("true") || booleanString.equals("t") || booleanString.equals("yes") || booleanString.equals("y") || booleanString.equals("1") || booleanString.equals("wahr") || booleanString.equals("w") || booleanString.equals("ja") || booleanString.equals("j")) {
            return Boolean.TRUE;
        }
        if (booleanString.equals("undeterminate") || booleanString.equals("undefined") || booleanString.equals("?") || booleanString.equals("u")) {
            return null;
        }
        throw new ConverterException("Can't parse boolean string: " + booleanString + " to a legal value");
    }

    public static Boolean asThreeState(String booleanString, Boolean defaultValue) {
        if (StringTools.isEmpty(booleanString)) {
            return defaultValue;
        }
        try {
            return Converter.asBoolean(booleanString);
        }
        catch (ConverterException e) {
            return defaultValue;
        }
    }

    private Converter() {
    }
}

