/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cwt.hybrid.image;

import de.intarsys.cwt.hybrid.image.CwtHybridImage;
import de.intarsys.cwt.hybrid.image.ImageIOImageEntry;
import de.intarsys.cwt.image.IImage;
import de.intarsys.cwt.image.IImageEntry;
import de.intarsys.cwt.image.ImageContainer;
import de.intarsys.cwt.image.ImageMetadata;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.stream.StreamTools;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.spi.IIORegistry;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;

public class ImageIOImageContainer
extends ImageContainer {
    private ILocator locator;
    private ImageReader imageReader;
    private ImageInputStream imageStream;
    private ImageReaderSpi provider;
    private int count;
    private ImageMetadata metadata;
    private List imageEntries = new ArrayList();
    private InputStream inputStream;

    public static ImageIOImageContainer createFromLocator(ILocator locator) throws IOException {
        ImageReaderSpi provider = ImageIOImageContainer.lookupProviderBySuffix(locator.getType());
        if (provider == null) {
            throw new IllegalArgumentException("unknown suffix");
        }
        return ImageIOImageContainer.createFromLocator(locator, provider);
    }

    public static ImageIOImageContainer createFromLocator(ILocator locator, ImageReaderSpi provider) throws IOException {
        ImageIOImageContainer container = new ImageIOImageContainer(locator, provider);
        container.open();
        return container;
    }

    public static ImageIOImageContainer createFromLocator(ILocator locator, String formatName) throws IOException {
        ImageReaderSpi provider = ImageIOImageContainer.lookupProviderByFormatName(formatName);
        if (provider == null) {
            throw new IllegalArgumentException("unknown format name");
        }
        return ImageIOImageContainer.createFromLocator(locator, provider);
    }

    protected static ImageReaderSpi lookupProviderByFormatName(String formatName) {
        if (formatName == null) {
            return null;
        }
        Iterator<ImageReaderSpi> iter = IIORegistry.getDefaultInstance().getServiceProviders(ImageReaderSpi.class, true);
        while (iter.hasNext()) {
            ImageReaderSpi provider = iter.next();
            String[] names = provider.getFormatNames();
            int index = 0;
            while (index < names.length) {
                String currentName = names[index];
                if (formatName.equalsIgnoreCase(currentName)) {
                    return provider;
                }
                ++index;
            }
        }
        return null;
    }

    protected static ImageReaderSpi lookupProviderBySuffix(String fileSuffix) {
        if (fileSuffix == null) {
            return null;
        }
        Iterator<ImageReaderSpi> iter = IIORegistry.getDefaultInstance().getServiceProviders(ImageReaderSpi.class, true);
        while (iter.hasNext()) {
            ImageReaderSpi provider = iter.next();
            String[] suffixes = provider.getFileSuffixes();
            int index = 0;
            while (index < suffixes.length) {
                String currentSuffix = suffixes[index];
                if (fileSuffix.equalsIgnoreCase(currentSuffix)) {
                    return provider;
                }
                ++index;
            }
        }
        return null;
    }

    protected ImageIOImageContainer(ILocator locator, ImageReaderSpi provider) {
        this.locator = locator;
        this.provider = provider;
    }

    protected void basicClose() throws IOException {
        if (this.imageReader != null) {
            this.imageReader.dispose();
            this.imageReader = null;
        }
        if (this.imageStream != null) {
            this.imageStream.close();
            this.imageStream = null;
        }
        StreamTools.close((InputStream)this.inputStream);
    }

    public IImageEntry getImageAt(int index) {
        if (index >= this.getImageCount()) {
            throw new IllegalArgumentException("invalid index");
        }
        return (IImageEntry)this.imageEntries.get(index);
    }

    public int getImageCount() {
        return this.count;
    }

    public ILocator getLocator() {
        return this.locator;
    }

    public synchronized ImageMetadata getMetadata() throws IOException {
        if (this.metadata == null) {
            this.metadata = ImageMetadata.createFromImageReader(this.imageReader);
        }
        return this.metadata;
    }

    protected IImage loadImage(int index) throws IOException {
        BufferedImage bufferedImage;
        if (index >= this.getImageCount()) {
            throw new IllegalArgumentException("invalid index");
        }
        if ((bufferedImage = this.imageReader.read(index++)) == null) {
            return null;
        }
        return new CwtHybridImage(bufferedImage);
    }

    protected void open() throws IOException {
        try {
            this.inputStream = this.getLocator().getInputStream();
            this.imageStream = ImageIO.createImageInputStream(this.inputStream);
            this.imageReader = this.provider.createReaderInstance();
            this.imageReader.setInput(this.imageStream);
            this.count = this.imageReader.getNumImages(true);
            int i = 0;
            while (i < this.count) {
                this.imageEntries.add(new ImageIOImageEntry(this, i));
                ++i;
            }
        }
        catch (IOException e) {
            this.basicClose();
            throw e;
        }
        catch (Exception e) {
            this.basicClose();
            throw new IOException("unexpected exception opening file");
        }
    }
}

