/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cwt.swt.image;

import de.intarsys.cwt.awt.image.CwtAwtImageTools;
import de.intarsys.cwt.swt.image.SwtCompatibleRaster;
import de.intarsys.tools.system.SystemTools;
import de.intarsys.tools.valueholder.IValueHolder;
import de.intarsys.tools.valueholder.ObjectValueHolder;
import java.awt.Point;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import sun.awt.image.ByteInterleavedRaster;
import sun.awt.image.BytePackedRaster;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImageConverterAwt2Swt {
    private static Map<ColorSpace, Map<ColorSpace, ColorConvertOp>> ConvertOps = new HashMap<ColorSpace, Map<ColorSpace, ColorConvertOp>>();
    private static OS_Switch OsSwitch = SystemTools.isWindows() ? new OS_Windows() : new OS_Other();
    private BufferedImage bufferedImage;
    private ImageData imageData;

    public static BufferedImage createSwtCompatibleAwtImage(int width, int height, boolean transparent) {
        ComponentColorModel colorModel = transparent ? CwtAwtImageTools.getRgbTransparentColorModel() : CwtAwtImageTools.getRgbColorModel();
        int bands = colorModel.getNumComponents();
        int[] bandOffsets = new int[bands];
        OsSwitch.initializeRgbBandOffsets(bandOffsets);
        if (bandOffsets.length > 3) {
            bandOffsets[3] = 3;
        }
        PixelInterleavedSampleModel sampleModel = new PixelInterleavedSampleModel(0, width, height, bands, width * bands, bandOffsets);
        DataBufferByte dataBuffer = new DataBufferByte(width * height * bands);
        SwtCompatibleRaster raster = new SwtCompatibleRaster(sampleModel, dataBuffer, new Point(0, 0));
        return new BufferedImage(colorModel, raster, false, null);
    }

    protected static Map<ColorSpace, Map<ColorSpace, ColorConvertOp>> getConvertOps() {
        return ConvertOps;
    }

    public ImageConverterAwt2Swt(BufferedImage paramBufferedImage) {
        this.bufferedImage = paramBufferedImage;
    }

    protected void computeValuesFromAwtImage(int depth, IValueHolder palette, IValueHolder scanlinePad, IValueHolder transparentPixel) {
        SampleModel sampleModel = this.getBufferedImage().getSampleModel();
        if (sampleModel.getDataType() != 0) {
            throw new IllegalStateException();
        }
        ColorModel colorModel = this.getBufferedImage().getColorModel();
        if (!colorModel.getColorSpace().isCS_sRGB()) {
            throw new IllegalStateException();
        }
        if (colorModel instanceof ComponentColorModel) {
            if (!(sampleModel instanceof ComponentSampleModel)) {
                throw new IllegalStateException();
            }
            this.computeValuesPaletteDirect((ComponentSampleModel)sampleModel, (ComponentColorModel)colorModel, palette, scanlinePad, transparentPixel);
            return;
        }
        if (colorModel instanceof IndexColorModel) {
            this.computeValuesPaletteIndexed((IndexColorModel)colorModel, depth, palette, scanlinePad, transparentPixel);
            return;
        }
        throw new IllegalStateException();
    }

    protected void computeValuesPaletteDirect(ComponentSampleModel sampleModel, ComponentColorModel colorModel, IValueHolder palette, IValueHolder scanlinePad, IValueHolder transparentPixel) {
        int[] componentSize = colorModel.getComponentSize();
        int index = 0;
        while (index < componentSize.length) {
            if (componentSize[index] != 8) {
                throw new IllegalStateException();
            }
            ++index;
        }
        int[] bandOffsets = sampleModel.getBandOffsets();
        if (bandOffsets.length == 4 && bandOffsets[3] != 3) {
            throw new IllegalStateException();
        }
        PaletteData paletteData = new PaletteData(0xFF0000 >> (bandOffsets[0] << 3), 0xFF0000 >> (bandOffsets[1] << 3), 0xFF0000 >> (bandOffsets[2] << 3));
        palette.set((Object)paletteData);
        scanlinePad.set((Object)3);
    }

    protected void computeValuesPaletteIndexed(IndexColorModel colorModel, int depth, IValueHolder paletteHolder, IValueHolder scanlinePadHolder, IValueHolder transparentPixelHolder) {
        int[] awtRgb = new int[colorModel.getMapSize()];
        colorModel.getRGBs(awtRgb);
        RGB[] swtRgb = new RGB[(int)Math.pow(2.0, depth)];
        int index = 0;
        while (index < awtRgb.length) {
            RGB rgb;
            swtRgb[index] = rgb = new RGB(awtRgb[index] >> 16 & 0xFF, awtRgb[index] >> 8 & 0xFF, awtRgb[index] & 0xFF);
            ++index;
        }
        index = awtRgb.length;
        while (index < swtRgb.length) {
            swtRgb[index] = new RGB(0, 0, 0);
            ++index;
        }
        paletteHolder.set((Object)new PaletteData(swtRgb));
        scanlinePadHolder.set((Object)1);
        transparentPixelHolder.set((Object)colorModel.getTransparentPixel());
    }

    protected void convert(BufferedImage srcImage, BufferedImage destImage) {
        ColorConvertOp matchingConvertOp;
        ColorSpace srcColorSpace = srcImage.getColorModel().getColorSpace();
        ColorSpace destColorSpace = destImage.getColorModel().getColorSpace();
        Map<ColorSpace, ColorConvertOp> srcMatchingConvertOps = ImageConverterAwt2Swt.getConvertOps().get(srcColorSpace);
        if (srcMatchingConvertOps == null) {
            srcMatchingConvertOps = new HashMap<ColorSpace, ColorConvertOp>();
            ImageConverterAwt2Swt.getConvertOps().put(srcColorSpace, srcMatchingConvertOps);
            matchingConvertOp = null;
        } else {
            matchingConvertOp = srcMatchingConvertOps.get(destColorSpace);
        }
        if (matchingConvertOp == null) {
            matchingConvertOp = new ColorConvertOp(null);
            srcMatchingConvertOps.put(destColorSpace, matchingConvertOp);
        }
        matchingConvertOp.filter(srcImage, destImage);
    }

    protected ImageData createImageData() {
        byte[] rgbBytes;
        byte[] alphaBytes;
        WritableRaster raster;
        ColorModel colorModel = this.getBufferedImage().getColorModel();
        int depth = colorModel.getPixelSize();
        if (colorModel.getTransparency() == 3) {
            depth = depth / colorModel.getNumComponents() * colorModel.getNumColorComponents();
        }
        ObjectValueHolder palette = new ObjectValueHolder(null);
        ObjectValueHolder scanlinePad = new ObjectValueHolder((Object)0);
        ObjectValueHolder transparentPixel = new ObjectValueHolder((Object)-1);
        try {
            this.computeValuesFromAwtImage(depth, (IValueHolder)palette, (IValueHolder)scanlinePad, (IValueHolder)transparentPixel);
            raster = this.getBufferedImage().getRaster();
        }
        catch (IllegalStateException ex) {
            BufferedImage newBufferedImage = ImageConverterAwt2Swt.createSwtCompatibleAwtImage(this.getBufferedImage().getWidth(), this.getBufferedImage().getHeight(), colorModel.hasAlpha());
            this.convert(this.getBufferedImage(), newBufferedImage);
            depth = 24;
            palette.set((Object)OsSwitch.createRgbPaletteData());
            scanlinePad.set((Object)3);
            raster = newBufferedImage.getRaster();
        }
        byte[] bytes = raster instanceof SwtCompatibleRaster ? ((SwtCompatibleRaster)raster).getDataStorage() : (raster instanceof ByteInterleavedRaster ? ((ByteInterleavedRaster)raster).getDataStorage() : (raster instanceof BytePackedRaster ? ((BytePackedRaster)raster).getDataStorage() : (byte[])raster.getDataElements(raster.getMinX(), raster.getMinY(), raster.getWidth(), raster.getHeight(), null)));
        if (((PaletteData)palette.get()).isDirect && colorModel.hasAlpha()) {
            alphaBytes = new byte[bytes.length / 4];
            rgbBytes = new byte[bytes.length / 4 * 3];
            int index = 0;
            while (index < alphaBytes.length) {
                rgbBytes[index * 3] = bytes[index * 4];
                rgbBytes[index * 3 + 1] = bytes[index * 4 + 1];
                rgbBytes[index * 3 + 2] = bytes[index * 4 + 2];
                alphaBytes[index] = bytes[index * 4 + 3];
                ++index;
            }
        } else {
            alphaBytes = null;
            rgbBytes = bytes;
        }
        this.imageData = new ImageData(this.getBufferedImage().getWidth(), this.getBufferedImage().getHeight(), depth, (PaletteData)palette.get(), ((Integer)scanlinePad.get()).intValue(), rgbBytes);
        this.imageData.transparentPixel = (Integer)transparentPixel.get();
        if (alphaBytes != null) {
            this.imageData.alphaData = alphaBytes;
        }
        return this.imageData;
    }

    public BufferedImage getBufferedImage() {
        return this.bufferedImage;
    }

    public ImageData getImageData() {
        if (this.imageData == null) {
            this.imageData = this.createImageData();
        }
        return this.imageData;
    }

    static class OS_Other
    implements OS_Switch {
        OS_Other() {
        }

        public PaletteData createRgbPaletteData() {
            return new PaletteData(0xFF0000, 65280, 255);
        }

        public void initializeRgbBandOffsets(int[] bandOffsets) {
            int index = 0;
            while (index < 3) {
                bandOffsets[index] = index;
                ++index;
            }
        }
    }

    static interface OS_Switch {
        public PaletteData createRgbPaletteData();

        public void initializeRgbBandOffsets(int[] var1);
    }

    static class OS_Windows
    implements OS_Switch {
        OS_Windows() {
        }

        public PaletteData createRgbPaletteData() {
            return new PaletteData(255, 65280, 0xFF0000);
        }

        public void initializeRgbBandOffsets(int[] bandOffsets) {
            int index = 0;
            while (index < 3) {
                bandOffsets[index] = 2 - index;
                ++index;
            }
        }
    }
}

