/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cwt.font;

import de.intarsys.cwt.font.FontRegistry;
import de.intarsys.cwt.font.FontTools;
import de.intarsys.cwt.font.GenericFont;
import de.intarsys.cwt.font.IFont;
import de.intarsys.cwt.font.PACKAGE;
import de.intarsys.cwt.freetype.Face;
import de.intarsys.cwt.freetype.Freetype;
import de.intarsys.cwt.freetype.Library;
import de.intarsys.tools.installresource.InstallFileList;
import de.intarsys.tools.locator.FileLocator;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.stream.StreamTools;
import java.awt.Font;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import sun.font.FontManager;

public class FontEnvironment {
    private static final Logger Log = PACKAGE.Log;
    private static FontEnvironment Unique = new FontEnvironment();
    private List<ClassLoader> fontClassLoaders = new ArrayList<ClassLoader>();
    private List<File> fontDirectories = new ArrayList<File>();
    private List<File> fontFiles = new ArrayList<File>();
    private boolean registeredSystem = false;
    private boolean registeredUser = false;

    public static FontEnvironment get() {
        return Unique;
    }

    public static void set(FontEnvironment environment) {
        Unique = environment;
    }

    public FontEnvironment() {
        this.registerFontClassLoader(this.getClass().getClassLoader());
    }

    public synchronized ClassLoader[] getFontClassLoaders() {
        return this.fontClassLoaders.toArray(new ClassLoader[this.fontClassLoaders.size()]);
    }

    public synchronized File[] getFontDirectories() {
        return this.fontDirectories.toArray(new File[this.fontDirectories.size()]);
    }

    public synchronized File[] getFontFiles() {
        return this.fontFiles.toArray(new File[this.fontFiles.size()]);
    }

    public synchronized File[] getSystemFontDirectories() {
        String definition = null;
        Font.decode("dummy").getFamily();
        definition = FontManager.getFontPath((boolean)true);
        if (definition == null) {
            return new File[0];
        }
        String[] names = definition.split(System.getProperty("path.separator"));
        File[] files = new File[names.length];
        int i = 0;
        while (i < names.length) {
            files[i] = new File(names[i]);
            ++i;
        }
        return files;
    }

    protected void loadFontClassLoader(Library library, ClassLoader loader) {
        try {
            InstallFileList installer = new InstallFileList("fonts", "fonts.list", false);
            installer.loadAll();
            File[] roots = installer.getFiles();
            int i = 0;
            while (i < roots.length) {
                File root = roots[i];
                File[] fontFiles = root.listFiles();
                int j = 0;
                while (j < fontFiles.length) {
                    File file = fontFiles[j];
                    try {
                        this.processFontFile(library, file);
                    }
                    catch (IOException e) {
                        Log.log(Level.WARNING, "error loading font '" + file.getName() + "'", e);
                    }
                    ++j;
                }
                ++i;
            }
        }
        catch (IOException e) {
            Log.log(Level.WARNING, "error looking up 'font/fonts.list' resources", e);
        }
    }

    protected void loadFontDirectory(Library library, File directory) {
        if (!directory.exists()) {
            return;
        }
        if (!directory.isDirectory()) {
            return;
        }
        File[] files = directory.listFiles();
        if (files == null) {
            return;
        }
        int i = 0;
        while (i < files.length) {
            File file = files[i];
            this.loadFontFile(library, file);
            ++i;
        }
    }

    protected void loadFontFile(Library library, File file) {
        if (!file.isFile()) {
            return;
        }
        String filepath = file.getAbsolutePath();
        try {
            if (!filepath.equals(file.getCanonicalPath())) {
                return;
            }
        }
        catch (IOException ex) {
            return;
        }
        this.loadFontUnchecked(library, filepath);
    }

    protected void loadFontMapClassLoader(Library library, ClassLoader loader) {
        try {
            Enumeration<URL> urls = loader.getResources("fonts/fonts.maps");
            while (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                InputStream is = null;
                try {
                    try {
                        is = url.openStream();
                        this.parseMaps(library, loader, is);
                    }
                    catch (IOException e) {
                        Log.log(Level.WARNING, "error loading 'fonts/fonts.maps' from '" + url + "'", e);
                        StreamTools.close((InputStream)is);
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    StreamTools.close((InputStream)is);
                    throw throwable;
                }
                StreamTools.close((InputStream)is);
            }
        }
        catch (IOException e) {
            Log.log(Level.WARNING, "error looking up 'font/fonts.maps' resources", e);
        }
    }

    protected IFont loadFontUnchecked(Library library, String filepath) {
        FileLocator locator = new FileLocator(filepath);
        Face face = library.newFace(filepath, 0);
        if (face != null) {
            GenericFont font = null;
            try {
                font = GenericFont.createNew((ILocator)locator, face);
                FontRegistry.get().registerFont(font);
            }
            finally {
                face.doneFace();
            }
            return font;
        }
        return null;
    }

    protected void loadSystemFonts(Library library) {
        File[] files = this.getSystemFontDirectories();
        int i = 0;
        while (i < files.length) {
            File directory = files[i];
            this.loadFontDirectory(library, directory);
            ++i;
        }
    }

    protected void loadUserFonts(Library library) {
        File[] files = this.getFontDirectories();
        int i = 0;
        while (i < files.length) {
            File directory = files[i];
            this.loadFontDirectory(library, directory);
            ++i;
        }
        files = this.getFontFiles();
        i = 0;
        while (i < files.length) {
            File file = files[i];
            this.loadFontFile(library, file);
            ++i;
        }
        ClassLoader[] loaders = this.getFontClassLoaders();
        int i2 = 0;
        while (i2 < loaders.length) {
            ClassLoader loader = loaders[i2];
            this.loadFontClassLoader(library, loader);
            this.loadFontMapClassLoader(library, loader);
            ++i2;
        }
    }

    protected void parseMaps(Library library, ClassLoader loader, InputStream is) throws IOException {
        String map;
        StringBuilder sb = new StringBuilder();
        int i = is.read();
        while (i != -1) {
            if (i == 10) {
                map = sb.toString().trim();
                this.processFontMap(library, loader, map);
                sb.setLength(0);
                i = is.read();
                continue;
            }
            sb.append((char)i);
            i = is.read();
        }
        map = sb.toString().trim();
        this.processFontMap(library, loader, map);
    }

    protected void processFontFile(Library library, File file) throws IOException {
        IFont font = this.loadFontUnchecked(library, file.getAbsolutePath());
        if (font == null) {
            return;
        }
        FontTools.mapFont(font.getFontName(), font);
    }

    protected void processFontMap(Library library, ClassLoader loader, String map) throws IOException {
        if (map.length() == 0 || map.startsWith("#")) {
            return;
        }
        String[] split = map.split("\\=");
        if (split.length < 2) {
            return;
        }
        FontTools.mapAlias(split[0], split[1]);
    }

    public synchronized void registerFontClassLoader(ClassLoader loader) {
        this.fontClassLoaders.add(loader);
    }

    public synchronized void registerFontDirectory(File directory) {
        this.fontDirectories.add(directory);
    }

    public synchronized void registerFontFile(File file) {
        this.fontFiles.add(file);
    }

    public synchronized boolean registerSystemFonts() {
        if (this.registeredSystem) {
            return false;
        }
        this.registeredSystem = true;
        Library library = Freetype.initFreeType();
        try {
            this.loadSystemFonts(library);
        }
        finally {
            library.doneFreeType();
        }
        return true;
    }

    public synchronized boolean registerUserFonts() {
        if (this.registeredUser) {
            return false;
        }
        this.registeredUser = true;
        Library library = Freetype.initFreeType();
        try {
            this.loadUserFonts(library);
        }
        finally {
            library.doneFreeType();
        }
        return true;
    }
}

