/*
 * Decompiled with CFR 0.152.
 */
package splmm.Gui;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import javax.swing.JButton;

public class VerticalButton
extends JButton {
    public VerticalButton(String caption, boolean clockwise) {
        Font f = this.getFont();
        FontMetrics fm = this.getFontMetrics(f);
        int captionHeight = fm.getHeight();
        int captionWidth = fm.stringWidth(caption);
        BufferedImage bi = new BufferedImage(captionHeight + 4, captionWidth + 4, 2);
        Graphics2D g = (Graphics2D)bi.getGraphics();
        g.setColor(new Color(0, 0, 0, 0));
        g.fillRect(0, 0, bi.getWidth(), bi.getHeight());
        g.setColor(this.getForeground());
        g.setFont(f);
        g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        if (clockwise) {
            g.rotate(1.5707963267948966);
        } else {
            g.rotate(-1.5707963267948966);
            g.translate(-bi.getHeight(), bi.getWidth());
        }
        g.drawString(caption, 2, -6);
        ImageIcon icon = new ImageIcon(bi);
        this.setIcon(icon);
        this.setMargin(new Insets(15, 2, 15, 2));
        this.setActionCommand(caption);
    }
}

