/*
 * Decompiled with CFR 0.152.
 */
package freemind.view.mindmapview;

import freemind.main.Tools;
import freemind.modes.MindMapEdge;
import freemind.view.mindmapview.MapView;
import freemind.view.mindmapview.NodeView;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Stroke;

public abstract class EdgeView {
    private NodeView target;
    protected NodeView source;
    protected Point start;
    protected Point end;
    private static int i;
    protected static final BasicStroke DEF_STROKE;
    static Stroke ECLIPSED_STROKE;

    public void paint(NodeView target, Graphics2D g) {
        this.source = target.getVisibleParentView();
        this.target = target;
        this.createEnd();
        this.createStart();
        this.paint(g);
        this.source = null;
        this.target = null;
    }

    protected void createEnd() {
        this.end = this.getTarget().getMainViewInPoint();
        if (this.end != null) {
            Tools.convertPointToAncestor((Component)this.target.getMainView(), this.end, this.source);
        }
    }

    protected void createStart() {
        this.start = this.source.getMainViewOutPoint(this.getTarget(), this.end);
        Tools.convertPointToAncestor((Component)this.source.getMainView(), this.start, this.source);
    }

    protected abstract void paint(Graphics2D var1);

    protected void reset() {
        this.source = null;
        this.target = null;
    }

    public abstract Color getColor();

    public Stroke getStroke() {
        int width = this.getWidth();
        if (width == 0) {
            return DEF_STROKE;
        }
        return new BasicStroke((float)width * this.getMap().getZoom(), 0, 0);
    }

    public int getWidth() {
        return this.getModel().getWidth();
    }

    protected MindMapEdge getModel() {
        return this.getTarget().getModel().getEdge();
    }

    protected MapView getMap() {
        return this.getTarget().getMap();
    }

    protected static Stroke getEclipsedStroke() {
        if (ECLIPSED_STROKE == null) {
            float[] dash = new float[]{3.0f, 9.0f};
            ECLIPSED_STROKE = new BasicStroke(3.0f, 0, 0, 12.0f, dash, 0.0f);
        }
        return ECLIPSED_STROKE;
    }

    protected boolean isTargetEclipsed() {
        return this.getTarget().isParentHidden();
    }

    protected NodeView getSource() {
        return this.source;
    }

    protected NodeView getTarget() {
        return this.target;
    }

    static {
        DEF_STROKE = new BasicStroke();
        ECLIPSED_STROKE = null;
    }
}

